/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.relics;

import com.blorb.morerelics.MoreRelics;
import com.blorb.morerelics.MoreRelicsUtil;
import com.blorb.morerelics.network.PacketHandler;
import com.blorb.morerelics.network.SilkCounterPayload;
import com.blorb.morerelics.network.SoarVelocityPayload;
import com.blorb.morerelics.relics.MoreRelicBase;
import com.mojang.blaze3d.systems.RenderSystem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;

@Mod.EventBusSubscriber
public class WeaversSpool
extends MoreRelicBase {
    public static final ResourceLocation SILK_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"morerelics", (String)"textures/gui/silk/background.png");
    public static final ResourceLocation SILK = ResourceLocation.fromNamespaceAndPath((String)"morerelics", (String)"textures/gui/silk/silk.png");
    public static final int BIND_COST = 6;
    public static final int SOAR_COST = 3;
    public static final int UNRAVEL_COST = 7;

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"weaver").stat(StatData.builder((String)"passive_regen_time").initialValue(7.0, 5.0).upgradeModifier(UpgradeOperation.ADD, -0.5).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(3).requiredLevel(0).build()).ability(AbilityData.builder((String)"bind").stat(StatData.builder((String)"healing_amount").initialValue(2.0, 4.0).upgradeModifier(UpgradeOperation.ADD, 0.5).formatValue(value -> Float.valueOf((float)Math.round(value * 2.0) / 2.0f)).build()).maxLevel(3).active(CastData.builder().type(CastType.INSTANTANEOUS).build()).requiredLevel(0).build()).ability(AbilityData.builder((String)"soar").stat(StatData.builder((String)"leap_power").initialValue((double)1.1f, (double)1.3f).upgradeModifier(UpgradeOperation.ADD, (double)0.1f).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).stat(StatData.builder((String)"speed_duration").initialValue(7.0, 10.0).upgradeModifier(UpgradeOperation.ADD, 2.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(3).active(CastData.builder().type(CastType.INSTANTANEOUS).build()).requiredLevel(3).build()).ability(AbilityData.builder((String)"unravel").stat(StatData.builder((String)"damage").initialValue(4.0, 6.0).upgradeModifier(UpgradeOperation.ADD, 2.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).stat(StatData.builder((String)"slow_duration").initialValue(2.0, 3.0).upgradeModifier(UpgradeOperation.ADD, 0.5).formatValue(value -> Float.valueOf((float)Math.round(value * 2.0) / 2.0f)).build()).maxLevel(3).active(CastData.builder().type(CastType.INSTANTANEOUS).build()).requiredLevel(6).build()).build()).leveling(LevelingData.builder().maxLevel(12).initialCost(140).step(40).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        float regen_time = (float)this.getAbilityValue(stack, "weaver", "passive_regen_time") * 20.0f;
        CompoundTag tag = stack.m_41784_();
        int regenProgress = tag.m_128451_("regen_progress");
        if ((float)regenProgress < regen_time) {
            ++regenProgress;
        } else {
            regenProgress = 0;
            int currentSilk = tag.m_128451_("current_silk");
            if (currentSilk < 3) {
                tag.m_128405_("current_silk", currentSilk + 1);
                this.spreadExperience((LivingEntity)player, stack, 3);
            }
        }
        tag.m_128405_("regen_progress", regenProgress);
    }

    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        int currentSilk = tag.m_128451_("current_silk");
        if (ability.equals("bind") && currentSilk >= 6) {
            this.applyBind(stack, player, tag, currentSilk);
        } else if (ability.equals("soar") && currentSilk >= 3) {
            this.applySoar(stack, player, tag, currentSilk);
        } else if (ability.equals("unravel") && currentSilk >= 7) {
            this.applyUnravel(stack, player, tag, currentSilk);
        }
    }

    private void applyBind(ItemStack stack, Player player, CompoundTag tag, int currentSilk) {
        this.setAbilityCooldown(stack, "bind", 20);
        tag.m_128405_("current_silk", currentSilk - 6);
        player.m_5634_((float)this.getAbilityValue(stack, "bind", "healing_amount"));
        player.m_9236_().m_6263_(null, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, (SoundEvent)MoreRelics.HEAL.get(), SoundSource.MASTER, 1.1f, 1.0f);
        player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 80, 0));
        this.sendSilkCounterPayload(player, currentSilk - 6);
    }

    private void applySoar(ItemStack stack, Player player, CompoundTag tag, int currentSilk) {
        this.setAbilityCooldown(stack, "soar", 20);
        tag.m_128405_("current_silk", currentSilk - 3);
        player.m_9236_().m_6263_(null, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, SoundEvents.f_11893_, SoundSource.MASTER, 0.7f, 1.2f);
        Vec3 lookDirection = player.m_20154_().m_82490_(this.getAbilityValue(stack, "soar", "leap_power"));
        player.m_183634_();
        SoarVelocityPayload soarPayload = new SoarVelocityPayload(lookDirection.f_82479_, lookDirection.f_82480_, lookDirection.f_82481_);
        PacketHandler.sendToPlayer(soarPayload, (ServerPlayer)player);
        player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, (int)(this.getAbilityValue(stack, "soar", "speed_duration") * 20.0), 0));
        this.sendSilkCounterPayload(player, currentSilk - 3);
    }

    private void applyUnravel(ItemStack stack, Player player, CompoundTag tag, int currentSilk) {
        this.setAbilityCooldown(stack, "unravel", 20);
        tag.m_128405_("current_silk", currentSilk - 7);
        Vec3 center = player.m_20182_();
        float radius = 4.0f;
        float damage = (float)this.getAbilityValue(stack, "unravel", "damage");
        float slowDuration = (float)this.getAbilityValue(stack, "unravel", "slow_duration");
        this.spawnSilkParticles(player.m_9236_(), player.m_20182_(), 1, radius);
        AABB area = new AABB(center.f_82479_ - (double)radius, center.f_82480_ - (double)radius, center.f_82481_ - (double)radius, center.f_82479_ + (double)radius, center.f_82480_ + (double)radius, center.f_82481_ + (double)radius);
        List detectedEntities = player.m_9236_().m_45933_((Entity)player, area);
        player.m_9236_().m_6263_(null, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, SoundEvents.f_11928_, SoundSource.MASTER, 0.7f, 0.6f);
        for (Entity detected : detectedEntities) {
            if (!(detected instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)detected;
            if (player == detected) continue;
            livingEntity.m_6469_(new DamageSource(livingEntity.m_269291_().m_269264_().m_269150_(), (Entity)player, (Entity)player), damage);
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, (int)(slowDuration * 20.0f), 2));
        }
        this.sendSilkCounterPayload(player, currentSilk - 7);
    }

    private void sendSilkCounterPayload(Player player, int newSilkAmount) {
        SilkCounterPayload payload = new SilkCounterPayload(newSilkAmount);
        PacketHandler.sendToPlayer(payload, (ServerPlayer)player);
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingHurtEvent event) {
        Player player;
        block3: {
            block2: {
                Entity entity = event.getSource().m_7639_();
                if (!(entity instanceof Player)) break block2;
                player = (Player)entity;
                if (!player.m_9236_().f_46443_) break block3;
            }
            return;
        }
        MoreRelicsUtil.actuallyGetEquippedRelics((LivingEntity)player).forEach(stack -> {
            Item patt11791$temp = stack.m_41720_();
            if (!(patt11791$temp instanceof WeaversSpool)) {
                return;
            }
            WeaversSpool item = (WeaversSpool)patt11791$temp;
            CompoundTag tag = stack.m_41784_();
            int currentSilkAmount = tag.m_128451_("current_silk");
            if (currentSilkAmount < 10) {
                tag.m_128405_("current_silk", currentSilkAmount + 1);
                item.spreadExperience((LivingEntity)player, (ItemStack)stack, 3);
                item.sendSilkCounterPayload(player, currentSilkAmount + 1);
            }
        });
    }

    private void spawnSilkParticles(Level level, Vec3 position, int amplifier, float radius) {
        int particleCount = 30 + amplifier * 60;
        if (particleCount > 400) {
            particleCount = 400;
        }
        ServerLevel sevLevel = (ServerLevel)level;
        List players = level.m_6907_();
        for (ServerPlayer player : players) {
            sevLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123810_, true, position.f_82479_, position.f_82480_ + 1.0, position.f_82481_, particleCount, 0.0, 0.0, 0.0, 0.025 * (double)radius);
        }
    }

    @Mod.EventBusSubscriber(modid="morerelics", value={Dist.CLIENT})
    public static class ClientRender {
        @SubscribeEvent
        public static void renderSilk(RenderGuiEvent.Pre event) {
            boolean hasWeaver;
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (!player.m_9236_().f_46443_) {
                return;
            }
            boolean bl = hasWeaver = !EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)MoreRelics.WEAVERS_SPOOL.get())).m_41619_();
            if (!hasWeaver) {
                return;
            }
            OptionalInt silkAmount = MoreRelicsUtil.actuallyGetEquippedRelics((LivingEntity)player).stream().mapToInt(stack -> {
                Item patt12903$temp = stack.m_41720_();
                if (!(patt12903$temp instanceof WeaversSpool)) {
                    return 0;
                }
                WeaversSpool item = (WeaversSpool)patt12903$temp;
                return stack.m_41784_().m_128451_("current_silk");
            }).max();
            if (silkAmount.isPresent()) {
                ClientRender.drawSilkBar(event.getGuiGraphics(), event.getGuiGraphics().m_280182_(), event.getGuiGraphics().m_280206_(), silkAmount.getAsInt());
            }
        }

        public static void drawSilkBar(GuiGraphics guiGraphics, int screenWidth, int screenHeight, int silkLevel) {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            minecraft.m_91097_().m_174784_(SILK_BACKGROUND);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)SILK_BACKGROUND);
            int barWidth = 20;
            int barHeight = 53;
            int left = screenWidth - (barWidth + 5);
            int top = screenHeight - (barHeight + 5);
            guiGraphics.m_280163_(SILK_BACKGROUND, left, top, 0.0f, 0.0f, barWidth, barHeight, barWidth, barHeight);
            ClientRender.drawSilk(guiGraphics, left, top, barWidth, barHeight, silkLevel);
        }

        public static void drawSilk(GuiGraphics guiGraphics, int left, int top, int barWidth, int barHeight, int silkLevel) {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (!player.m_9236_().f_46443_) {
                return;
            }
            minecraft.m_91097_().m_174784_(SILK);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)SILK);
            int silkHeight = 5;
            int silkStart = top + barHeight - 6 - silkHeight;
            for (int i = 0; i < silkLevel; ++i) {
                guiGraphics.m_280163_(SILK, left, silkStart, 0.0f, 0.0f, barWidth, silkHeight, barWidth, silkHeight);
                silkStart -= 4;
            }
        }
    }
}

