/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.relics;

import com.blorb.morerelics.MoreRelics;
import com.blorb.morerelics.MoreRelicsUtil;
import com.blorb.morerelics.relics.CyberwareBase;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;

@Mod.EventBusSubscriber
public class VertebraX
extends CyberwareBase {
    public static boolean currentlyInPotionEvent = false;

    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"inoculation").maxLevel(0).requiredLevel(0).build()).ability(AbilityData.builder((String)"fortification").stat(StatData.builder((String)"reduction").initialValue(12.0, 20.0).upgradeModifier(UpgradeOperation.ADD, 4.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).stat(StatData.builder((String)"increase").initialValue(25.0, 35.0).upgradeModifier(UpgradeOperation.ADD, 5.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(5).requiredLevel(3).build()).ability(AbilityData.builder((String)"acquired_immunity").maxLevel(0).requiredLevel(5).build()).ability(AbilityData.builder((String)"cyberpsychosis").stat(StatData.builder((String)"chance").initialValue(3.0, 5.0).upgradeModifier(UpgradeOperation.ADD, 1.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).stat(StatData.builder((String)"duration").initialValue(4.0, 7.0).upgradeModifier(UpgradeOperation.ADD, 2.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(3).requiredLevel(5).build()).build()).leveling(LevelingData.builder().maxLevel(8).initialCost(120).step(30).build()).loot(LootData.builder().entry(LootCollections.SCULK).entry(LootCollections.END).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        if (slotContext.entity().m_9236_().f_46443_) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        int poisonApplyCounter = tag.m_128451_("morerelics_apply_poison_counter");
        if (poisonApplyCounter > 0) {
            --poisonApplyCounter;
        } else {
            if (this.canUseAbility(stack, "inoculation")) {
                MobEffectInstance poisonEffect = new MobEffectInstance(MobEffects.f_19614_, 100);
                slotContext.entity().m_7292_(poisonEffect);
                this.spreadExperience(null, stack, 1);
            }
            poisonApplyCounter = 50;
        }
        tag.m_128405_("morerelics_apply_poison_counter", poisonApplyCounter);
    }

    @SubscribeEvent
    public static void EffectAppliedEvent(MobEffectEvent.Applicable event) {
        Player player;
        block5: {
            block4: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block4;
                player = (Player)livingEntity;
                if (!player.m_9236_().f_46443_ && !currentlyInPotionEvent) break block5;
            }
            return;
        }
        currentlyInPotionEvent = true;
        float[] reductionAmount = new float[]{0.0f};
        float[] increaseAmount = new float[]{0.0f};
        boolean[] canTransformPoison = new boolean[]{false};
        MoreRelicsUtil.actuallyGetEquippedRelics((LivingEntity)player).forEach(stack -> {
            boolean hasCyber;
            Item patt5638$temp = stack.m_41720_();
            if (!(patt5638$temp instanceof VertebraX)) {
                return;
            }
            VertebraX item = (VertebraX)patt5638$temp;
            boolean bl = hasCyber = player.m_21023_((MobEffect)MoreRelics.CYBERPSYCHOSIS.get());
            if (item.canUseAbility((ItemStack)stack, "fortification")) {
                reductionAmount[0] = reductionAmount[0] + (float)item.getAbilityValue((ItemStack)stack, "fortification", "reduction") * ((float)hasCyber * 0.5f + 1.0f);
                increaseAmount[0] = increaseAmount[0] + (float)item.getAbilityValue((ItemStack)stack, "fortification", "increase") * ((float)hasCyber * 0.5f + 1.0f);
            }
            if (item.canUseAbility((ItemStack)stack, "acquired_immunity")) {
                canTransformPoison[0] = true;
            }
        });
        MobEffectInstance instance = event.getEffectInstance();
        if (VertebraX.modifyEffect((LivingEntity)player, instance, canTransformPoison, increaseAmount, reductionAmount)) {
            event.setResult(Event.Result.DENY);
        }
        currentlyInPotionEvent = false;
    }

    public static boolean modifyEffect(LivingEntity player, MobEffectInstance instance, boolean[] canTransformPoison, float[] increaseAmount, float[] reductionAmount) {
        if (instance.m_19544_() == MobEffects.f_19620_) {
            return false;
        }
        if (canTransformPoison[0] && instance.m_19544_() == MobEffects.f_19614_) {
            VertebraX.transformPoisonToRegeneration(player, instance, increaseAmount[0]);
        } else if (increaseAmount[0] > 0.0f && instance.m_19544_().m_19483_() == MobEffectCategory.BENEFICIAL) {
            VertebraX.increaseEffectDuration(player, instance, increaseAmount[0]);
        } else if (reductionAmount[0] > 0.0f && instance.m_19544_().m_19483_() == MobEffectCategory.HARMFUL) {
            VertebraX.reduceEffectDuration(player, instance, reductionAmount[0]);
        } else {
            return false;
        }
        return true;
    }

    private static void transformPoisonToRegeneration(LivingEntity player, MobEffectInstance poisonInstance, float increasePercent) {
        int originalDuration = poisonInstance.m_19557_();
        int increasedDuration = (int)((float)originalDuration * (1.0f + increasePercent / 100.0f));
        MobEffectInstance regenEffect = new MobEffectInstance(MobEffects.f_19605_, increasedDuration, poisonInstance.m_19564_(), poisonInstance.m_19571_(), poisonInstance.m_19572_(), poisonInstance.m_19575_());
        player.m_7292_(regenEffect);
    }

    private static void increaseEffectDuration(LivingEntity player, MobEffectInstance instance, float increasePercent) {
        int originalDuration = instance.m_19557_();
        int increasedDuration = (int)((float)originalDuration * (1.0f + increasePercent / 100.0f));
        MobEffectInstance newInstance = new MobEffectInstance(instance.m_19544_(), increasedDuration, instance.m_19564_(), instance.m_19571_(), instance.m_19572_(), instance.m_19575_());
        player.m_7292_(newInstance);
    }

    private static void reduceEffectDuration(LivingEntity player, MobEffectInstance instance, float reductionPercent) {
        int originalDuration = instance.m_19557_();
        int reducedDuration = (int)((float)originalDuration * (1.0f - reductionPercent / 100.0f));
        MobEffectInstance newInstance = new MobEffectInstance(instance.m_19544_(), reducedDuration, instance.m_19564_(), instance.m_19571_(), instance.m_19572_(), instance.m_19575_());
        player.m_7292_(newInstance);
    }
}

