/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.relics;

import com.blorb.morerelics.MoreRelics;
import com.blorb.morerelics.MoreRelicsUtil;
import com.blorb.morerelics.relics.CyberwareBase;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ThermoseismicHeart
extends CyberwareBase {
    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"pyromania").stat(StatData.builder((String)"duration").initialValue(20.0, 30.0).upgradeModifier(UpgradeOperation.ADD, 5.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(3).requiredLevel(0).build()).ability(AbilityData.builder((String)"thermal_discharge").stat(StatData.builder((String)"radius").initialValue(1.0, 2.0).upgradeModifier(UpgradeOperation.ADD, 0.25).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).stat(StatData.builder((String)"damage").initialValue(3.0, 5.0).upgradeModifier(UpgradeOperation.ADD, 1.25).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(4).active(CastData.builder().type(CastType.INSTANTANEOUS).build()).requiredLevel(3).build()).ability(AbilityData.builder((String)"cyberpsychosis").stat(StatData.builder((String)"chance").initialValue(3.0, 5.0).upgradeModifier(UpgradeOperation.ADD, 1.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).stat(StatData.builder((String)"duration").initialValue(4.0, 7.0).upgradeModifier(UpgradeOperation.ADD, 2.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(3).requiredLevel(7).build()).build()).leveling(LevelingData.builder().maxLevel(10).initialCost(100).step(25).build()).loot(LootData.builder().entry(LootCollections.DESERT).build()).build();
    }

    @SubscribeEvent
    public static void onDamageTaken(LivingHurtEvent event) {
        LivingEntity player = event.getEntity();
        if (player.m_9236_().f_46443_) {
            return;
        }
        if (!event.getSource().m_269150_().m_203565_(DamageTypes.f_268565_) && !event.getSource().m_269150_().m_203565_(DamageTypes.f_268448_)) {
            return;
        }
        double overloadTime = MoreRelicsUtil.actuallyGetEquippedRelics(player).stream().mapToDouble(stack -> {
            Item patt5555$temp = stack.m_41720_();
            if (!(patt5555$temp instanceof ThermoseismicHeart)) {
                return 0.0;
            }
            ThermoseismicHeart item = (ThermoseismicHeart)patt5555$temp;
            if (!item.canUseAbility((ItemStack)stack, "pyromania")) {
                return 0.0;
            }
            item.spreadExperience(player, (ItemStack)stack, 20);
            return item.getAbilityValue((ItemStack)stack, "pyromania", "duration");
        }).sum();
        if (overloadTime >= 0.5) {
            player.f_19802_ = 20;
            player.f_20916_ = player.f_20917_ = 10;
            MobEffectInstance current = player.m_21124_((MobEffect)MoreRelics.OVERLOAD.get());
            if (current == null) {
                player.m_7292_(new MobEffectInstance((MobEffect)MoreRelics.OVERLOAD.get(), (int)Math.round(overloadTime * 20.0), 0));
            } else {
                int currentAmplifier = current.m_19564_();
                if (currentAmplifier < 3) {
                    player.m_7292_(new MobEffectInstance((MobEffect)MoreRelics.OVERLOAD.get(), (int)Math.round(overloadTime * 20.0), currentAmplifier + 1));
                } else {
                    player.m_7292_(new MobEffectInstance((MobEffect)MoreRelics.OVERLOAD.get(), (int)Math.round(overloadTime * 20.0), 3));
                }
            }
            event.setCanceled(true);
        }
    }

    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        if (ability.equals("thermal_discharge")) {
            if (player.m_9236_().f_46443_) {
                return;
            }
            MobEffectInstance current = player.m_21124_((MobEffect)MoreRelics.OVERLOAD.get());
            int dischargeLevel = current == null ? 0 : current.m_19564_() + 1;
            boolean playerHasPsychosis = player.m_21023_((MobEffect)MoreRelics.CYBERPSYCHOSIS.get());
            Level level = player.m_9236_();
            if (dischargeLevel < 2 && playerHasPsychosis) {
                dischargeLevel = 2;
            }
            Vec3 center = player.m_20182_();
            double radius = this.getAbilityValue(stack, "thermal_discharge", "radius") * (double)((float)dischargeLevel * 0.5f + 1.0f);
            float damage = (float)this.getAbilityValue(stack, "thermal_discharge", "damage") * ((float)dischargeLevel * 0.5f + 1.0f);
            AABB area = new AABB(center.f_82479_ - radius, center.f_82480_ - radius, center.f_82481_ - radius, center.f_82479_ + radius, center.f_82480_ + radius, center.f_82481_ + radius);
            List detectedEntities = level.m_45933_((Entity)player, area);
            this.spawnFireParticles(level, center, dischargeLevel, (float)radius);
            for (Entity detected : detectedEntities) {
                if (!(detected instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)detected;
                if (player == detected) continue;
                Vec3 direction = livingEntity.m_20182_().m_82546_(center).m_82541_();
                double pushStrength = (float)(dischargeLevel + 1) / 4.0f;
                livingEntity.m_20256_(livingEntity.m_20184_().m_82549_(direction.m_82490_(pushStrength)));
                livingEntity.m_6469_(new DamageSource(livingEntity.m_269291_().m_269264_().m_269150_(), (Entity)player, (Entity)player), damage);
                livingEntity.m_7311_(20 * (int)(6.0f * ((float)(dischargeLevel + 1) / 2.0f)));
            }
            this.setAbilityCooldown(stack, "thermal_discharge", 300);
            this.spreadExperience((LivingEntity)player, stack, 10);
            if (!playerHasPsychosis) {
                player.m_21195_((MobEffect)MoreRelics.OVERLOAD.get());
            }
        }
    }

    private void spawnFireParticles(Level level, Vec3 position, int amplifier, float radius) {
        int particleCount = 30 + amplifier * 60;
        if (particleCount > 400) {
            particleCount = 400;
        }
        level.m_6263_(null, position.f_82479_, position.f_82480_, position.f_82481_, SoundEvents.f_11892_, SoundSource.MASTER, 0.6f, 1.0f);
        ServerLevel sevLevel = (ServerLevel)level;
        List players = level.m_6907_();
        for (ServerPlayer player : players) {
            sevLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123744_, true, position.f_82479_, position.f_82480_ + 1.0, position.f_82481_, particleCount, 0.0, 0.0, 0.0, 0.025 * (double)radius);
        }
    }
}

