/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.relics;

import com.blorb.morerelics.MoreRelicsUtil;
import com.blorb.morerelics.relics.MoreRelicBase;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;

@Mod.EventBusSubscriber
public class OpalNecklace
extends MoreRelicBase {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"bubble_shield").stat(StatData.builder((String)"cooldown").initialValue(300.0, 200.0).upgradeModifier(UpgradeOperation.ADD, -20.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(5).requiredLevel(0).build()).build()).leveling(LevelingData.builder().maxLevel(5).initialCost(120).step(20).build()).loot(LootData.builder().entry(LootCollections.DESERT).entry(LootCollections.COLD).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        boolean notified;
        CompoundTag tag = stack.m_41784_();
        boolean onCooldown = this.isAbilityOnCooldown(stack, "bubble_shield");
        if (onCooldown != (notified = tag.m_128471_("morerelics_notified"))) {
            if (!onCooldown) {
                MutableComponent message = Component.m_237113_((String)"Bubble Shield is ready to use again.").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)16766720)));
                slotContext.entity().m_213846_((Component)message);
            }
            tag.m_128379_("morerelics_notified", onCooldown);
        }
    }

    @SubscribeEvent
    public static void onDamageTaken(LivingDamageEvent event) {
        LivingEntity player = event.getEntity();
        if (player.m_9236_().f_46443_) {
            return;
        }
        int block = MoreRelicsUtil.actuallyGetEquippedRelics(player).stream().mapToInt(stack -> {
            Item patt3622$temp = stack.m_41720_();
            if (!(patt3622$temp instanceof OpalNecklace)) {
                return 0;
            }
            OpalNecklace item = (OpalNecklace)patt3622$temp;
            if (!item.canUseAbility((ItemStack)stack, "bubble_shield") || item.isAbilityOnCooldown((ItemStack)stack, "bubble_shield")) {
                return 0;
            }
            item.setAbilityCooldown((ItemStack)stack, "bubble_shield", (int)(item.getAbilityValue((ItemStack)stack, "bubble_shield", "cooldown") * 20.0));
            item.spreadExperience(player, (ItemStack)stack, 5);
            return 1;
        }).sum();
        if (block >= 1) {
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_144050_, SoundSource.MASTER, 0.8f, 0.6f);
            player.f_19802_ = 20;
            player.f_20916_ = player.f_20917_ = 10;
            event.setCanceled(true);
        }
    }
}

