/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.relics;

import com.blorb.morerelics.MoreRelicsUtil;
import com.blorb.morerelics.relics.MoreRelicBase;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;

@Mod.EventBusSubscriber
public class MoodWorm
extends MoreRelicBase {
    public static int MOOD_SWAP_SECONDS = 600;

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"moody").stat(StatData.builder((String)"multip").initialValue(0.1, 0.15).upgradeModifier(UpgradeOperation.ADD, 0.02).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).stat(StatData.builder((String)"reduction").initialValue(10.0, 14.0).upgradeModifier(UpgradeOperation.ADD, 2.2).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(5).requiredLevel(0).build()).ability(AbilityData.builder((String)"tranquillity").maxLevel(0).requiredLevel(5).build()).build()).leveling(LevelingData.builder().maxLevel(5).initialCost(20).step(20).build()).loot(LootData.builder().entry(LootCollections.END).entry(LootCollections.NETHER).entry(LootCollections.VILLAGE).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_9236_().f_46443_) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        boolean unlockedTranquility = this.canUseAbility(stack, "tranquillity");
        int currentMood = tag.m_128451_("morerelics_currentmood");
        int moodTimer = tag.m_128451_("morerelics_moodTimer");
        if (0 < moodTimer) {
            --moodTimer;
        } else {
            this.spreadExperience(livingEntity, stack, 20);
            currentMood = this.swapMood(tag, unlockedTranquility);
            moodTimer = MOOD_SWAP_SECONDS * 20;
        }
        tag.m_128405_("morerelics_moodTimer", moodTimer);
        float multip = (float)this.getAbilityValue(stack, "moody", "multip");
        EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Attribute)Attributes.f_22279_, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
        EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Attribute)Attributes.f_22281_, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
        EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Attribute)Attributes.f_22286_, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
        EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Attribute)Attributes.f_22278_, (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
        if (currentMood == 0 || currentMood == 3) {
            EntityUtils.resetAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Attribute)Attributes.f_22281_, (float)multip, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
        }
        if (currentMood == 1 || currentMood == 3) {
            EntityUtils.resetAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Attribute)Attributes.f_22279_, (float)multip, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
            EntityUtils.resetAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Attribute)Attributes.f_22286_, (float)multip, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
        }
        if (currentMood == 2 || currentMood == 3) {
            EntityUtils.resetAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Attribute)Attributes.f_22278_, (float)0.5f, (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (stack.m_41720_() != newStack.m_41720_()) {
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Attribute)Attributes.f_22279_, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Attribute)Attributes.f_22281_, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Attribute)Attributes.f_22286_, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Attribute)Attributes.f_22278_, (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
        }
    }

    private int swapMood(CompoundTag tag, boolean didUnlockTranquillity) {
        Random rand = new Random();
        int highestMood = didUnlockTranquillity ? 3 : 2;
        int nextMood = rand.nextInt(highestMood + 1);
        if (nextMood == tag.m_128451_("morerelics_currentmood")) {
            nextMood = nextMood == highestMood ? 0 : nextMood + 1;
        }
        tag.m_128405_("morerelics_currentmood", nextMood);
        return nextMood;
    }

    @SubscribeEvent
    public static void onDamageTaken(LivingHurtEvent event) {
        Player player;
        block7: {
            block6: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block6;
                player = (Player)livingEntity;
                if (!player.m_9236_().f_46443_) break block7;
            }
            return;
        }
        double reduction = MoreRelicsUtil.actuallyGetEquippedRelics((LivingEntity)player).stream().mapToDouble(stack -> {
            Item patt7255$temp = stack.m_41720_();
            if (!(patt7255$temp instanceof MoodWorm)) {
                return 0.0;
            }
            MoodWorm item = (MoodWorm)patt7255$temp;
            CompoundTag tag = stack.m_41784_();
            int currentMood = tag.m_128451_("morerelics_currentmood");
            if (currentMood != 2 && currentMood != 3) {
                return 0.0;
            }
            return item.getAbilityValue((ItemStack)stack, "moody", "reduction");
        }).sum();
        if (reduction > 60.0) {
            reduction = 60.0;
        } else if (reduction < 0.0) {
            reduction = 0.0;
        }
        event.setAmount((float)((double)event.getAmount() * (100.0 - reduction) / 100.0));
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingDamageEvent event) {
        Player player;
        block5: {
            block4: {
                Entity entity = event.getSource().m_7639_();
                if (!(entity instanceof Player)) break block4;
                player = (Player)entity;
                if (!player.m_9236_().f_46443_) break block5;
            }
            return;
        }
        LivingEntity victim = event.getEntity();
        int shouldBurn = MoreRelicsUtil.actuallyGetEquippedRelics((LivingEntity)player).stream().mapToInt(stack -> {
            Item patt8253$temp = stack.m_41720_();
            if (!(patt8253$temp instanceof MoodWorm)) {
                return 0;
            }
            MoodWorm item = (MoodWorm)patt8253$temp;
            CompoundTag tag = stack.m_41784_();
            int currentMood = tag.m_128451_("morerelics_currentmood");
            if (currentMood == 0 || currentMood == 3) {
                return 1;
            }
            return 0;
        }).sum();
        if (shouldBurn > 0 && victim.m_20094_() < 60) {
            victim.m_7311_(60);
        }
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
        ArrayList<Component> list = new ArrayList<Component>();
        CompoundTag tag = stack.m_41784_();
        int currentMood = tag.m_128451_("morerelics_currentmood");
        if (currentMood == 0) {
            list.add((Component)Component.m_237115_((String)"tooltip.morerelics.moodworm.furious").m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.ITALIC));
        } else if (currentMood == 1) {
            list.add((Component)Component.m_237115_((String)"tooltip.morerelics.moodworm.joyful").m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC));
        } else if (currentMood == 2) {
            list.add((Component)Component.m_237115_((String)"tooltip.morerelics.moodworm.gloomy").m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.ITALIC));
        } else if (currentMood == 3) {
            list.add((Component)Component.m_237115_((String)"tooltip.morerelics.moodworm.tranquillity").m_130940_(ChatFormatting.WHITE).m_130940_(ChatFormatting.ITALIC));
        }
        return list;
    }
}

