/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.relics;

import com.blorb.morerelics.MoreRelics;
import com.blorb.morerelics.MoreRelicsUtil;
import com.blorb.morerelics.relics.MoreRelicBase;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;

@Mod.EventBusSubscriber
public class MadeInHeaven
extends MoreRelicBase {
    private final int experienceTimer = 10;

    public MadeInHeaven() {
        super(new Item.Properties().m_41497_(Rarity.EPIC).m_41487_(1).m_41486_());
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"as_one").maxLevel(8).stat(StatData.builder((String)"multiplier").initialValue(0.1, 0.2).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).upgradeModifier(UpgradeOperation.ADD, 0.025).build()).requiredLevel(0).build()).ability(AbilityData.builder((String)"safeguard").stat(StatData.builder((String)"cooldown").initialValue(500.0, 420.0).upgradeModifier(UpgradeOperation.ADD, -40.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).requiredLevel(5).maxLevel(3).build()).ability(AbilityData.builder((String)"judgement").requiredLevel(10).maxLevel(5).stat(StatData.builder((String)"max_health_damage").initialValue(4.0, 6.0).upgradeModifier(UpgradeOperation.ADD, 0.4).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).stat(StatData.builder((String)"min_damage").initialValue(4.0, 6.0).upgradeModifier(UpgradeOperation.ADD, 0.8).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).stat(StatData.builder((String)"cooldown").initialValue(28.0, 20.0).upgradeModifier(UpgradeOperation.ADD, -0.8).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).build()).build()).leveling(LevelingData.builder().maxLevel(16).initialCost(200).step(50).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity.m_9236_().f_46443_) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        int reviveCooldown = tag.m_128451_("morerelics_revive_counter");
        if (reviveCooldown > 1) {
            --reviveCooldown;
        } else if (reviveCooldown == 1) {
            --reviveCooldown;
            MutableComponent message = Component.m_237113_((String)"Safeguard is ready to use again.").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)16766720)));
            livingEntity.m_213846_((Component)message);
        }
        tag.m_128405_("morerelics_revive_counter", reviveCooldown);
        float multiplier = (float)this.getAbilityValue(stack, "as_one", "multiplier");
        int experienceProgress = tag.m_128451_("morerelics_counter");
        if (10 > experienceProgress) {
            ++experienceProgress;
        } else {
            this.addExperience(livingEntity, stack, 1);
            experienceProgress = 0;
        }
        tag.m_128405_("morerelics_counter", experienceProgress);
        int judgementCooldown = tag.m_128451_("morerelics_judgement_cooldown");
        if (judgementCooldown > 0) {
            tag.m_128405_("morerelics_judgement_cooldown", judgementCooldown - 1);
        }
        EntityUtils.resetAttribute((LivingEntity)slotContext.entity(), (ItemStack)stack, (Attribute)Attributes.f_22281_, (float)multiplier, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
        EntityUtils.resetAttribute((LivingEntity)slotContext.entity(), (ItemStack)stack, (Attribute)Attributes.f_22283_, (float)multiplier, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
        EntityUtils.resetAttribute((LivingEntity)slotContext.entity(), (ItemStack)stack, (Attribute)Attributes.f_22276_, (float)multiplier, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
        EntityUtils.resetAttribute((LivingEntity)slotContext.entity(), (ItemStack)stack, (Attribute)Attributes.f_22279_, (float)multiplier, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
        EntityUtils.resetAttribute((LivingEntity)slotContext.entity(), (ItemStack)stack, (Attribute)Attributes.f_22278_, (float)multiplier, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
        EntityUtils.resetAttribute((LivingEntity)slotContext.entity(), (ItemStack)stack, (Attribute)Attributes.f_22286_, (float)multiplier, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
        EntityUtils.resetAttribute((LivingEntity)slotContext.entity(), (ItemStack)stack, (Attribute)Attributes.f_22284_, (float)multiplier, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (stack.m_41720_() != newStack.m_41720_()) {
            EntityUtils.removeAttribute((LivingEntity)slotContext.entity(), (ItemStack)stack, (Attribute)Attributes.f_22281_, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)slotContext.entity(), (ItemStack)stack, (Attribute)Attributes.f_22283_, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)slotContext.entity(), (ItemStack)stack, (Attribute)Attributes.f_22276_, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)slotContext.entity(), (ItemStack)stack, (Attribute)Attributes.f_22279_, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)slotContext.entity(), (ItemStack)stack, (Attribute)Attributes.f_22278_, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)slotContext.entity(), (ItemStack)stack, (Attribute)Attributes.f_22286_, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)slotContext.entity(), (ItemStack)stack, (Attribute)Attributes.f_22284_, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
        }
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingHurtEvent event) {
        Player player;
        block7: {
            block6: {
                Entity entity = event.getSource().m_7639_();
                if (!(entity instanceof Player)) break block6;
                player = (Player)entity;
                if (!player.m_9236_().f_46443_) break block7;
            }
            return;
        }
        if (event.getSource().m_276093_(MoreRelics.JUDGEMENT_BURN)) {
            return;
        }
        float extra_damage = (float)MoreRelicsUtil.actuallyGetEquippedRelics((LivingEntity)player).stream().mapToDouble(stack -> {
            Item patt9174$temp = stack.m_41720_();
            if (!(patt9174$temp instanceof MadeInHeaven)) {
                return 0.0;
            }
            MadeInHeaven item = (MadeInHeaven)patt9174$temp;
            if (!item.canUseAbility((ItemStack)stack, "judgement")) {
                return 0.0;
            }
            CompoundTag tag = stack.m_41784_();
            if (tag.m_128451_("morerelics_judgement_cooldown") != 0) {
                return 0.0;
            }
            double perch = item.getAbilityValue((ItemStack)stack, "judgement", "max_health_damage");
            double min = item.getAbilityValue((ItemStack)stack, "judgement", "min_damage");
            tag.m_128405_("morerelics_judgement_cooldown", (int)(item.getAbilityValue((ItemStack)stack, "judgement", "cooldown") * 20.0));
            return (float)Math.round(Math.max(min, perch * (double)event.getEntity().m_21233_() / 100.0) * 100.0) / 100.0f;
        }).sum();
        if (extra_damage == 0.0f) {
            return;
        }
        MadeInHeaven.spawnHolyFireParticles(event.getEntity().m_9236_(), event.getEntity().m_20182_());
        Holder.Reference typeHolder = event.getEntity().m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(MoreRelics.JUDGEMENT_BURN);
        DamageSource judgement = new DamageSource((Holder)typeHolder, (Entity)player);
        if (extra_damage > 300.0f) {
            extra_damage = 300.0f;
        }
        event.getEntity().f_19802_ = 0;
        event.getEntity().m_6469_(judgement, extra_damage);
        event.getEntity().f_19802_ = 0;
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        Player player;
        block5: {
            block4: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block4;
                player = (Player)livingEntity;
                if (!player.m_9236_().f_46443_) break block5;
            }
            return;
        }
        int shouldPrevent = MoreRelicsUtil.actuallyGetEquippedRelics((LivingEntity)player).stream().mapToInt(stack -> {
            boolean result;
            Item patt10924$temp = stack.m_41720_();
            if (!(patt10924$temp instanceof MadeInHeaven)) {
                return 0;
            }
            MadeInHeaven item = (MadeInHeaven)patt10924$temp;
            CompoundTag tag = stack.m_41784_();
            boolean bl = result = item.canUseAbility((ItemStack)stack, "safeguard") && tag.m_128451_("morerelics_revive_counter") <= 0;
            if (result) {
                tag.m_128405_("morerelics_revive_counter", (int)Math.round(item.getAbilityValue((ItemStack)stack, "safeguard", "cooldown") * 20.0));
                return 1;
            }
            return 0;
        }).sum();
        if (shouldPrevent == 1) {
            event.setCanceled(true);
            player.m_21153_(player.m_21233_() / 2.0f);
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11983_, SoundSource.MASTER, 1.2f, 0.4f);
            MutableComponent message = Component.m_237113_((String)"Safeguard has shielded you from death and is now on cooldown.").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)16766720)));
            player.m_213846_((Component)message);
        }
    }

    @Override
    public boolean canEquipMultipleCopies() {
        return false;
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"tooltip.morerelics.made_in_heaven.source").m_130940_(ChatFormatting.AQUA).m_130940_(ChatFormatting.ITALIC));
        return list;
    }

    private static void spawnHolyFireParticles(Level level, Vec3 position) {
        int particleCount = 40;
        level.m_6263_(null, position.f_82479_, position.f_82480_, position.f_82481_, (SoundEvent)MoreRelics.JUDGEMENT.get(), SoundSource.MASTER, 0.4f, 1.0f);
        ServerLevel sevLevel = (ServerLevel)level;
        List players = level.m_6907_();
        for (ServerPlayer player : players) {
            sevLevel.m_8624_(player, (ParticleOptions)MoreRelics.HOLY_FIRE.get(), true, position.f_82479_, position.f_82480_ + 1.0, position.f_82481_, particleCount, 0.0, 0.0, 0.0, 0.05);
        }
    }
}

