/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.relics;

import com.blorb.morerelics.MoreRelicsUtil;
import com.blorb.morerelics.relics.MoreRelicBase;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;

public class EpochApple
extends MoreRelicBase {
    public EpochApple() {
        super(new Item.Properties().m_41497_(Rarity.RARE).m_41489_(new FoodProperties.Builder().m_38767_()).m_41487_(1));
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"persistent").stat(StatData.builder((String)"cooldown").initialValue(16.0, 12.0).upgradeModifier(UpgradeOperation.ADD, -0.5).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(8).requiredLevel(0).build()).ability(AbilityData.builder((String)"ripen").stat(StatData.builder((String)"cooldown").initialValue(60.0, 52.0).upgradeModifier(UpgradeOperation.ADD, -3.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(4).requiredLevel(8).build()).build()).leveling(LevelingData.builder().maxLevel(12).initialCost(100).step(40).build()).build();
    }

    @Nullable
    public FoodProperties getFoodProperties(@NotNull ItemStack stack, @Nullable LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.canUseAbility(stack, "persistent")) {
                int currentState = this.getState(stack);
                FoodProperties.Builder builder = currentState == -1 ? new FoodProperties.Builder().m_38760_(0).m_38758_(0.0f) : (currentState == 0 ? new FoodProperties.Builder().m_38760_(4).m_38758_(1.2f).effect(() -> new MobEffectInstance(MobEffects.f_19605_, 100, 1), 1.0f).effect(() -> new MobEffectInstance(MobEffects.f_19617_, 2400, 0), 1.0f).m_38765_() : new FoodProperties.Builder().m_38760_(4).m_38758_(1.2f).effect(() -> new MobEffectInstance(MobEffects.f_19605_, 400, 1), 1.0f).effect(() -> new MobEffectInstance(MobEffects.f_19606_, 6000, 0), 1.0f).effect(() -> new MobEffectInstance(MobEffects.f_19607_, 6000, 0), 1.0f).effect(() -> new MobEffectInstance(MobEffects.f_19617_, 2400, 3), 1.0f).m_38765_());
                return builder.m_38767_();
            }
        }
        return super.getFoodProperties(stack, entity);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.canUseAbility(stack, "persistent") && this.getState(stack) >= 0) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @Override
    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return false;
    }

    @NotNull
    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.m_9236_().f_46443_) {
                FoodProperties properties = this.getFoodProperties(stack, entity);
                if (properties == null || properties.m_38744_() == 0) {
                    return stack;
                }
                CompoundTag tag = stack.m_41784_();
                tag.m_128405_("morerelics_evermore_init", 1);
                tag.m_128405_("morerelics_evermore_progress", 0);
                this.spreadExperience((LivingEntity)player, stack, 120);
                player.m_5584_(level, stack.m_41777_());
                this.changeProgress(stack, 0);
            }
        }
        return stack;
    }

    public boolean m_5812_(ItemStack stack) {
        return this.getState(stack) == 1;
    }

    public int getUseDuration(@NotNull ItemStack stack, LivingEntity entity) {
        return 32;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.EAT;
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entityIn, int itemSlot, boolean isSelected) {
        if (!level.m_5776_() && entityIn instanceof Player) {
            Player player = (Player)entityIn;
            if (entityIn.f_19797_ % 100 == 0) {
                this.changeProgress(stack, 100);
            }
        }
        super.m_6883_(stack, level, entityIn, itemSlot, isSelected);
    }

    public void changeProgress(ItemStack stack, int amount) {
        int persistentCooldown;
        CompoundTag tag = stack.m_41784_();
        boolean persistentUnlocked = this.canUseAbility(stack, "persistent");
        int n = persistentCooldown = persistentUnlocked ? (int)(this.getAbilityValue(stack, "persistent", "cooldown") * 20.0 * 60.0) : 0;
        if (tag.m_128451_("morerelics_evermore_init") == 0) {
            tag.m_128405_("morerelics_evermore_progress", persistentCooldown);
            tag.m_128405_("morerelics_evermore_init", 1);
        } else {
            double ripenTime;
            boolean ripenUnlocked = this.canUseAbility(stack, "ripen");
            int ripenCooldown = ripenUnlocked ? (int)(this.getAbilityValue(stack, "ripen", "cooldown") * 20.0 * 60.0) : 0;
            int upperLimit = persistentCooldown + ripenCooldown;
            int currentVal = tag.m_128451_("morerelics_evermore_progress");
            currentVal = MoreRelicsUtil.clamp(currentVal + amount, 0, upperLimit);
            tag.m_128405_("morerelics_evermore_progress", currentVal);
            int currentState = -1;
            if (ripenUnlocked && (double)currentVal >= (ripenTime = (double)(ripenCooldown + persistentCooldown))) {
                currentState = 1;
            }
            if (persistentUnlocked && currentState == -1 && currentVal >= persistentCooldown) {
                currentState = 0;
            }
            tag.m_128405_("morerelics_evermore_state", currentState);
        }
    }

    public int getState(ItemStack stack) {
        return stack.m_41784_().m_128451_("morerelics_evermore_state");
    }
}

