/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.relics;

import com.blorb.morerelics.MoreRelics;
import com.blorb.morerelics.relics.MoreRelicBase;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import top.theillusivec4.curios.api.SlotContext;

public class DepletedSpool
extends MoreRelicBase {
    private static final int stringRequired = 300;
    private static final int potionsRequired = 1;

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"restoration").build()).build()).leveling(LevelingData.builder().maxLevel(1).initialCost(100).step(20).build()).loot(LootData.builder().entry(LootCollections.PILLAGE).entry(LootCollections.ANTHROPOGENIC).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_9236_().f_46443_) {
            return;
        }
        ItemStack mainHandItem = player.m_21205_();
        CompoundTag tag = stack.m_41784_();
        int stringsEaten = tag.m_128451_("string_eaten");
        int potionsEaten = tag.m_128451_("potion_eaten");
        if (mainHandItem.m_150930_(Items.f_42401_)) {
            if (stringsEaten < 300) {
                mainHandItem.m_41774_(1);
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.MASTER, 0.5f, 1.0f);
                tag.m_128405_("string_eaten", stringsEaten + 1);
            }
        } else if (this.isRegenerationPotion(mainHandItem) && potionsEaten < 1) {
            mainHandItem.m_41774_(1);
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11772_, SoundSource.MASTER, 0.5f, 0.9f);
            tag.m_128405_("potion_eaten", potionsEaten + 1);
        }
        this.checkAndTransform(stack, player);
    }

    private void checkAndTransform(ItemStack stack, Player player) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128451_("string_eaten") >= 300 && tag.m_128451_("potion_eaten") >= 1) {
            MutableComponent message = Component.m_237113_((String)"The spool's regenerative abilities are restored!").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)16766720)));
            player.m_213846_((Component)message);
            EntityUtils.addItem((Player)player, (ItemStack)new ItemStack((ItemLike)MoreRelics.WEAVERS_SPOOL.get()));
            stack.m_41764_(0);
        }
    }

    private boolean isRegenerationPotion(ItemStack potionStack) {
        return PotionUtils.m_43547_((ItemStack)potionStack).stream().anyMatch(effectInstance -> effectInstance.m_19544_() == MobEffects.f_19605_);
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
        ArrayList<Component> list = new ArrayList<Component>();
        CompoundTag tag = stack.m_41784_();
        list.add((Component)Component.m_237113_((String)("Strings Consumed: " + tag.m_128451_("string_eaten") + "/300")).m_130940_(ChatFormatting.LIGHT_PURPLE).m_130940_(ChatFormatting.ITALIC));
        list.add((Component)Component.m_237113_((String)("Regeneration Potions Consumed: " + tag.m_128451_("potion_eaten") + "/1")).m_130940_(ChatFormatting.LIGHT_PURPLE).m_130940_(ChatFormatting.ITALIC));
        return list;
    }
}

