/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.relics;

import com.blorb.morerelics.MoreRelics;
import com.blorb.morerelics.MoreRelicsUtil;
import com.blorb.morerelics.relics.MoreRelicBase;
import com.blorb.morerelics.relics.WonderOfU;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ConvergingOrb
extends MoreRelicBase {
    public static final float requiredDamage = 400.0f;

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"convergence").maxLevel(1).requiredLevel(0).build()).build()).leveling(LevelingData.builder().maxLevel(1).initialCost(1).step(1).build()).build();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerAttacked(LivingDamageEvent event) {
        Player player;
        block3: {
            block2: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block2;
                player = (Player)livingEntity;
                if (!player.m_9236_().f_46443_) break block3;
            }
            return;
        }
        MoreRelicsUtil.actuallyGetEquippedRelics((LivingEntity)player).forEach(stack -> {
            Item patt2375$temp = stack.m_41720_();
            if (!(patt2375$temp instanceof ConvergingOrb)) {
                return;
            }
            ConvergingOrb item = (ConvergingOrb)patt2375$temp;
            ConvergingOrb.increaseDensity(stack, (LivingEntity)player, event.getAmount());
            if (ConvergingOrb.isFinalQuestEnabled(stack) && event.getSource().m_276093_(DamageTypes.f_268679_)) {
                MutableComponent message = Component.m_237115_((String)"tooltip.morerelics.converging_orb.collapse").m_130940_(ChatFormatting.AQUA);
                player.m_9236_().m_6263_(null, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, (SoundEvent)MoreRelics.WONDER.get(), SoundSource.MASTER, 1.0f, 1.0f);
                WonderOfU.spawnWonderExplosionParticles(player.m_9236_(), player.m_20182_(), 4.0f);
                player.m_213846_((Component)message);
                EntityUtils.addItem((Player)player, (ItemStack)new ItemStack((ItemLike)MoreRelics.WONDER_OF_U.get()));
                stack.m_41764_(0);
            }
        });
    }

    @Override
    public boolean canEquipMultipleCopies() {
        return false;
    }

    public static void increaseDensity(ItemStack stack, LivingEntity entity, float damage) {
        CompoundTag tag = stack.m_41784_();
        double currentDamage = tag.m_128459_("morerelics_converge_damage");
        currentDamage = Math.max(0.0, Math.min(currentDamage + (double)damage, 400.0));
        tag.m_128347_("morerelics_converge_damage", currentDamage);
        int currentState = currentDamage < 100.0 ? 0 : (currentDamage < 200.0 ? 1 : (currentDamage < 400.0 ? 2 : 3));
        tag.m_128405_("morerelics_current_converge_state", currentState);
        if (currentState == 3) {
            ConvergingOrb.tryProcFinalQuest(stack, entity);
        }
    }

    public static void tryProcFinalQuest(ItemStack stack, LivingEntity entity) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128451_("morerelics_converge_final_quest") == 1) {
            return;
        }
        MutableComponent message = Component.m_237115_((String)"amulet.morerelics.orb_final_push").m_130940_(ChatFormatting.AQUA);
        entity.m_213846_((Component)message);
        tag.m_128405_("morerelics_converge_final_quest", 1);
    }

    public static boolean isFinalQuestEnabled(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128451_("morerelics_converge_final_quest") == 1;
    }

    public String damageToDensityString(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        double damage = tag.m_128459_("morerelics_converge_damage");
        double baseDensity = 100.0;
        double maxDensity = 4.0 * Math.pow(10.0, 14.0);
        double k = Math.log(maxDensity / baseDensity) / 400.0;
        double density = baseDensity * Math.exp(k * damage);
        double logDensity = Math.log10(density);
        int exponent = (int)Math.floor(logDensity);
        double coefficient = density / Math.pow(10.0, exponent);
        String result = exponent >= 3 ? String.format("%.1f * 10^%d kg/m^3", coefficient, exponent) : String.format("%.0f kg/m^3", density);
        return result;
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
        ArrayList<Component> list = new ArrayList<Component>();
        String densityString = this.damageToDensityString(stack);
        String tooltipText = Component.m_237115_((String)"tooltip.morerelics.converging_orb.density").m_130940_(ChatFormatting.AQUA).getString() + ": " + densityString;
        list.add((Component)Component.m_237113_((String)tooltipText).m_130940_(ChatFormatting.AQUA));
        if (ConvergingOrb.isFinalQuestEnabled(stack)) {
            list.add((Component)Component.m_237115_((String)"tooltip.morerelics.converging_orb.final_task").m_130940_(ChatFormatting.LIGHT_PURPLE).m_130940_(ChatFormatting.ITALIC));
        }
        return list;
    }
}

