/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class SoarVelocityPayload {
    public static final ResourceLocation TYPE = ResourceLocation.fromNamespaceAndPath((String)"morerelics", (String)"soar_velocity");
    private final double x;
    private final double y;
    private final double z;

    public SoarVelocityPayload(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void encode(SoarVelocityPayload payload, FriendlyByteBuf buffer) {
        buffer.writeDouble(payload.x);
        buffer.writeDouble(payload.y);
        buffer.writeDouble(payload.z);
    }

    public static SoarVelocityPayload decode(FriendlyByteBuf buffer) {
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        return new SoarVelocityPayload(x, y, z);
    }

    public static void handle(SoarVelocityPayload payload, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> SoarVelocityPayload.LaunchPlayer(payload));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void LaunchPlayer(SoarVelocityPayload payload) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        player.m_20334_(payload.x, payload.y, payload.z);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }
}

