/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.network;

import com.blorb.morerelics.effects.Nullification;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class NullTagPayload {
    public static final ResourceLocation TYPE = ResourceLocation.fromNamespaceAndPath((String)"morerelics", (String)"null_tag");
    private final int entityId;
    private final boolean hasTag;

    public NullTagPayload(int entityId, boolean hasTag) {
        this.entityId = entityId;
        this.hasTag = hasTag;
    }

    public static void encode(NullTagPayload msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
        buf.writeBoolean(msg.hasTag);
    }

    public static NullTagPayload decode(FriendlyByteBuf buf) {
        return new NullTagPayload(buf.readInt(), buf.readBoolean());
    }

    public static void handle(NullTagPayload payload, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> NullTagPayload.addTag(payload));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void addTag(NullTagPayload payload) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            if (payload.hasTag) {
                Nullification.ClientEvent.ENTITY_EFFECT_STATUS.put(payload.entityId, true);
            } else {
                Nullification.ClientEvent.ENTITY_EFFECT_STATUS.remove(payload.entityId);
            }
        }
    }
}

