/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.effects;

import com.blorb.morerelics.network.NullTagPayload;
import com.blorb.morerelics.network.PacketHandler;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
public class Nullification
extends MobEffect {
    public static boolean isRendering = false;

    public Nullification() {
        super(MobEffectCategory.BENEFICIAL, 0xFFFFFF);
    }

    @SubscribeEvent
    public static void onEffectAdded(MobEffectEvent.Added event) {
        LivingEntity entity = event.getEntity();
        MobEffectInstance effect = event.getEffectInstance();
        if (effect.m_19544_() instanceof Nullification) {
            NullTagPayload packet = new NullTagPayload(entity.m_19879_(), true);
            PacketHandler.sendToAllClients(packet);
        }
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        LivingEntity entity = event.getEntity();
        MobEffectInstance effect = event.getEffectInstance();
        if (effect != null && effect.m_19544_() instanceof Nullification) {
            NullTagPayload packet = new NullTagPayload(entity.m_19879_(), false);
            PacketHandler.sendToAllClients(packet);
        }
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        MobEffectInstance instance = entity.m_21124_((MobEffect)this);
        if (!entity.m_9236_().m_5776_() && instance != null && instance.m_19557_() <= 2) {
            NullTagPayload packet = new NullTagPayload(entity.m_19879_(), false);
            PacketHandler.sendToAllClients(packet);
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return duration >= 1;
    }

    @Mod.EventBusSubscriber(modid="morerelics", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientMonoEvent {
        @SubscribeEvent
        public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
            for (String skin : event.getSkins()) {
                PlayerRenderer renderer = (PlayerRenderer)event.getSkin(skin);
                if (renderer == null) continue;
            }
        }
    }

    @Mod.EventBusSubscriber(modid="morerelics", value={Dist.CLIENT})
    public static class ClientEvent {
        public static final Map<Integer, Boolean> ENTITY_EFFECT_STATUS = new ConcurrentHashMap<Integer, Boolean>();
        private static final float OUTLINE_THICKNESS = 0.06f;

        @SubscribeEvent
        public static void onClientLogout(ClientPlayerNetworkEvent.LoggingOut event) {
            ENTITY_EFFECT_STATUS.clear();
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onEntityRender(RenderLivingEvent.Pre<?, ?> event) {
            LivingEntity entity = event.getEntity();
            if (entity.m_20145_() || !ENTITY_EFFECT_STATUS.containsKey(entity.m_19879_())) {
                return;
            }
            if (isRendering) {
                return;
            }
            isRendering = true;
            MultiBufferSource.BufferSource immediate = Minecraft.m_91087_().m_91269_().m_110104_();
            immediate.m_109911_();
            PoseStack poseStack = ClientEvent.getScaledPoseStack(event, entity);
            ClientEvent.setTransparency(1.0f);
            ClientEvent.renderTranslucentEntity(event.getEntity(), poseStack, (MultiBufferSource)immediate, event.getPackedLight(), event.getPartialTick());
            immediate.m_109911_();
            ClientEvent.resetTransparency();
            poseStack.m_85849_();
            isRendering = false;
        }

        @NotNull
        private static PoseStack getScaledPoseStack(RenderLivingEvent.Pre<?, ?> event, LivingEntity entity) {
            PoseStack poseStack = event.getPoseStack();
            poseStack.m_85836_();
            AABB box = entity.m_20191_();
            double entityWidth = box.m_82362_();
            double entityHeight = box.m_82376_();
            double entityDepth = box.m_82385_();
            float scaleX = (float)((entityWidth + (double)0.12f) / entityWidth);
            float scaleY = (float)((entityHeight + (double)0.12f) / entityHeight);
            float scaleZ = (float)((entityDepth + (double)0.12f) / entityDepth);
            poseStack.m_85841_(scaleX, scaleY, scaleZ);
            return poseStack;
        }

        private static void setTransparency(float alpha) {
            RenderSystem.enableBlend();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)alpha);
        }

        private static void renderTranslucentEntity(LivingEntity entity, PoseStack poseStack, MultiBufferSource buffer, int light, float partialTick) {
            EntityRenderer renderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)entity);
            if (renderer instanceof LivingEntityRenderer) {
                LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
                livingRenderer.m_7392_(entity, 0.0f, partialTick, poseStack, buffer, light);
            }
        }

        private static void resetTransparency() {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
        }
    }
}

