/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.setup.registry;

import com.github.jarva.arsadditions.client.renderers.tile.WarpNexusRenderer;
import com.github.jarva.arsadditions.common.block.EnchantingWixieCauldron;
import com.github.jarva.arsadditions.common.block.EnderSourceJar;
import com.github.jarva.arsadditions.common.block.MagelightLantern;
import com.github.jarva.arsadditions.common.block.SourceSpawner;
import com.github.jarva.arsadditions.common.block.WarpNexus;
import com.github.jarva.arsadditions.common.block.tile.EnchantingWixieCauldronTile;
import com.github.jarva.arsadditions.common.block.tile.EnderSourceJarTile;
import com.github.jarva.arsadditions.common.block.tile.MagelightLanternTile;
import com.github.jarva.arsadditions.common.block.tile.SourceSpawnerTile;
import com.github.jarva.arsadditions.common.block.tile.WarpNexusTile;
import com.github.jarva.arsadditions.common.item.EnderSourceJarItem;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.github.jarva.arsadditions.setup.registry.names.AddonBlockNames;
import com.hollingsworth.arsnouveau.client.renderer.tile.GenericRenderer;
import com.hollingsworth.arsnouveau.common.items.RendererBlockItem;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class AddonBlockRegistry {
    public static final List<RegistryObject<? extends Block>> REGISTERED_BLOCKS = new ArrayList<RegistryObject<? extends Block>>();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"ars_additions");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"ars_additions");
    public static RegistryObject<BlockEntityType<MagelightLanternTile>> MAGELIGHT_LANTERN_TILE;
    public static RegistryObject<EnderSourceJar> ENDER_SOURCE_JAR;
    public static RegistryObject<BlockEntityType<EnderSourceJarTile>> ENDER_SOURCE_JAR_TILE;
    public static RegistryObject<WarpNexus> WARP_NEXUS;
    public static RegistryObject<BlockEntityType<WarpNexusTile>> WARP_NEXUS_TILE;
    public static RegistryObject<EnchantingWixieCauldron> WIXIE_ENCHANTING;
    public static RegistryObject<BlockEntityType<EnchantingWixieCauldronTile>> WIXIE_ENCHANTING_TILE;
    public static RegistryObject<SourceSpawner> SOURCE_SPAWNER;
    public static RegistryObject<BlockEntityType<SourceSpawnerTile>> SOURCE_SPAWNER_TILE;

    private static void registerCarpets() {
        for (String carpet : AddonBlockNames.CARPETS) {
            AddonBlockRegistry.registerBlockAndItem(carpet, () -> new CarpetBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50351_)));
        }
    }

    private static void registerDecorativeSourcestone() {
        for (String sourcestone : AddonBlockNames.DECORATIVE_SOURCESTONES) {
            AddonBlockRegistry.registerBlockAndItem(sourcestone, () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)BlockRegistry.getBlock((String)"sourcestone"))));
        }
    }

    private static void registerTrapdoors() {
        for (String trapdoor : AddonBlockNames.TRAPDOORS) {
            AddonBlockRegistry.registerBlockAndItem(trapdoor, () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)BlockRegistry.getBlock((String)"archwood_trapdoor")), BlockSetType.f_271479_));
        }
    }

    private static void registerDoors() {
        for (String door : AddonBlockNames.DOORS) {
            AddonBlockRegistry.registerBlockAndItem(door, () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)BlockRegistry.getBlock((String)"archwood_door")), BlockSetType.f_271479_));
        }
    }

    private static void registerChains() {
        for (String chain : AddonBlockNames.CHAINS) {
            AddonBlockRegistry.registerBlockAndItem(chain, () -> new ChainBlock(BlockBehaviour.Properties.m_284310_().m_280606_().m_60999_().m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56728_).m_60955_()));
        }
    }

    private static void registerMagelightLanterns() {
        for (String lantern : AddonBlockNames.MAGELIGHT_LANTERNS) {
            AddonBlockRegistry.registerBlockAndItem(lantern, MagelightLantern::new);
        }
    }

    private static void registerLanterns() {
        for (String lantern : AddonBlockNames.LANTERNS) {
            AddonBlockRegistry.registerBlockAndItem(lantern, () -> new LanternBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_280606_().m_60999_().m_60978_(3.5f).m_60918_(SoundType.f_56762_).m_60953_(arg -> 15).m_60955_().m_278166_(PushReaction.DESTROY)));
        }
    }

    private static void registerWalls() {
        for (String wall : AddonBlockNames.WALLS) {
            AddonBlockRegistry.registerBlockAndItem(wall, () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)BlockRegistry.getBlock((String)"sourcestone")).m_280606_()));
        }
    }

    private static void registerButtons() {
        for (String button : AddonBlockNames.BUTTONS) {
            AddonBlockRegistry.registerBlockAndItem(button, () -> new ButtonBlock(BlockBehaviour.Properties.m_284310_().m_60910_().m_60978_(0.5f).m_278166_(PushReaction.DESTROY), BlockSetType.f_271479_, 20, false));
        }
    }

    public static BlockItem getDefaultBlockItem(Block block) {
        return new BlockItem(block, AddonItemRegistry.defaultItemProperties());
    }

    public static <T extends Block> RegistryObject<T> registerBlockAndItem(String name, Supplier<T> blockSupp) {
        return AddonBlockRegistry.registerBlockAndItem(name, blockSupp, block -> AddonBlockRegistry.getDefaultBlockItem((Block)block.get()));
    }

    public static <T extends Block, R extends BlockItem> RegistryObject<T> registerBlockAndItem(String name, Supplier<T> blockSupp, Function<RegistryObject<T>, R> itemSupp) {
        RegistryObject block = BLOCKS.register(name, blockSupp);
        REGISTERED_BLOCKS.add((RegistryObject<? extends Block>)block);
        AddonItemRegistry.ITEMS.register(name, () -> (BlockItem)itemSupp.apply(block));
        return block;
    }

    public static <T extends BlockEntity> RegistryObject<BlockEntityType<T>> registerTile(String regName, BlockEntityType.BlockEntitySupplier<T> tile, Supplier<Block[]> block) {
        return BLOCK_ENTITIES.register(regName, () -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)tile, (Block[])((Block[])block.get())).m_58966_(null));
    }

    public static Block getBlock(String s) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("ars_additions", s));
    }

    public static Block[] getBlocks(String[] names) {
        return Arrays.stream(names).map(AddonBlockRegistry::getBlock).toList().toArray(new Block[0]);
    }

    static {
        WIXIE_ENCHANTING = AddonBlockRegistry.registerBlockAndItem("enchanting_wixie_cauldron", EnchantingWixieCauldron::new, block -> new RendererBlockItem((Block)block.get(), AddonItemRegistry.defaultItemProperties()){

            public Supplier<BlockEntityWithoutLevelRenderer> getRenderer() {
                return GenericRenderer.getISTER((String)"enchanting_apparatus");
            }
        });
        WIXIE_ENCHANTING_TILE = AddonBlockRegistry.registerTile("enchanting_wixie_cauldron", EnchantingWixieCauldronTile::new, () -> new Block[]{(Block)WIXIE_ENCHANTING.get()});
        ENDER_SOURCE_JAR = AddonBlockRegistry.registerBlockAndItem("ender_source_jar", EnderSourceJar::new, block -> new EnderSourceJarItem((Block)block.get(), AddonItemRegistry.defaultItemProperties()));
        ENDER_SOURCE_JAR_TILE = AddonBlockRegistry.registerTile("ender_source_jar", EnderSourceJarTile::new, () -> new Block[]{(Block)ENDER_SOURCE_JAR.get()});
        SOURCE_SPAWNER = AddonBlockRegistry.registerBlockAndItem("source_spawner", SourceSpawner::new);
        SOURCE_SPAWNER_TILE = AddonBlockRegistry.registerTile("source_spawner", SourceSpawnerTile::new, () -> new Block[]{(Block)SOURCE_SPAWNER.get()});
        WARP_NEXUS = AddonBlockRegistry.registerBlockAndItem("warp_nexus", WarpNexus::new, block -> new RendererBlockItem((Block)block.get(), AddonItemRegistry.defaultItemProperties()){

            public Supplier<BlockEntityWithoutLevelRenderer> getRenderer() {
                return WarpNexusRenderer::getISTER;
            }
        });
        WARP_NEXUS_TILE = AddonBlockRegistry.registerTile("warp_nexus", WarpNexusTile::new, () -> new Block[]{(Block)WARP_NEXUS.get()});
        AddonBlockRegistry.registerChains();
        AddonBlockRegistry.registerMagelightLanterns();
        AddonBlockRegistry.registerLanterns();
        MAGELIGHT_LANTERN_TILE = AddonBlockRegistry.registerTile("magelight_lantern", MagelightLanternTile::new, () -> AddonBlockRegistry.getBlocks(AddonBlockNames.MAGELIGHT_LANTERNS));
        AddonBlockRegistry.registerWalls();
        AddonBlockRegistry.registerButtons();
        AddonBlockRegistry.registerDecorativeSourcestone();
        AddonBlockRegistry.registerDoors();
        AddonBlockRegistry.registerTrapdoors();
        AddonBlockRegistry.registerCarpets();
    }
}

