/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.event;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.common.advancement.Triggers;
import com.github.jarva.arsadditions.common.commands.SetLootTableCommand;
import com.github.jarva.arsadditions.common.ritual.RitualChunkLoading;
import com.github.jarva.arsadditions.setup.config.CommonConfig;
import com.github.jarva.arsadditions.setup.registry.AddonBlockRegistry;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.hollingsworth.arsnouveau.api.loot.DungeonLootTables;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.common.items.RitualTablet;
import com.hollingsworth.arsnouveau.setup.registry.CreativeTabRegistry;
import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

public class ModEvents {

    @Mod.EventBusSubscriber(modid="ars_additions", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ServerForgeEvents {
        @SubscribeEvent
        public static void started(ServerStartedEvent _event) {
            for (int i = 0; i < DungeonLootTables.UNCOMMON_LOOT.size(); ++i) {
                Supplier supplier = (Supplier)DungeonLootTables.UNCOMMON_LOOT.get(i);
                ItemStack stack = (ItemStack)supplier.get();
                if (!(stack.m_41720_() instanceof RitualTablet)) continue;
                DungeonLootTables.UNCOMMON_LOOT.set(i, () -> {
                    List<RitualTablet> tablets = new ArrayList(RitualRegistry.getRitualItemMap().values()).stream().filter(tablet -> {
                        if (tablet.ritual instanceof RitualChunkLoading) {
                            return (Boolean)CommonConfig.COMMON.config.get("ritual_enabled").get();
                        }
                        return true;
                    }).toList();
                    if (tablets.isEmpty()) {
                        return ItemStack.f_41583_;
                    }
                    return new ItemStack((ItemLike)tablets.get(DungeonLootTables.r.nextInt(tablets.size())));
                });
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void isPlayerInStructure(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                MinecraftServer server = event.getServer();
                if (server.m_129921_() % 20 != 0) {
                    return;
                }
                for (ServerPlayer player : server.m_6846_().m_11314_()) {
                    boolean isRuinedPortal = player.m_284548_().m_215010_().m_220491_(player.m_20183_(), TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)ArsAdditions.prefix("ruined_portals"))).m_73603_();
                    if (!isRuinedPortal) continue;
                    Triggers.FIND_RUINED_PORTAL.m_222618_(player);
                }
            }
        }

        @SubscribeEvent
        public static void commandRegister(RegisterCommandsEvent event) {
            SetLootTableCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
        }
    }

    @Mod.EventBusSubscriber(modid="ars_additions", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ServerModEvents {
        @SubscribeEvent
        public static void buildContents(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey() == CreativeTabRegistry.BLOCKS.getKey()) {
                for (RegistryObject<Item> registryObject : AddonItemRegistry.REGISTERED_ITEMS) {
                    event.accept(registryObject);
                }
                for (RegistryObject<Item> registryObject : AddonBlockRegistry.REGISTERED_BLOCKS) {
                    event.accept(registryObject);
                }
            }
        }
    }
}

