/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.datagen.worldgen;

import com.github.jarva.arsadditions.common.block.WarpNexus;
import com.github.jarva.arsadditions.setup.registry.AddonBlockRegistry;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.common.block.RuneBlock;
import com.hollingsworth.arsnouveau.common.block.ScribesBlock;
import com.hollingsworth.arsnouveau.common.block.SourceJar;
import com.hollingsworth.arsnouveau.common.block.ThreePartBlock;
import com.hollingsworth.arsnouveau.common.datagen.SimpleDataProvider;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockStateMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosAlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockStateMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.AppendStatic;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifier;

public class ProcessorDatagen
extends SimpleDataProvider {
    public ProcessorDatagen(DataGenerator dataGenerator) {
        super(dataGenerator);
    }

    public void collectJsons(CachedOutput pOutput) {
        ArrayList<ProcessorRule> nexusTower = new ArrayList<ProcessorRule>();
        nexusTower.add(this.randomBlockReplace(Blocks.f_50222_, Blocks.f_50223_, 0.5f));
        nexusTower.add(this.randomBlockReplace(Blocks.f_50222_, Blocks.f_50224_, 0.5f));
        nexusTower.add(this.randomBlockReplace(Blocks.f_50222_, Blocks.f_50069_, 0.1f));
        nexusTower.add(this.randomBlockReplace(Blocks.f_50222_, Blocks.f_50334_, 0.1f));
        nexusTower.add(this.randomBlockReplace(Blocks.f_50222_, Blocks.f_152496_, 0.1f));
        nexusTower.add(this.randomBlockReplace(Blocks.f_50222_, Blocks.f_50652_, 0.1f));
        nexusTower.add(this.randomBlockReplace(this.an("sourcestone_large_bricks"), this.aa("cracked_sourcestone_large_bricks"), 0.5f));
        nexusTower.add(this.randomBlockReplace(this.an("sourcestone_large_bricks"), this.an("gilded_sourcestone_large_bricks"), 0.2f));
        nexusTower.add(this.randomBlockReplace(this.an("sourcestone_large_bricks"), Blocks.f_50298_, 0.2f));
        nexusTower.add(this.randomBlockReplace(this.an("sourcestone_large_bricks"), this.an("sourcestone_alternating"), 0.2f));
        nexusTower.add(this.randomBlockStateReplace((BlockState)Blocks.f_50411_.m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP), (BlockState)Blocks.f_50645_.m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP), 0.2f));
        nexusTower.add(this.randomBlockStateReplace((BlockState)Blocks.f_50411_.m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM), (BlockState)Blocks.f_50645_.m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM), 0.2f));
        nexusTower.add(this.randomBlockReplace(this.an("sourcestone_large_bricks"), this.an("sourcestone_alternating"), 0.2f));
        this.setupWarpNexus(nexusTower);
        this.setupSourceJars(nexusTower);
        List<Helper> helpers = List.of(new Helper("Eru", "gray", "Warning: Not to leave unsupervised"), new Helper("Rozeta", "pink", "A curious Starbuncle that likes to build and experiment with magic."));
        HashMap<String, Integer> dyeMap = new HashMap<String, Integer>();
        for (DyeColor value : DyeColor.values()) {
            dyeMap.put(value.m_41065_(), value.m_41071_());
        }
        for (Helper helper : helpers) {
            CompoundTag tag = new CompoundTag();
            ItemStack is = new ItemStack((ItemLike)ItemsRegistry.STARBUNCLE_CHARM);
            CompoundTag it = is.m_41784_();
            it.m_128359_("name", Component.Serializer.m_130703_((Component)Component.m_237113_((String)helper.name()).m_130948_(Style.f_131099_.m_178520_(((Integer)dyeMap.get(helper.color())).intValue()))));
            it.m_128359_("bio", helper.bio());
            it.m_128359_("color", helper.color());
            tag.m_128365_("itemStack", (Tag)is.m_41739_(new CompoundTag()));
            this.modifyBlockEntity((Block)BlockRegistry.SCRIBES_BLOCK.get(), (BlockState bs) -> bs.m_61143_((Property)ScribesBlock.PART) == ThreePartBlock.HEAD, 0.5f, (RuleBlockEntityModifier)new AppendStatic(tag), nexusTower);
        }
        this.save(pOutput, nexusTower, "nexus_tower");
        ArrayList<ProcessorRule> arcaneLibrary = new ArrayList<ProcessorRule>();
        this.chargeRunes(arcaneLibrary);
        this.setupWarpNexus(arcaneLibrary);
        this.setupSourceJars(arcaneLibrary);
        this.save(pOutput, arcaneLibrary, "arcane_library");
    }

    private void setupSourceJars(List<ProcessorRule> rules) {
        for (Integer possibleValue : SourceJar.fill.m_6908_()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("source", Math.min((possibleValue - 1) * 1000, 0));
            this.modifyBlockEntity((Block)BlockRegistry.SOURCE_JAR.get(), (BlockState bs) -> true, bs -> (BlockState)bs.m_61124_(SourceJar.fill, (Comparable)possibleValue), (RuleBlockEntityModifier)new AppendStatic(tag), rules);
        }
    }

    private void setupWarpNexus(List<ProcessorRule> rules) {
        CompoundTag nexusBlock = new CompoundTag();
        CompoundTag inventory = new CompoundTag();
        ListTag items = new ListTag();
        CompoundTag scroll = new ItemStack((ItemLike)AddonItemRegistry.NEXUS_WARP_SCROLL.get()).m_41739_(new CompoundTag());
        scroll.m_128405_("Slot", 0);
        items.add((Object)scroll);
        inventory.m_128365_("Items", (Tag)items);
        nexusBlock.m_128365_("Inventory", (Tag)inventory);
        this.modifyBlockEntity((Block)AddonBlockRegistry.WARP_NEXUS.get(), (BlockState bs) -> bs.m_61143_(WarpNexus.HALF) == DoubleBlockHalf.LOWER, bs -> (BlockState)bs.m_61124_((Property)WarpNexus.REQUIRES_SOURCE, (Comparable)Boolean.valueOf(false)), (RuleBlockEntityModifier)new AppendStatic(nexusBlock), rules);
        this.modifyBlockEntity((Block)AddonBlockRegistry.WARP_NEXUS.get(), (BlockState bs) -> bs.m_61143_(WarpNexus.HALF) == DoubleBlockHalf.UPPER, bs -> (BlockState)bs.m_61124_((Property)WarpNexus.REQUIRES_SOURCE, (Comparable)Boolean.valueOf(false)), (RuleBlockEntityModifier)new AppendStatic(new CompoundTag()), rules);
    }

    private void chargeRunes(List<ProcessorRule> rules) {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("charged", true);
        tag.m_128379_("temporary", false);
        tag.m_128362_("uuid", ANFakePlayer.PROFILE.getId());
        this.modifyBlockEntity((Block)BlockRegistry.RUNE_BLOCK.get(), bs -> (Boolean)bs.m_61143_((Property)RuneBlock.POWERED) == false, bs -> (BlockState)bs.m_61124_((Property)RuneBlock.POWERED, (Comparable)Boolean.valueOf(true)), Float.valueOf(1.0f), (RuleBlockEntityModifier)new AppendStatic(tag), rules);
    }

    private void modifyBlockEntity(Block block, Predicate<BlockState> filter, Function<BlockState, BlockState> output, RuleBlockEntityModifier modifier, List<ProcessorRule> rules) {
        this.modifyBlockEntity(block, filter, output, null, modifier, rules);
    }

    private void modifyBlockEntity(Block block, Predicate<BlockState> filter, float probability, RuleBlockEntityModifier modifier, List<ProcessorRule> rules) {
        this.modifyBlockEntity(block, filter, bs -> bs, Float.valueOf(probability), modifier, rules);
    }

    private void modifyBlockEntity(Block block, Predicate<BlockState> filter, Function<BlockState, BlockState> output, Float probability, RuleBlockEntityModifier modifier, List<ProcessorRule> rules) {
        for (BlockState possibleState : block.m_49965_().m_61056_()) {
            if (!filter.test(possibleState)) continue;
            RandomBlockStateMatchTest test = probability != null ? new RandomBlockStateMatchTest(possibleState, probability.floatValue()) : new BlockStateMatchTest(possibleState);
            rules.add(new ProcessorRule((RuleTest)test, (RuleTest)AlwaysTrueTest.f_73954_, (PosRuleTest)PosAlwaysTrueTest.f_74188_, output.apply(possibleState), modifier));
        }
    }

    private void save(CachedOutput pOutput, List<ProcessorRule> rules, String name) {
        StructureProcessorList list = new StructureProcessorList((List)ImmutableList.of((Object)new RuleProcessor(rules)));
        DataResult result = StructureProcessorType.f_74467_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)list);
        result.result().ifPresent(element -> this.saveStable(pOutput, (JsonElement)element, this.getPath(name)));
    }

    private Path getPath(String name) {
        return this.output.resolve("data/ars_additions/worldgen/processor_list/" + name + ".json");
    }

    private Block aa(String name) {
        return AddonBlockRegistry.getBlock(name);
    }

    private Block an(String name) {
        return BlockRegistry.getBlock((String)name);
    }

    private ProcessorRule randomBlockStateReplace(BlockState input, Block output, float probability) {
        return this.randomBlockStateReplace(input, output.m_49966_(), probability);
    }

    private ProcessorRule randomBlockStateReplace(BlockState input, BlockState output, float probability) {
        return new ProcessorRule((RuleTest)new RandomBlockStateMatchTest(input, probability), (RuleTest)AlwaysTrueTest.f_73954_, output);
    }

    private ProcessorRule randomBlockReplace(Block input, Block output, float probability) {
        return this.randomBlockReplace(input, output.m_49966_(), probability);
    }

    private ProcessorRule randomBlockReplace(Block input, BlockState output, float probability) {
        return new ProcessorRule((RuleTest)new RandomBlockMatchTest(input, probability), (RuleTest)AlwaysTrueTest.f_73954_, output);
    }

    public String m_6055_() {
        return "Processor Lists";
    }

    record Helper(String name, String color, String bio) {
    }
}

