/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.item.curios;

import com.github.jarva.arsadditions.server.util.TeleportUtil;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.github.jarva.arsadditions.setup.registry.CharmRegistry;
import com.hollingsworth.arsnouveau.api.event.DispelEvent;
import com.hollingsworth.arsnouveau.api.item.ArsNouveauCurio;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;

@Mod.EventBusSubscriber(modid="ars_additions", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Charm
extends ArsNouveauCurio {
    private final int uses;

    public Charm(int uses) {
        super(AddonItemRegistry.defaultItemProperties().m_41487_(1).m_41503_(uses));
        this.uses = uses;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.ars_additions.charm.desc").m_130940_(ChatFormatting.GRAY));
        int charges = stack.m_41782_() ? stack.m_41783_().m_128451_("charges") : this.uses;
        tooltip.add((Component)Component.m_237110_((String)"tooltip.ars_additions.charm.charges", (Object[])new Object[]{charges, this.uses}).m_130940_(ChatFormatting.GOLD));
        String descKey = Util.m_137492_((String)"tooltip", (ResourceLocation)BuiltInRegistries.f_257033_.m_7981_((Object)this));
        tooltip.add((Component)Component.m_237115_((String)descKey).m_130940_(ChatFormatting.GRAY));
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("charges")) {
            tag.m_128405_("charges", this.uses);
        }
        return super.initCapabilities(stack, nbt);
    }

    public int getMaxDamage(ItemStack stack) {
        return this.uses;
    }

    public int getDamage(ItemStack stack) {
        if (!stack.m_41782_()) {
            return 0;
        }
        int charges = stack.m_41784_().m_128451_("charges");
        return this.uses - charges;
    }

    public boolean m_142522_(ItemStack stack) {
        if (!stack.m_41782_()) {
            return false;
        }
        int charges = stack.m_41784_().m_128451_("charges");
        return charges != this.uses;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return super.canElytraFly(stack, entity);
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean isDamageable(ItemStack stack) {
        return CharmRegistry.isEnabled(stack);
    }

    public boolean isEnderMask(ItemStack stack, Player player, EnderMan endermanEntity) {
        return this.isEnderMask((LivingEntity)player, endermanEntity);
    }

    public boolean isEnderMask(SlotContext slotContext, EnderMan enderMan, ItemStack stack) {
        return this.isEnderMask(slotContext.entity(), enderMan);
    }

    public boolean isEnderMask(LivingEntity entity, EnderMan enderMan) {
        return CharmRegistry.processCharmEvent(entity, CharmRegistry.CharmType.ENDER_MASK, () -> {
            Vec3 view = entity.m_20252_(1.0f).m_82541_();
            Vec3 vec = new Vec3(enderMan.m_20185_() - entity.m_20185_(), enderMan.m_20188_() - entity.m_20188_(), enderMan.m_20189_() - entity.m_20189_());
            double d0 = vec.m_82553_();
            double d1 = view.m_82526_(vec = vec.m_82541_());
            return d1 > 1.0 - 0.025 / d0 && entity.m_142582_((Entity)enderMan);
        }, (e, curio) -> CharmRegistry.every(10, entity, 1));
    }

    public boolean makesPiglinsNeutral(SlotContext slotContext, ItemStack stack) {
        return this.makesPiglinsNeutral(slotContext.entity());
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return this.makesPiglinsNeutral(wearer);
    }

    public boolean makesPiglinsNeutral(LivingEntity wearer) {
        return CharmRegistry.isEnabled(CharmRegistry.CharmType.GOLDEN, wearer);
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return this.canWalkOnPowderedSnow(wearer);
    }

    public boolean canWalkOnPowderedSnow(SlotContext slotContext, ItemStack stack) {
        return this.canWalkOnPowderedSnow(slotContext.entity());
    }

    public boolean canWalkOnPowderedSnow(LivingEntity wearer) {
        return CharmRegistry.processCharmEvent(wearer, CharmRegistry.CharmType.POWDERED_SNOW_WALK, () -> true, (entity, curio) -> CharmRegistry.every(10, entity, 1));
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.tick(stack, livingEntity);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        this.tick(stack, slotContext.entity());
    }

    public void tick(ItemStack stack, LivingEntity entity) {
        CharmRegistry.processCharmEvent(entity, CharmRegistry.CharmType.FALL_PREVENTION, () -> entity.f_19789_ > 3.0f, (e, curio) -> {
            e.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 100));
            return 1;
        });
        CharmRegistry.processCharmEvent(entity, CharmRegistry.CharmType.NIGHT_VISION, () -> {
            int brightness = entity.m_9236_().m_45524_(entity.m_20183_(), entity.m_9236_().m_7445_());
            MobEffectInstance nightvision = entity.m_21124_(MobEffects.f_19611_);
            return brightness < 5 && (nightvision == null || nightvision.m_19557_() <= 200);
        }, (e, curio) -> {
            e.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 600));
            return 1;
        });
        CharmRegistry.processCharmEvent(entity, CharmRegistry.CharmType.VOID_PROTECTION, () -> {
            if (!entity.m_20096_()) {
                return false;
            }
            BlockPos below = entity.m_20183_().m_7495_();
            return entity.m_9236_().m_8055_(below).m_60796_((BlockGetter)entity.m_9236_(), below);
        }, (e, curio) -> {
            GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)GlobalPos.m_122643_((ResourceKey)e.m_9236_().m_46472_(), (BlockPos)e.m_20183_())).result().ifPresent(pos -> curio.m_41783_().m_128365_("Pos", pos));
            return 0;
        });
    }

    @SubscribeEvent
    public static void handeUndying(LivingDeathEvent event) {
        CharmRegistry.processCharmEvent(event.getEntity(), CharmRegistry.CharmType.UNDYING, () -> event.getEntity() instanceof Player, (entity, curio) -> {
            entity.m_21153_(1.0f);
            entity.m_21219_();
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 900, 1));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 800, 0));
            entity.m_9236_().m_7605_((Entity)entity, (byte)35);
            event.setCanceled(true);
            return 1;
        });
    }

    @SubscribeEvent
    public static void handleDamage(LivingAttackEvent event) {
        CharmRegistry.processCharmEvent(event.getEntity(), CharmRegistry.CharmType.FIRE_RESISTANCE, () -> event.getSource().m_269533_(DamageTypeTags.f_268745_), (entity, curio) -> {
            event.setCanceled(true);
            if (event.getSource().m_276093_(DamageTypes.f_268546_)) {
                return CharmRegistry.every(10, entity, (int)event.getAmount());
            }
            return (int)event.getAmount();
        });
        CharmRegistry.processCharmEvent(event.getEntity(), CharmRegistry.CharmType.WATER_BREATHING, () -> event.getSource().m_269533_(DamageTypeTags.f_268581_), (entity, curio) -> {
            event.setCanceled(true);
            return (int)event.getAmount();
        });
        CharmRegistry.processCharmEvent(event.getEntity(), CharmRegistry.CharmType.VOID_PROTECTION, () -> event.getSource().m_276093_(DamageTypes.f_268724_), (entity, curio) -> {
            event.setCanceled(true);
            Level patt9962$temp = entity.m_9236_();
            if (patt9962$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt9962$temp;
                CompoundTag tag = curio.m_41783_();
                GlobalPos.f_122633_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128469_("Pos")).result().ifPresent(pos -> {
                    TeleportUtil.teleport(serverLevel.m_7654_().m_129880_(pos.m_122640_()), pos.m_122646_(), entity.m_20155_(), (Entity)entity);
                    entity.m_183634_();
                });
            }
            return 1;
        });
        CharmRegistry.processCharmEvent(event.getEntity(), CharmRegistry.CharmType.SONIC_BOOM_PROTECTION, () -> event.getSource().m_276093_(DamageTypes.f_268679_), (entity, curio) -> {
            event.setCanceled(true);
            return 1;
        });
    }

    @SubscribeEvent
    public static void denyMobEffects(MobEffectEvent.Applicable event) {
        CharmRegistry.processCharmEvent(event.getEntity(), CharmRegistry.CharmType.WITHER_PROTECTION, () -> event.getEffectInstance().m_19544_().equals(MobEffects.f_19615_), (entity, curio) -> {
            event.setResult(Event.Result.DENY);
            return CharmRegistry.every(2, entity, 1);
        });
    }

    @SubscribeEvent
    public static void handeDispel(DispelEvent.Pre event) {
        EntityHitResult entityHitResult;
        HitResult hitResult = event.rayTraceResult;
        if (hitResult instanceof EntityHitResult && (hitResult = (entityHitResult = (EntityHitResult)hitResult).m_82443_()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)hitResult;
            CharmRegistry.processCharmEvent(livingEntity, CharmRegistry.CharmType.DISPEL_PROTECTION, () -> !event.shooter.equals((Object)livingEntity), (entity, curio) -> {
                event.setCanceled(true);
                return 1;
            });
        }
    }
}

