/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.glyph;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.common.glyph.EffectMark;
import com.github.jarva.arsadditions.common.item.UnstableReliquary;
import com.github.jarva.arsadditions.server.util.MarkType;
import com.github.jarva.arsadditions.setup.registry.names.AddonGlyphNames;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.CastResolveType;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.TileCaster;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodRecall
extends AbstractCastMethod {
    public static MethodRecall INSTANCE = new MethodRecall();

    private MethodRecall() {
        super(ArsAdditions.prefix(AddonGlyphNames.MethodRecall), "Recall");
    }

    public String getBookDescription() {
        return "Recalls the target stored in a Reliquary and casts the spell on it.";
    }

    public CastResolveType onCast(@Nullable ItemStack stack, LivingEntity playerEntity, Level world, SpellStats spellStats, SpellContext context, SpellResolver resolver) {
        return this.cast(context, playerEntity, resolver);
    }

    public CastResolveType onCastOnBlock(UseOnContext context, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Player player = context.m_43723_();
        if (player == null) {
            return CastResolveType.FAILURE;
        }
        return this.cast(spellContext, (LivingEntity)player, resolver);
    }

    public CastResolveType onCastOnBlock(BlockHitResult blockRayTraceResult, LivingEntity caster, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        return this.cast(spellContext, caster, resolver);
    }

    public CastResolveType onCastOnEntity(@Nullable ItemStack stack, LivingEntity caster, Entity target, InteractionHand hand, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        return this.cast(spellContext, caster, resolver);
    }

    public CastResolveType cast(SpellContext context, LivingEntity caster, SpellResolver resolver) {
        ItemStack reliquary = UnstableReliquary.getReliquaryFromCaster(context, caster);
        if (reliquary == null) {
            return CastResolveType.FAILURE;
        }
        Level level = caster.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return CastResolveType.FAILURE;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        MarkType mark = UnstableReliquary.getMarkType(reliquary);
        if (mark == null) {
            return CastResolveType.FAILURE;
        }
        CompoundTag tag = reliquary.m_41783_();
        CompoundTag data = tag.m_128469_("mark_data");
        if (mark == MarkType.ENTITY) {
            UUID uuid = data.m_128342_("entity_uuid");
            Entity found = serverLevel.m_8791_(uuid);
            if (found == null) {
                UnstableReliquary.breakReliquary(reliquary);
                return CastResolveType.FAILURE;
            }
            resolver.onResolveEffect((Level)serverLevel, (HitResult)new EntityHitResult(found));
            UnstableReliquary.damage(mark, reliquary, caster, found);
            return CastResolveType.SUCCESS;
        }
        if (mark == MarkType.LOCATION) {
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)data.m_128469_("block_pos"));
            String dim = data.m_128461_("block_dimension");
            if (!dim.equals(caster.m_9236_().m_46472_().m_135782_().toString())) {
                return CastResolveType.FAILURE;
            }
            Direction direction = caster.m_6350_();
            IWrappedCaster iWrappedCaster = context.getCaster();
            if (iWrappedCaster instanceof TileCaster) {
                TileCaster tileCaster = (TileCaster)iWrappedCaster;
                direction = tileCaster.getFacingDirection();
            }
            BlockHitResult bhr = new BlockHitResult(pos.m_252807_(), direction, pos, false);
            resolver.onResolveEffect(caster.m_9236_(), (HitResult)bhr);
            UnstableReliquary.damage(mark, reliquary, caster);
            return CastResolveType.SUCCESS;
        }
        return CastResolveType.FAILURE;
    }

    protected void addDefaultInvalidCombos(Set<ResourceLocation> defaults) {
        defaults.add(EffectMark.INSTANCE.getRegistryName());
    }

    protected int getDefaultManaCost() {
        return 50;
    }

    public SpellTier defaultTier() {
        return SpellTier.THREE;
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[0]);
    }
}

