/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.capability;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.common.capability.CapabilityRegistry;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NexusCapability
implements INBTSerializable<CompoundTag>,
ICapabilityProvider {
    private final Player player;
    public static final ResourceLocation IDENTIFIER = ArsAdditions.prefix("nexus");
    private final ItemStackHandler inventory = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
        }
    };
    private final LazyOptional<ItemStackHandler> optional = LazyOptional.of(() -> this.inventory);

    public NexusCapability(Player player) {
        this.player = player;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        return tag;
    }

    public void deserializeNBT(CompoundTag arg) {
        this.inventory.deserializeNBT(arg.m_128469_("Inventory"));
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
        return CapabilityRegistry.PLAYER_NEXUS_CAPABILITY.orEmpty(capability, this.optional);
    }
}

