/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.darkdoppelganger.spells;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.Optional;
import java.util.UUID;
import net.bandit.darkdoppelganger.entity.DarkDoppelgangerMinionEntity;
import net.bandit.darkdoppelganger.entity.EntityRegistry;
import net.bandit.darkdoppelganger.entity.PortalJoinEntity;
import net.bandit.darkdoppelganger.registry.ModAnimations;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class SummonDoppelMinionSpell
extends AbstractSpell {
    private static final String NBT_PLAYER_MINION_UUID = "DarkDoppel_SummonerMinionUUID";
    private static final String PERSISTED_TAG = "darkdoppelganger";
    private static final String NBT_WARN_COOLDOWN = "MinionWarnCooldown";
    private static final int WARN_COOLDOWN_TICKS = 40;
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"darkdoppelganger", (String)"summon_doppel_minion");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.ENDER_RESOURCE).setMaxLevel(1).setCooldownSeconds(25.0).setAllowCrafting(false).build();

    public SummonDoppelMinionSpell() {
        this.baseManaCost = 35;
        this.manaCostPerLevel = 0;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 0;
        this.castTime = 40;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public int getCastTime(int spellLevel) {
        return this.castTime;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of(SoundEvents.f_11852_);
    }

    public AnimationHolder getCastFinishAnimation() {
        return ModAnimations.PLAYER_JOIN;
    }

    public boolean allowCrafting() {
        return true;
    }

    public boolean allowLooting() {
        return true;
    }

    public void onServerCastComplete(Level level, int spellLevel, LivingEntity caster, MagicData magicData, boolean cancelled) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!(caster instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)caster;
        if (cancelled) {
            magicData.resetCastingState();
            player.m_5810_();
            super.onServerCastComplete(level, spellLevel, caster, magicData, true);
            return;
        }
        if (SummonDoppelMinionSpell.hasLivingMinion(serverLevel, player)) {
            SummonDoppelMinionSpell.warnOnce(player, (Component)Component.m_237113_((String)"You already have a minion summoned."));
            magicData.resetCastingState();
            player.m_5810_();
            super.onServerCastComplete(level, spellLevel, caster, magicData, true);
            return;
        }
        Vec3 spawnPos = SummonDoppelMinionSpell.findSafeSpawnLocation(serverLevel, caster, 4.0f);
        PortalJoinEntity portal = new PortalJoinEntity((EntityType)EntityRegistry.PORTAL_JOIN_ENTITY.get(), (Level)serverLevel);
        portal.m_146884_(spawnPos);
        portal.m_146922_(caster.m_146908_());
        portal.f_19859_ = caster.m_146908_();
        serverLevel.m_7967_((Entity)portal);
        DarkDoppelgangerMinionEntity minion = (DarkDoppelgangerMinionEntity)((EntityType)EntityRegistry.DARK_DOPPELGANGER_MINION.get()).m_20615_((Level)serverLevel);
        if (minion == null) {
            return;
        }
        minion.m_146884_(spawnPos);
        minion.m_146922_(caster.m_146908_());
        minion.f_19859_ = caster.m_146908_();
        minion.setSummonerUUID(player.m_20148_());
        minion.setBossMinion(false);
        minion.m_6593_((Component)Component.m_237113_((String)(player.m_36316_().getName() + "'s Minion")));
        minion.m_20340_(true);
        serverLevel.m_7967_((Entity)minion);
        SummonDoppelMinionSpell.setStoredMinionUUID(player, minion.m_20148_());
        super.onServerCastComplete(level, spellLevel, caster, magicData, false);
    }

    private static boolean hasLivingMinion(ServerLevel level, ServerPlayer player) {
        DarkDoppelgangerMinionEntity minion;
        UUID uuid = SummonDoppelMinionSpell.getStoredMinionUUID(player);
        if (uuid == null) {
            return false;
        }
        Entity e = level.m_8791_(uuid);
        if (e instanceof DarkDoppelgangerMinionEntity && (minion = (DarkDoppelgangerMinionEntity)e).m_6084_() && !minion.isBossMinion() && player.m_20148_().equals(minion.getSummonerUUID())) {
            return true;
        }
        SummonDoppelMinionSpell.setStoredMinionUUID(player, null);
        return false;
    }

    @Nullable
    private static UUID getStoredMinionUUID(ServerPlayer player) {
        CompoundTag tag = player.getPersistentData();
        return tag.m_128403_(NBT_PLAYER_MINION_UUID) ? tag.m_128342_(NBT_PLAYER_MINION_UUID) : null;
    }

    private static void setStoredMinionUUID(ServerPlayer player, @Nullable UUID uuid) {
        CompoundTag tag = player.getPersistentData();
        if (uuid == null) {
            tag.m_128473_(NBT_PLAYER_MINION_UUID);
        } else {
            tag.m_128362_(NBT_PLAYER_MINION_UUID, uuid);
        }
    }

    private static void warnOnce(ServerPlayer player, Component msg) {
        CompoundTag root = player.getPersistentData();
        CompoundTag data = root.m_128469_(PERSISTED_TAG);
        int cd = data.m_128451_(NBT_WARN_COOLDOWN);
        if (cd <= 0) {
            player.m_213846_(msg);
            data.m_128405_(NBT_WARN_COOLDOWN, 40);
            root.m_128365_(PERSISTED_TAG, (Tag)data);
        }
    }

    static Vec3 findSafeSpawnLocation(ServerLevel level, LivingEntity caster, float maxDistance) {
        BlockHitResult hit = Utils.getTargetBlock((Level)level, (LivingEntity)caster, (ClipContext.Fluid)ClipContext.Fluid.NONE, (double)maxDistance);
        BlockPos base = hit.m_82425_();
        int radius = 2;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                BlockPos candidate = base.m_7918_(dx, 0, dz);
                for (int dy = 2; dy >= -2; --dy) {
                    BlockPos feet = candidate.m_7918_(0, dy, 0);
                    if (!SummonDoppelMinionSpell.isStandable(level, feet)) continue;
                    return Vec3.m_82539_((Vec3i)feet).m_82520_(0.0, 0.01, 0.0);
                }
            }
        }
        Vec3 forward = caster.m_20156_().m_82541_().m_82490_(1.5);
        Vec3 fallback = caster.m_20182_().m_82549_(forward);
        return new Vec3(fallback.f_82479_, caster.m_20186_(), fallback.f_82481_);
    }

    private static boolean isStandable(ServerLevel level, BlockPos feetPos) {
        BlockPos below = feetPos.m_7495_();
        if (level.m_8055_(below).m_60795_()) {
            return false;
        }
        if (!level.m_8055_(feetPos).m_60795_()) {
            return false;
        }
        return level.m_8055_(feetPos.m_7494_()).m_60795_();
    }
}

