/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.darkdoppelganger.spells;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.network.particles.TeleportParticlesPacket;
import io.redspace.ironsspellbooks.setup.Messages;
import java.util.List;
import java.util.Optional;
import net.bandit.darkdoppelganger.entity.EntityRegistry;
import net.bandit.darkdoppelganger.entity.PortalJoinEntity;
import net.bandit.darkdoppelganger.entity.PortalLeaveEntity;
import net.bandit.darkdoppelganger.registry.ModAnimations;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class DoppelPortalSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"darkdoppelganger", (String)"doppel_portal");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.ENDER_RESOURCE).setMaxLevel(1).setCooldownSeconds(8.0).build();
    private static final String NBT_ROOT = "dd_doppel_portal";
    private static final String NBT_LEAVE_SPAWNED = "leaveSpawned";
    private static final String NBT_ORIGIN_X = "ox";
    private static final String NBT_ORIGIN_Y = "oy";
    private static final String NBT_ORIGIN_Z = "oz";
    private static final String NBT_ORIGIN_YAW = "oyaw";

    public DoppelPortalSpell() {
        this.baseManaCost = 10;
        this.manaCostPerLevel = 0;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 0;
        this.castTime = 14;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public int getCastTime(int spellLevel) {
        return this.castTime;
    }

    public CastType getCastType() {
        return CastType.CONTINUOUS;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of(SoundEvents.f_11852_);
    }

    public AnimationHolder getCastFinishAnimation() {
        return ModAnimations.PLAYER_JOIN;
    }

    public AnimationHolder getCastStartAnimation() {
        return ModAnimations.PLAYER_LEAVE;
    }

    public boolean allowCrafting() {
        return false;
    }

    public boolean allowLooting() {
        return false;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData magicData) {
        CompoundTag data;
        if (!level.f_46443_ && !(data = entity.getPersistentData().m_128469_(NBT_ROOT)).m_128471_(NBT_LEAVE_SPAWNED)) {
            data.m_128379_(NBT_LEAVE_SPAWNED, true);
            data.m_128347_(NBT_ORIGIN_X, entity.m_20185_());
            data.m_128347_(NBT_ORIGIN_Y, entity.m_20186_());
            data.m_128347_(NBT_ORIGIN_Z, entity.m_20189_());
            data.m_128350_(NBT_ORIGIN_YAW, entity.m_146908_());
            entity.getPersistentData().m_128365_(NBT_ROOT, (Tag)data);
            PortalLeaveEntity portal = new PortalLeaveEntity((EntityType)EntityRegistry.PORTAL_LEAVE_ENTITY.get(), level);
            portal.m_146922_(entity.m_146908_());
            portal.f_19859_ = entity.m_146908_();
            portal.m_146884_(entity.m_20182_());
            level.m_7967_((Entity)portal);
        }
        super.onCast(level, spellLevel, entity, castSource, magicData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServerCastComplete(Level level, int spellLevel, LivingEntity entity, MagicData magicData, boolean cancelled) {
        try {
            if (cancelled) {
                return;
            }
            float maxDistance = this.getEvadeDistance(entity);
            Vec3 dest = DoppelPortalSpell.findSafeTeleportLocation(level, entity, maxDistance);
            Messages.sendToPlayersTrackingEntity((Object)new TeleportParticlesPacket(entity.m_20182_(), dest), (Entity)entity, (boolean)true);
            if (entity.m_20159_()) {
                entity.m_8127_();
            }
            entity.m_6021_(dest.f_82479_, dest.f_82480_, dest.f_82481_);
            entity.m_183634_();
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 25, 0, false, false, true));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 30, 0, false, false, true));
            this.getCastFinishSound().ifPresent(sound -> entity.m_5496_(sound, 2.0f, 1.0f));
            PortalJoinEntity portal = new PortalJoinEntity((EntityType)EntityRegistry.PORTAL_JOIN_ENTITY.get(), level);
            portal.m_146922_(entity.m_146908_());
            portal.f_19859_ = entity.m_146908_();
            portal.m_146884_(dest);
            level.m_7967_((Entity)portal);
        }
        finally {
            entity.getPersistentData().m_128473_(NBT_ROOT);
            super.onServerCastComplete(level, spellLevel, entity, magicData, cancelled);
        }
    }

    private float getEvadeDistance(LivingEntity entity) {
        double mult = Utils.softCapFormula((double)this.getEntityPowerMultiplier(entity));
        double base = 16.0;
        double scaled = base * (0.9 + 0.25 * mult);
        return (float)Math.max(12.0, Math.min(26.0, scaled));
    }

    public static Vec3 findSafeTeleportLocation(Level level, LivingEntity entity, float maxDistance) {
        BlockHitResult hit = Utils.getTargetBlock((Level)level, (LivingEntity)entity, (ClipContext.Fluid)ClipContext.Fluid.NONE, (double)maxDistance);
        BlockPos base = hit.m_82425_();
        int radius = 2;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                BlockPos candidate = base.m_7918_(dx, 0, dz);
                for (int dy = 3; dy >= -3; --dy) {
                    BlockPos feet = candidate.m_7918_(0, dy, 0);
                    if (!DoppelPortalSpell.isStandable(level, feet)) continue;
                    return Vec3.m_82539_((Vec3i)feet).m_82520_(0.0, 0.01, 0.0);
                }
            }
        }
        return DoppelPortalSpell.findTeleportLocationFallback(level, entity, maxDistance);
    }

    private static boolean isStandable(Level level, BlockPos feetPos) {
        BlockPos below = feetPos.m_7495_();
        if (level.m_8055_(below).m_60795_()) {
            return false;
        }
        if (!level.m_8055_(feetPos).m_60795_()) {
            return false;
        }
        return level.m_8055_(feetPos.m_7494_()).m_60795_();
    }

    public static Vec3 findTeleportLocationFallback(Level level, LivingEntity entity, float maxDistance) {
        boolean los;
        BlockHitResult blockHitResult = Utils.getTargetBlock((Level)level, (LivingEntity)entity, (ClipContext.Fluid)ClipContext.Fluid.NONE, (double)maxDistance);
        BlockPos pos = blockHitResult.m_82425_();
        Vec3 bbOffset = entity.m_20156_().m_82541_().m_82542_((double)(entity.m_20205_() / 3.0f), 0.0, (double)(entity.m_20205_() / 3.0f));
        Vec3 bbImpact = blockHitResult.m_82450_().m_82546_(bbOffset);
        int ledgeY = (int)level.m_45547_((ClipContext)new ClipContext((Vec3)Vec3.m_82539_((Vec3i)pos).m_82520_((double)0.0, (double)3.0, (double)0.0), (Vec3)Vec3.m_82539_((Vec3i)pos), (ClipContext.Block)ClipContext.Block.COLLIDER, (ClipContext.Fluid)ClipContext.Fluid.NONE, null)).m_82450_().f_82480_;
        BlockPos ledgePos = new BlockPos(pos.m_123341_(), ledgeY, pos.m_123343_());
        boolean isAir = level.m_8055_(ledgePos).m_60795_();
        boolean bl = los = level.m_45547_(new ClipContext(bbImpact, bbImpact.m_82520_(0.0, (double)(ledgeY - pos.m_123342_()), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity)).m_6662_() == HitResult.Type.MISS;
        if (isAir && los && Math.abs(ledgeY - pos.m_123342_()) <= 3) {
            return new Vec3((double)pos.m_123341_() + 0.5, (double)ledgeY + 0.01, (double)pos.m_123343_() + 0.5);
        }
        return level.m_45547_(new ClipContext(bbImpact, bbImpact.m_82520_(0.0, (double)(-entity.m_20206_()), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity)).m_82450_().m_82520_(0.0, 0.01, 0.0);
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        float dist = caster != null ? this.getEvadeDistance(caster) : 16.0f;
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.distance", (Object[])new Object[]{Utils.stringTruncation((double)dist, (int)1)}));
    }
}

