/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.darkdoppelganger.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;

public class DarkDoppelBossBar {
    public static final DarkDoppelBossBar INSTANCE = new DarkDoppelBossBar();
    private static final ResourceLocation FRAME = ResourceLocation.fromNamespaceAndPath((String)"darkdoppelganger", (String)"textures/gui/doppel_bossbar.png");
    private static final ResourceLocation FILL = ResourceLocation.fromNamespaceAndPath((String)"darkdoppelganger", (String)"textures/gui/doppel_fill.png");
    private static final int FRAME_WIDTH = 250;
    private static final int FRAME_HEIGHT = 50;
    private static final int BAR_WIDTH = 182;
    private static final int BAR_HEIGHT = 5;
    private static final int BAR_OFFSET_X = 34;
    private static final int BAR_OFFSET_Y = 12;

    private DarkDoppelBossBar() {
    }

    public void renderBossBar(CustomizeGuiOverlayEvent.BossEventProgress event) {
        GuiGraphics guiGraphics = event.getGuiGraphics();
        int screenWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        int x = (screenWidth - 250) / 2;
        int y = event.getY();
        float progress = event.getBossEvent().m_142717_();
        int filled = (int)(progress * 182.0f);
        event.setCanceled(true);
        if (filled > 0) {
            guiGraphics.m_280163_(FILL, x + 34, y + 12, 0.0f, 0.0f, filled, 5, 256, 256);
        }
        guiGraphics.m_280163_(FRAME, x, y, 0.0f, 0.0f, 250, 50, 250, 50);
        Component name = event.getBossEvent().m_18861_();
        int textX = screenWidth / 2 - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)name) / 2;
        guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, name, textX, y - 8, 0xAA44FF);
        event.setIncrement(50);
    }
}

