/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class EmberlashSwordItem
extends UniqueSwordItem {
    private static int stepMod = 0;
    public static boolean scalesWithSpellPower;

    public EmberlashSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            ServerLevel world = (ServerLevel)attacker.m_9236_();
            DamageSource damageSource = world.m_269111_().m_269264_();
            float abilityDamage = this.m_43299_();
            float spellScalingModifier = Config.getFloat("smoulderSpellScaling", "UniqueEffects", ConfigDefaultValues.smoulderSpellScaling);
            if (HelperMethods.commonSpellAttributeScaling(spellScalingModifier, (Entity)attacker, "fire") > this.m_43299_()) {
                abilityDamage = HelperMethods.commonSpellAttributeScaling(spellScalingModifier, (Entity)attacker, "fire");
                scalesWithSpellPower = true;
            }
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                damageSource = attacker.m_269291_().m_269075_(player);
            }
            int maximum_stacks = (int)Config.getFloat("smoulderMaxStacks", "UniqueEffects", ConfigDefaultValues.smoulderMaxStacks);
            HelperMethods.playHitSounds(attacker, target);
            if (target.m_21023_((MobEffect)EffectRegistry.SMOULDERING.get())) {
                target.f_19802_ = 0;
                MobEffectInstance smoulderingEffect = target.m_21124_((MobEffect)EffectRegistry.SMOULDERING.get());
                if (smoulderingEffect != null) {
                    float damageMultiplier = 0.15f * (float)smoulderingEffect.m_19564_();
                    target.m_6469_(damageSource, abilityDamage * damageMultiplier);
                }
            }
            HelperMethods.incrementStatusEffect(target, (MobEffect)EffectRegistry.SMOULDERING.get(), 100, 1, maximum_stacks + 1);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        int skillCooldown = (int)Config.getFloat("smoulderCooldown", "UniqueEffects", ConfigDefaultValues.smoulderCooldown);
        user.m_6674_(hand);
        world.m_5594_(null, user.m_20183_(), (SoundEvent)SoundRegistry.SPELL_FIRE.get(), user.m_5720_(), 0.5f, 1.0f);
        user.m_20256_(user.m_20154_().m_82548_().m_82490_(1.5));
        user.m_20334_(user.m_20184_().f_82479_, 0.0, user.m_20184_().f_82481_);
        user.f_19864_ = true;
        user.m_5634_(user.m_21233_() * 0.15f);
        user.m_36335_().m_41524_((Item)this, skillCooldown);
        return super.m_7203_(world, user, hand);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, ParticleTypes.f_123801_, ParticleTypes.f_123762_, ParticleTypes.f_123762_, true);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style RIGHTCLICK = HelperMethods.getStyle("rightclick");
        Style ABILITY = HelperMethods.getStyle("ability");
        Style TEXT = HelperMethods.getStyle("text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.emberlashsworditem.tooltip1").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.emberlashsworditem.tooltip2").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.emberlashsworditem.tooltip3").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.emberlashsworditem.tooltip4").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237110_((String)"item.simplyswords.emberlashsworditem.tooltip5", (Object[])new Object[]{Float.valueOf(this.m_43299_() * 0.2f)}).m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(RIGHTCLICK));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.emberlashsworditem.tooltip6").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237110_((String)"item.simplyswords.emberlashsworditem.tooltip7", (Object[])new Object[]{Float.valueOf(Config.getFloat("smoulderHeal", "UniqueEffects", ConfigDefaultValues.smoulderHeal))}).m_6270_(TEXT));
        if (scalesWithSpellPower) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.compat.scaleFire"));
        }
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

