/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.effect.OrbitingEffect;
import net.sweenus.simplyswords.effect.instance.SimplySwordsStatusEffectInstance;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.SoundHelper;

public class ElementalVortexEffect
extends OrbitingEffect {
    public LivingEntity sourceEntity;
    public int additionalData;

    public ElementalVortexEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
        this.setParticleType((ParticleOptions)ParticleTypes.f_123796_);
    }

    public void setSourcePlayer(LivingEntity livingEntity) {
        this.sourceEntity = livingEntity;
    }

    public void setAdditionalData(int data) {
        this.additionalData = data;
    }

    @Override
    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.m_9236_().m_5776_()) {
            ServerLevel serverWorld = (ServerLevel)livingEntity.m_9236_();
            float abilityDamageFire = 0.0f;
            float abilityDamageFrost = 0.0f;
            SoundHelper.loopSound(livingEntity, SoundRegistry.AMBIENCE_WIND_LOOP.getId(), 20);
            MobEffectInstance mobEffectInstance = livingEntity.m_21124_((MobEffect)EffectRegistry.ELEMENTAL_VORTEX.get());
            if (mobEffectInstance instanceof SimplySwordsStatusEffectInstance) {
                SimplySwordsStatusEffectInstance statusEffect = (SimplySwordsStatusEffectInstance)mobEffectInstance;
                this.sourceEntity = statusEffect.getSourceEntity();
                this.additionalData = statusEffect.getAdditionalData();
            }
            if (livingEntity.f_19797_ % 10 == 0) {
                AABB box = HelperMethods.createBox((Entity)livingEntity, 1 + amplifier / 6);
                for (Entity entity : serverWorld.m_6249_((Entity)livingEntity, box, EntitySelector.f_20403_)) {
                    LivingEntity le;
                    if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, livingEntity) || this.additionalData == 0) continue;
                    DamageSource damageSource = livingEntity.m_269291_().m_269104_((Entity)le, (Entity)livingEntity);
                    damageSource = livingEntity.m_269291_().m_269104_((Entity)livingEntity, (Entity)this.sourceEntity);
                    float spellScalingModifier = Config.getFloat("vortexSpellScaling", "UniqueEffects", ConfigDefaultValues.vortexSpellScaling);
                    if (HelperMethods.commonSpellAttributeScaling(spellScalingModifier, (Entity)this.sourceEntity, "frost") > 1.0f) {
                        abilityDamageFrost = HelperMethods.commonSpellAttributeScaling(spellScalingModifier, (Entity)this.sourceEntity, "frost");
                    }
                    if (HelperMethods.commonSpellAttributeScaling(spellScalingModifier, (Entity)this.sourceEntity, "fire") > 1.0f) {
                        abilityDamageFire = HelperMethods.commonSpellAttributeScaling(spellScalingModifier, (Entity)this.sourceEntity, "fire");
                    }
                    le.f_19802_ = 0;
                    le.m_6469_(damageSource, 3.0f + (float)amplifier / 2.0f + (abilityDamageFire + abilityDamageFrost));
                }
            }
            if (livingEntity.f_19797_ % 40 == 0) {
                HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.m_20182_().m_82520_(0.0, (double)(livingEntity.m_20206_() / 3.0f), 0.0), (ParticleOptions)ParticleTypes.f_123756_, 0.5, 4);
                HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.m_20182_().m_82520_(0.0, (double)(livingEntity.m_20206_() / 2.0f), 0.0), (ParticleOptions)ParticleTypes.f_175821_, 1.0, 6);
                HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.m_20182_().m_82520_(0.0, (double)(livingEntity.m_20206_() / 2.0f), 0.0), (ParticleOptions)ParticleTypes.f_123757_, 1.5, 8);
            }
        }
        super.m_6742_(livingEntity, amplifier);
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributes, int amplifier) {
        SoundHelper.stopLoopingSound(entity, SoundRegistry.AMBIENCE_WIND_LOOP.getId());
        super.m_6386_(entity, attributes, amplifier);
    }

    @Override
    public boolean m_6584_(int pDuration, int pAmplifier) {
        return super.m_6584_(pDuration, pAmplifier);
    }
}

