/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute.attributes;

import com.simibubi.create.content.logistics.item.filter.attribute.AllItemAttributeTypes;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BookCopyAttribute
implements ItemAttribute {
    private int generation;

    public BookCopyAttribute(int generation) {
        this.generation = generation;
    }

    private static int extractGeneration(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && stack.m_41720_() instanceof WrittenBookItem) {
            return nbt.m_128451_("generation");
        }
        return -1;
    }

    @Override
    public boolean appliesTo(ItemStack itemStack, Level level) {
        return BookCopyAttribute.extractGeneration(itemStack) == this.generation;
    }

    @Override
    public String getTranslationKey() {
        return switch (this.generation) {
            case 0 -> "book_copy_original";
            case 1 -> "book_copy_first";
            case 2 -> "book_copy_second";
            default -> "book_copy_tattered";
        };
    }

    @Override
    public ItemAttributeType getType() {
        return AllItemAttributeTypes.BOOK_COPY;
    }

    @Override
    public void save(CompoundTag nbt) {
        nbt.m_128405_("generation", this.generation);
    }

    @Override
    public void load(CompoundTag nbt) {
        this.generation = nbt.m_128451_("generation");
    }

    public static class Type
    implements ItemAttributeType {
        @Override
        @NotNull
        public ItemAttribute createAttribute() {
            return new BookCopyAttribute(-1);
        }

        @Override
        public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
            ArrayList<ItemAttribute> list = new ArrayList<ItemAttribute>();
            int generation = BookCopyAttribute.extractGeneration(stack);
            if (generation >= 0) {
                list.add(new BookCopyAttribute(generation));
            }
            return list;
        }
    }
}

