/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.rewrites.chunk_serializer.common;

import com.ishland.c2me.rewrites.chunk_serializer.common.NbtWriter;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagVisitor;

public class NbtWriterVisitor
implements TagVisitor {
    private final NbtWriter writer;

    public NbtWriterVisitor(NbtWriter writer) {
        this.writer = writer;
    }

    public void m_142614_(StringTag element) {
        this.writer.putStringEntry(NbtWriter.getStringBytes(element.m_7916_()));
    }

    public void m_141946_(ByteTag element) {
        this.writer.putByteEntry(element.m_7063_());
    }

    public void m_142183_(ShortTag element) {
        this.writer.putShortEntry(element.m_7053_());
    }

    public void m_142045_(IntTag element) {
        this.writer.putIntEntry(element.m_7047_());
    }

    public void m_142046_(LongTag element) {
        this.writer.putLongEntry(element.m_7046_());
    }

    public void m_142181_(FloatTag element) {
        this.writer.putFloatEntry(element.m_7057_());
    }

    public void m_142121_(DoubleTag element) {
        this.writer.putDoubleEntry(element.m_7061_());
    }

    public void m_142154_(ByteArrayTag element) {
        this.writer.putByteArrayEntry(element.m_128227_());
    }

    public void m_142251_(IntArrayTag element) {
        this.writer.putIntArrayEntry(element.m_128648_());
    }

    public void m_142309_(LongArrayTag element) {
        this.writer.putLongArrayEntry(element.m_128851_());
    }

    public void m_142447_(ListTag element) {
        this.writer.startFixedListEntry(element.size(), element.m_7264_());
        for (Tag elementBase : element) {
            elementBase.m_142327_((TagVisitor)this);
        }
    }

    public void m_142303_(CompoundTag compound) {
        for (String name : compound.m_128431_()) {
            Tag element = compound.m_128423_(name);
            this.visit(name, element);
        }
        this.writer.finishCompound();
    }

    public void visitString(byte[] name, StringTag element) {
        this.writer.putString(name, element.m_7916_());
    }

    public void visitString(String name, StringTag element) {
        this.visitString(NbtWriter.getStringBytes(name), element);
    }

    public void visitByte(byte[] name, ByteTag element) {
        this.writer.putByte(name, element.m_7063_());
    }

    public void visitByte(String name, ByteTag element) {
        this.visitByte(NbtWriter.getStringBytes(name), element);
    }

    public void visitShort(byte[] name, ShortTag element) {
        this.writer.putShort(name, element.m_7053_());
    }

    public void visitShort(String name, ShortTag element) {
        this.visitShort(NbtWriter.getStringBytes(name), element);
    }

    public void visitInt(byte[] name, IntTag element) {
        this.writer.putInt(name, element.m_7047_());
    }

    public void visitInt(String name, IntTag element) {
        this.visitInt(NbtWriter.getStringBytes(name), element);
    }

    public void visitLong(byte[] name, LongTag element) {
        this.writer.putLong(name, element.m_7046_());
    }

    public void visitLong(String name, LongTag element) {
        this.visitLong(NbtWriter.getStringBytes(name), element);
    }

    public void visitFloat(byte[] name, FloatTag element) {
        this.writer.putFloat(name, element.m_7057_());
    }

    public void visitFloat(String name, FloatTag element) {
        this.visitFloat(NbtWriter.getStringBytes(name), element);
    }

    public void visitDouble(byte[] name, DoubleTag element) {
        this.writer.putDouble(name, element.m_7061_());
    }

    public void visitDouble(String name, DoubleTag element) {
        this.visitDouble(NbtWriter.getStringBytes(name), element);
    }

    public void visitByteArray(byte[] name, ByteArrayTag element) {
        this.writer.putByteArray(name, element.m_128227_());
    }

    public void visitByteArray(String name, ByteArrayTag element) {
        this.visitByteArray(NbtWriter.getStringBytes(name), element);
    }

    public void visitIntArray(byte[] name, IntArrayTag element) {
        this.writer.putIntArray(name, element.m_128648_());
    }

    public void visitIntArray(String name, IntArrayTag element) {
        this.visitIntArray(NbtWriter.getStringBytes(name), element);
    }

    public void visitLongArray(byte[] name, LongArrayTag element) {
        this.writer.putLongArray(name, element.m_128851_());
    }

    public void visitLongArray(String name, LongArrayTag element) {
        this.visitLongArray(NbtWriter.getStringBytes(name), element);
    }

    public void visitList(byte[] name, ListTag element) {
        this.writer.startFixedList(name, element.size(), element.m_7264_());
        for (Tag elementBase : element) {
            elementBase.m_142327_((TagVisitor)this);
        }
    }

    public void visitList(String name, ListTag element) {
        this.visitList(NbtWriter.getStringBytes(name), element);
    }

    public void visitCompound(byte[] name, CompoundTag compound) {
        this.writer.startCompound(name);
        for (String nameBase : compound.m_128431_()) {
            Tag element = compound.m_128423_(nameBase);
            this.visit(nameBase, element);
        }
        this.writer.finishCompound();
    }

    public void visitCompound(String name, CompoundTag compound) {
        this.visitCompound(NbtWriter.getStringBytes(name), compound);
    }

    public void visit(String nameBase, Tag element) {
        switch (element.m_7060_()) {
            case 8: {
                this.visitString(nameBase, (StringTag)element);
                break;
            }
            case 1: {
                this.visitByte(nameBase, (ByteTag)element);
                break;
            }
            case 2: {
                this.visitShort(nameBase, (ShortTag)element);
                break;
            }
            case 3: {
                this.visitInt(nameBase, (IntTag)element);
                break;
            }
            case 4: {
                this.visitLong(nameBase, (LongTag)element);
                break;
            }
            case 5: {
                this.visitFloat(nameBase, (FloatTag)element);
                break;
            }
            case 6: {
                this.visitDouble(nameBase, (DoubleTag)element);
                break;
            }
            case 7: {
                this.visitByteArray(nameBase, (ByteArrayTag)element);
                break;
            }
            case 11: {
                this.visitIntArray(nameBase, (IntArrayTag)element);
                break;
            }
            case 12: {
                this.visitLongArray(nameBase, (LongArrayTag)element);
                break;
            }
            case 9: {
                this.visitList(nameBase, (ListTag)element);
                break;
            }
            case 10: {
                this.visitCompound(nameBase, (CompoundTag)element);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown NbtElement type: " + element.m_7060_());
            }
        }
    }

    public void visit(byte[] nameBase, Tag element) {
        switch (element.m_7060_()) {
            case 8: {
                this.visitString(nameBase, (StringTag)element);
                break;
            }
            case 1: {
                this.visitByte(nameBase, (ByteTag)element);
                break;
            }
            case 2: {
                this.visitShort(nameBase, (ShortTag)element);
                break;
            }
            case 3: {
                this.visitInt(nameBase, (IntTag)element);
                break;
            }
            case 4: {
                this.visitLong(nameBase, (LongTag)element);
                break;
            }
            case 5: {
                this.visitFloat(nameBase, (FloatTag)element);
                break;
            }
            case 6: {
                this.visitDouble(nameBase, (DoubleTag)element);
                break;
            }
            case 7: {
                this.visitByteArray(nameBase, (ByteArrayTag)element);
                break;
            }
            case 11: {
                this.visitIntArray(nameBase, (IntArrayTag)element);
                break;
            }
            case 12: {
                this.visitLongArray(nameBase, (LongArrayTag)element);
                break;
            }
            case 9: {
                this.visitList(nameBase, (ListTag)element);
                break;
            }
            case 10: {
                this.visitCompound(nameBase, (CompoundTag)element);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown NbtElement type: " + element.m_7060_());
            }
        }
    }

    public void m_142384_(EndTag element) {
        throw new IllegalArgumentException("Cannot visit null element");
    }
}

