/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.rewrites.chunk_serializer.common;

import com.ishland.c2me.base.mixin.access.IBelowZeroRetrogen;
import com.ishland.c2me.base.mixin.access.IBlendingData;
import com.ishland.c2me.base.mixin.access.IChunkSection;
import com.ishland.c2me.base.mixin.access.IChunkTickScheduler;
import com.ishland.c2me.base.mixin.access.ISimpleTickScheduler;
import com.ishland.c2me.base.mixin.access.IState;
import com.ishland.c2me.base.mixin.access.IStructurePiece;
import com.ishland.c2me.base.mixin.access.IStructureStart;
import com.ishland.c2me.base.mixin.access.IUpgradeData;
import com.ishland.c2me.rewrites.chunk_serializer.common.ChunkStatusAccessor;
import com.ishland.c2me.rewrites.chunk_serializer.common.GenerationStepCarverAccessor;
import com.ishland.c2me.rewrites.chunk_serializer.common.HeightMapTypeAccessor;
import com.ishland.c2me.rewrites.chunk_serializer.common.NbtWriter;
import com.ishland.c2me.rewrites.chunk_serializer.common.utils.LithiumUtil;
import com.ishland.c2me.rewrites.chunk_serializer.common.utils.StarLightUtil;
import com.ishland.c2me.rewrites.chunk_serializer.mixin.IStarlightSaveState;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.stream.LongStream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Direction;
import net.minecraft.core.Direction8;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.ticks.SavedTick;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraft.world.ticks.SerializableTickContainer;
import net.minecraft.world.ticks.TickPriority;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class ChunkDataSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final byte[] STRING_DATA_VERSION = NbtWriter.getAsciiStringBytes("DataVersion");
    private static final byte[] STRING_X_POS = NbtWriter.getAsciiStringBytes("xPos");
    private static final byte[] STRING_Y_POS = NbtWriter.getAsciiStringBytes("yPos");
    private static final byte[] STRING_Z_POS = NbtWriter.getAsciiStringBytes("zPos");
    private static final byte[] STRING_LAST_UPDATE = NbtWriter.getAsciiStringBytes("LastUpdate");
    private static final byte[] STRING_INHABITED_TIME = NbtWriter.getAsciiStringBytes("InhabitedTime");
    private static final byte[] STRING_STATUS = NbtWriter.getAsciiStringBytes("Status");
    private static final byte[] STRING_BLENDING_DATA = NbtWriter.getAsciiStringBytes("blending_data");
    private static final byte[] STRING_BELOW_ZERO_RETROGEN = NbtWriter.getAsciiStringBytes("below_zero_retrogen");
    private static final byte[] STRING_UPGRADE_DATA = NbtWriter.getAsciiStringBytes("upgrade_data");
    private static final byte[] STRING_IS_LIGHT_ON = NbtWriter.getAsciiStringBytes("isLightOn");
    private static final byte[] STRING_BLOCK_ENTITIES = NbtWriter.getAsciiStringBytes("block_entities");
    private static final byte[] STRING_PALETTE = NbtWriter.getAsciiStringBytes("palette");
    private static final byte[] STRING_DATA = NbtWriter.getAsciiStringBytes("data");
    private static final byte[] STRING_SECTIONS = NbtWriter.getAsciiStringBytes("sections");
    private static final byte[] STRING_BLOCK_STATES = NbtWriter.getAsciiStringBytes("block_states");
    private static final byte[] STRING_BIOMES = NbtWriter.getAsciiStringBytes("biomes");
    private static final byte[] STRING_BLOCK_LIGHT = NbtWriter.getAsciiStringBytes("BlockLight");
    private static final byte[] STRING_SKY_LIGHT = NbtWriter.getAsciiStringBytes("SkyLight");
    private static final byte[] STRING_OLD_NOISE = NbtWriter.getAsciiStringBytes("old_noise");
    private static final byte[] STRING_HEIGHTS = NbtWriter.getAsciiStringBytes("heights");
    private static final byte[] STRING_MIN_SECTION = NbtWriter.getAsciiStringBytes("min_section");
    private static final byte[] STRING_MAX_SECTION = NbtWriter.getAsciiStringBytes("max_section");
    private static final byte[] STRING_TARGET_STATUS = NbtWriter.getAsciiStringBytes("target_status");
    private static final byte[] STRING_MISSING_BEDROCK = NbtWriter.getAsciiStringBytes("missing_bedrock");
    private static final byte[] STRING_INDICES = NbtWriter.getAsciiStringBytes("Indices");
    private static final byte[] STRING_SIDES = NbtWriter.getAsciiStringBytes("Sides");
    private static final byte[] STRING_ENTITIES = NbtWriter.getAsciiStringBytes("entities");
    private static final byte[] STRING_LIGHTS = NbtWriter.getAsciiStringBytes("Lights");
    private static final byte[] STRING_CARVING_MASKS = NbtWriter.getAsciiStringBytes("CarvingMasks");
    private static final byte[] STRING_HEIGHTMAPS = NbtWriter.getAsciiStringBytes("Heightmaps");
    private static final byte[] STRING_POST_PROCESSING = NbtWriter.getAsciiStringBytes("PostProcessing");
    private static final byte[] STRING_BLOCK_TICKS = NbtWriter.getAsciiStringBytes("block_ticks");
    private static final byte[] STRING_FLUID_TICKS = NbtWriter.getAsciiStringBytes("fluid_ticks");
    private static final byte[] STRING_STRUCTURES = NbtWriter.getAsciiStringBytes("structures");
    private static final byte[] STRING_STARTS = NbtWriter.getAsciiStringBytes("starts");
    private static final byte[] STRING_BIG_REFERENCES = NbtWriter.getAsciiStringBytes("References");
    private static final byte[] STRING_ID = NbtWriter.getAsciiStringBytes("id");
    private static final byte[] STRING_CHUNK_X = NbtWriter.getAsciiStringBytes("ChunkX");
    private static final byte[] STRING_CHUNK_Z = NbtWriter.getAsciiStringBytes("ChunkZ");
    private static final byte[] STRING_SMALL_REFERENCES = NbtWriter.getAsciiStringBytes("references");
    private static final byte[] STRING_CHILDREN = NbtWriter.getAsciiStringBytes("Children");
    private static final byte[] STRING_INVALID = NbtWriter.getAsciiStringBytes("INVALID");
    private static final byte[] STRING_BB = NbtWriter.getAsciiStringBytes("BB");
    private static final byte[] STRING_O = NbtWriter.getAsciiStringBytes("O");
    private static final byte[] STRING_GD = NbtWriter.getAsciiStringBytes("GD");
    private static final byte[] STRING_NAME = NbtWriter.getAsciiStringBytes("Name");
    private static final byte[] STRING_PROPERTIES = NbtWriter.getAsciiStringBytes("Properties");
    private static final byte[] STRING_CHAR_BIG_Y = NbtWriter.getAsciiStringBytes("Y");
    private static final byte[] STRING_CHAR_SMALL_I = NbtWriter.getAsciiStringBytes("i");
    private static final byte[] STRING_CHAR_SMALL_P = NbtWriter.getAsciiStringBytes("p");
    private static final byte[] STRING_CHAR_SMALL_T = NbtWriter.getAsciiStringBytes("t");
    private static final byte[] STRING_CHAR_SMALL_X = NbtWriter.getAsciiStringBytes("x");
    private static final byte[] STRING_CHAR_SMALL_Y = NbtWriter.getAsciiStringBytes("y");
    private static final byte[] STRING_CHAR_SMALL_Z = NbtWriter.getAsciiStringBytes("z");
    private static final byte[] STRING_C2ME = NbtWriter.getAsciiStringBytes("C2ME");
    private static final byte[] STRING_KROPPEB = NbtWriter.getAsciiStringBytes("Kroppeb was here :); Version: 0.3.0");
    private static final byte[] STRING_C2ME_MARK_A = NbtWriter.getAsciiStringBytes("C2ME::MarkA");
    private static final byte[] STRING_MARKER_FLUID_PROTO = NbtWriter.getAsciiStringBytes("fluid:proto");
    private static final byte[] STRING_MARKER_FLUID_FULL = NbtWriter.getAsciiStringBytes("fluid:full");
    private static final byte[] STRING_MARKER_FLUID_FALLBACK = NbtWriter.getAsciiStringBytes("fluid:fallback");
    private static final byte[] STRING_BLOCKLIGHT_STATE_TAG = NbtWriter.getAsciiStringBytes("starlight.blocklight_state");
    private static final byte[] STRING_SKYLIGHT_STATE_TAG = NbtWriter.getAsciiStringBytes("starlight.skylight_state");
    private static final byte[] STRING_STARLIGHT_VERSION_TAG = NbtWriter.getAsciiStringBytes("starlight.light_version");
    private static final int STARLIGHT_LIGHT_VERSION = 8;
    private static final boolean STARLIGHT = FabricLoader.getInstance().isModLoaded("starlight");

    public static void write(ServerLevel world, ChunkAccess chunk, NbtWriter writer) {
        UpgradeData upgradeData;
        BelowZeroRetrogen belowZeroRetrogen;
        ChunkPos chunkPos = chunk.m_7697_();
        writer.putString(STRING_C2ME, STRING_KROPPEB);
        writer.putInt(STRING_DATA_VERSION, SharedConstants.m_183709_().m_183476_().m_193006_());
        writer.putInt(STRING_X_POS, chunkPos.f_45578_);
        writer.putInt(STRING_Y_POS, chunk.m_151560_());
        writer.putInt(STRING_Z_POS, chunkPos.f_45579_);
        writer.putLong(STRING_LAST_UPDATE, world.m_46467_());
        writer.putLong(STRING_INHABITED_TIME, chunk.m_6319_());
        writer.putString(STRING_STATUS, ((ChunkStatusAccessor)chunk.m_6415_()).getIdBytes());
        BlendingData blendingData = chunk.m_183407_();
        if (blendingData != null) {
            writer.startCompound(STRING_BLENDING_DATA);
            ChunkDataSerializer.writeBlendingData(writer, (IBlendingData)blendingData);
            writer.finishCompound();
        }
        if ((belowZeroRetrogen = chunk.m_183376_()) != null) {
            writer.startCompound(STRING_BELOW_ZERO_RETROGEN);
            ChunkDataSerializer.writeBelowZeroRetrogen(writer, (IBelowZeroRetrogen)belowZeroRetrogen);
            writer.finishCompound();
        }
        if (!(upgradeData = chunk.m_7387_()).m_63331_()) {
            writer.startCompound(STRING_UPGRADE_DATA);
            ChunkDataSerializer.writeUpgradeData(writer, (IUpgradeData)upgradeData);
            writer.finishCompound();
        }
        LevelChunkSection[] chunkSections = chunk.m_7103_();
        ThreadedLevelLightEngine lightingProvider = world.m_7726_().m_7827_();
        Registry biomeRegistry = world.m_9598_().m_175515_(Registries.f_256952_);
        ChunkDataSerializer.checkLightFlag(chunk, writer, world);
        ChunkDataSerializer.writeSectionData(writer, chunk, chunkPos, (IChunkSection[])chunkSections, (LevelLightEngine)lightingProvider, (Registry<Biome>)biomeRegistry);
        long blockEntitiesStart = writer.startList(STRING_BLOCK_ENTITIES, (byte)10);
        int blockEntitiesCount = 0;
        for (BlockPos bl2 : chunk.m_5928_()) {
            CompoundTag chunkNibbleArray = chunk.m_8051_(bl2);
            if (chunkNibbleArray == null) continue;
            writer.putElementEntry((Tag)chunkNibbleArray);
            ++blockEntitiesCount;
        }
        writer.finishList(blockEntitiesStart, blockEntitiesCount);
        if (chunk.m_6415_().m_62494_() == ChunkStatus.ChunkType.PROTOCHUNK) {
            ProtoChunk j = (ProtoChunk)chunk;
            List entities = j.m_63293_();
            writer.startFixedList(STRING_ENTITIES, entities.size(), (byte)10);
            for (CompoundTag entity : entities) {
                writer.putElementEntry((Tag)entity);
            }
            writer.startCompound(STRING_CARVING_MASKS);
            for (GenerationStep.Carving carver : GenerationStep.Carving.values()) {
                CarvingMask carvingMask = j.m_183612_(carver);
                if (carvingMask == null) continue;
                writer.putLongArray(((GenerationStepCarverAccessor)carver).getNameBytes(), carvingMask.m_187584_());
            }
            writer.finishCompound();
        }
        ChunkDataSerializer.serializeTicks(writer, world, chunk.m_183568_());
        ShortList[] postProcessingLists = chunk.m_6720_();
        ChunkDataSerializer.putShortListArray(postProcessingLists, writer, STRING_POST_PROCESSING);
        writer.startCompound(STRING_HEIGHTMAPS);
        for (Map.Entry entry : chunk.m_6890_()) {
            if (!chunk.m_6415_().m_62500_().contains(entry.getKey())) continue;
            writer.putLongArray(((HeightMapTypeAccessor)entry.getKey()).getNameBytes(), ((Heightmap)entry.getValue()).m_64239_());
        }
        writer.finishCompound();
        ChunkDataSerializer.writeStructures(writer, StructurePieceSerializationContext.m_192770_((ServerLevel)world), chunkPos, chunk.m_6633_(), chunk.m_62769_());
    }

    private static void checkLightFlag(ChunkAccess chunk, NbtWriter writer, ServerLevel world) {
        if (STARLIGHT) {
            if (chunk.m_6332_()) {
                writer.putBoolean(STRING_IS_LIGHT_ON, false);
            }
        } else if (chunk.m_6332_()) {
            writer.putBoolean(STRING_IS_LIGHT_ON, true);
        }
    }

    private static void putShortListArray(ShortList[] data, NbtWriter writer, byte[] name) {
        writer.startFixedList(name, data.length, (byte)9);
        for (ShortList shortList : data) {
            if (shortList != null) {
                writer.startFixedListEntry(shortList.size(), (byte)2);
                for (Short short_ : shortList) {
                    writer.putShortEntry(short_);
                }
                continue;
            }
            writer.startFixedListEntry(0, (byte)0);
        }
    }

    private static void writeSectionData(NbtWriter writer, ChunkAccess chunk, ChunkPos chunkPos, IChunkSection[] chunkSections, LevelLightEngine lightingProvider, Registry<Biome> biomeRegistry) {
        if (STARLIGHT) {
            ChunkDataSerializer.writeSectionDataStarlight(writer, chunk, chunkPos, chunkSections, lightingProvider, biomeRegistry);
        } else {
            ChunkDataSerializer.writeSectionDataVanilla(writer, chunk, chunkPos, chunkSections, lightingProvider, biomeRegistry);
        }
    }

    private static void writeSectionDataVanilla(NbtWriter writer, ChunkAccess chunk, ChunkPos chunkPos, IChunkSection[] chunkSections, LevelLightEngine lightingProvider, Registry<Biome> biomeRegistry) {
        long sectionsStart = writer.startList(STRING_SECTIONS, (byte)10);
        int sectionCount = 0;
        for (int i = lightingProvider.m_164447_(); i < lightingProvider.m_164448_(); ++i) {
            int index = chunk.m_151566_(i);
            boolean bl2 = index >= 0 && index < chunkSections.length;
            DataLayer blockLight = lightingProvider.m_75814_(LightLayer.BLOCK).m_8079_(SectionPos.m_123196_((ChunkPos)chunkPos, (int)i));
            DataLayer skyLight = lightingProvider.m_75814_(LightLayer.SKY).m_8079_(SectionPos.m_123196_((ChunkPos)chunkPos, (int)i));
            if (!bl2 && blockLight == null && skyLight == null) continue;
            boolean hasInner = false;
            if (bl2) {
                hasInner = true;
                writer.compoundEntryStart();
                IChunkSection chunkSection = chunkSections[index];
                ChunkDataSerializer.writeBlockStates(writer, (PalettedContainer<BlockState>)chunkSection.getBlockStateContainer());
                ChunkDataSerializer.writeBiomes(writer, (PalettedContainerRO<Holder<Biome>>)chunkSection.getBiomeContainer(), biomeRegistry);
            }
            if (blockLight != null && !blockLight.m_62575_()) {
                if (!hasInner) {
                    writer.compoundEntryStart();
                    hasInner = true;
                }
                writer.putByteArray(STRING_BLOCK_LIGHT, blockLight.m_7877_());
            }
            if (skyLight != null && !skyLight.m_62575_()) {
                if (!hasInner) {
                    writer.compoundEntryStart();
                    hasInner = true;
                }
                writer.putByteArray(STRING_SKY_LIGHT, skyLight.m_7877_());
            }
            if (!hasInner) continue;
            writer.putByte(STRING_CHAR_BIG_Y, (byte)i);
            writer.finishCompound();
            ++sectionCount;
        }
        writer.finishList(sectionsStart, sectionCount);
    }

    private static void writeSectionDataStarlight(NbtWriter writer, ChunkAccess chunk, ChunkPos chunkPos, IChunkSection[] chunkSections, LevelLightEngine lightingProvider, Registry<Biome> biomeRegistry) {
        int minSection;
        boolean lit = chunk.m_6332_();
        ChunkStatus status = chunk.m_6415_();
        boolean shouldWrite = lit && status.m_62427_(ChunkStatus.f_62323_);
        Object[] blockNibbles = StarLightUtil.getBlockNibbles(chunk);
        Object[] skyNibbles = StarLightUtil.getSkyNibbles(chunk);
        long sectionsStart = writer.startList(STRING_SECTIONS, (byte)10);
        int sectionCount = 0;
        for (int i = minSection = lightingProvider.m_164447_(); i < lightingProvider.m_164448_(); ++i) {
            IStarlightSaveState skyNibble;
            int index = chunk.m_151566_(i);
            boolean bl2 = index >= 0 && index < chunkSections.length;
            IStarlightSaveState blockNibble = shouldWrite ? StarLightUtil.getSaveState(blockNibbles[i - minSection]) : null;
            IStarlightSaveState iStarlightSaveState = skyNibble = shouldWrite ? StarLightUtil.getSaveState(skyNibbles[i - minSection]) : null;
            if (!bl2 && blockNibble == null && skyNibble == null) continue;
            boolean hasInner = false;
            if (bl2) {
                hasInner = true;
                writer.compoundEntryStart();
                IChunkSection chunkSection = chunkSections[index];
                ChunkDataSerializer.writeBlockStates(writer, (PalettedContainer<BlockState>)chunkSection.getBlockStateContainer());
                ChunkDataSerializer.writeBiomes(writer, (PalettedContainerRO<Holder<Biome>>)chunkSection.getBiomeContainer(), biomeRegistry);
            }
            if (blockNibble != null) {
                if (blockNibble.getData() != null) {
                    writer.putByteArray(STRING_BLOCK_LIGHT, blockNibble.getData());
                }
                writer.putInt(STRING_BLOCKLIGHT_STATE_TAG, blockNibble.getState());
            }
            if (skyNibble != null) {
                if (skyNibble.getData() != null) {
                    writer.putByteArray(STRING_SKY_LIGHT, skyNibble.getData());
                }
                writer.putInt(STRING_SKYLIGHT_STATE_TAG, skyNibble.getState());
            }
            if (!hasInner) continue;
            writer.putByte(STRING_CHAR_BIG_Y, (byte)i);
            writer.finishCompound();
            ++sectionCount;
        }
        writer.finishList(sectionsStart, sectionCount);
        if (lit) {
            writer.putInt(STRING_STARLIGHT_VERSION_TAG, 8);
        }
    }

    private static void writeBlockStates(NbtWriter writer, PalettedContainer<BlockState> blockStateContainer) {
        writer.startCompound(STRING_BLOCK_STATES);
        PalettedContainerRO.PackedData data = blockStateContainer.m_188064_((IdMap)Block.f_49791_, PalettedContainer.Strategy.f_188137_);
        List paletteEntries = data.f_238184_();
        writer.startFixedList(STRING_PALETTE, paletteEntries.size(), (byte)10);
        for (BlockState paletteEntry : paletteEntries) {
            writer.compoundEntryStart();
            writer.putRegistry(STRING_NAME, BuiltInRegistries.f_256975_, paletteEntry.m_60734_());
            if (!paletteEntry.m_61148_().isEmpty()) {
                writer.putElement(STRING_PROPERTIES, (Tag)((IState)paletteEntry).getCodec().codec().encodeStart((DynamicOps)NbtOps.f_128958_, (Object)paletteEntry).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)));
            }
            writer.finishCompound();
        }
        Optional storage = data.f_238179_();
        if (storage.isPresent()) {
            writer.putLongArray(STRING_DATA, ((LongStream)storage.get()).toArray());
        }
        writer.finishCompound();
    }

    private static void writeBiomes(NbtWriter writer, PalettedContainerRO<Holder<Biome>> biomeContainer, Registry<Biome> biomeRegistry) {
        writer.startCompound(STRING_BIOMES);
        PalettedContainerRO.PackedData data = biomeContainer.m_188064_(biomeRegistry.m_206115_(), PalettedContainer.Strategy.f_188138_);
        List paletteEntries = data.f_238184_();
        writer.startFixedList(STRING_PALETTE, paletteEntries.size(), (byte)8);
        for (Holder paletteEntry : paletteEntries) {
            writer.putRegistryEntry(paletteEntry);
        }
        Optional storage = data.f_238179_();
        if (storage.isPresent()) {
            writer.putLongArray(STRING_DATA, ((LongStream)storage.get()).toArray());
        }
        writer.finishCompound();
    }

    private static void writeBlendingData(NbtWriter writer, IBlendingData blendingData) {
        double[] heights;
        writer.putInt(STRING_MIN_SECTION, blendingData.getOldHeightLimit().m_151560_());
        writer.putInt(STRING_MAX_SECTION, blendingData.getOldHeightLimit().m_151561_());
        for (double d : heights = blendingData.getSurfaceHeights()) {
            if (d == Double.MAX_VALUE) continue;
            writer.putDoubles(STRING_HEIGHTS, heights);
            return;
        }
        writer.startFixedList(STRING_HEIGHTS, 0, (byte)6);
    }

    private static void writeBelowZeroRetrogen(NbtWriter writer, IBelowZeroRetrogen belowZeroRetrogen) {
        writer.putRegistry(STRING_TARGET_STATUS, BuiltInRegistries.f_256940_, belowZeroRetrogen.invokeGetTargetStatus());
        BitSet missingBedrock = belowZeroRetrogen.getMissingBedrock();
        if (!missingBedrock.isEmpty()) {
            writer.putLongArray(STRING_MISSING_BEDROCK, missingBedrock.toLongArray());
        }
    }

    private static void writeUpgradeData(NbtWriter writer, IUpgradeData upgradeData) {
        int i;
        long indicesStart = -1L;
        int indicesCount = 0;
        int[][] centerIndicesToUpgrade = upgradeData.getCenterIndicesToUpgrade();
        for (i = 0; i < centerIndicesToUpgrade.length; ++i) {
            if (centerIndicesToUpgrade[i] == null || centerIndicesToUpgrade[i].length == 0) continue;
            String string = String.valueOf(i);
            if (indicesStart == -1L) {
                indicesStart = writer.startList(STRING_INDICES, (byte)11);
            }
            ++indicesCount;
            writer.putIntArray(NbtWriter.getAsciiStringBytes(string), centerIndicesToUpgrade[i]);
        }
        if (indicesStart != -1L) {
            writer.finishList(indicesStart, indicesCount);
        }
        i = 0;
        for (Direction8 eightWayDirection : upgradeData.getSidesToUpgrade()) {
            i |= 1 << eightWayDirection.ordinal();
        }
        writer.putByte(STRING_SIDES, (byte)i);
    }

    @Deprecated
    public static ListTag toNbt(ShortList[] lists) {
        ListTag nbtList = new ListTag();
        for (ShortList shortList : lists) {
            ListTag nbtList2 = new ListTag();
            if (shortList != null) {
                for (Short short_ : shortList) {
                    nbtList2.add((Object)ShortTag.m_129258_((short)short_));
                }
            }
            nbtList.add((Object)nbtList2);
        }
        return nbtList;
    }

    private static void serializeTicks(NbtWriter writer, ServerLevel world, ChunkAccess.TicksToSave tickSchedulers) {
        long time = world.m_6106_().m_6793_();
        ChunkDataSerializer.writeTicks(writer, time, tickSchedulers.f_187680_(), BuiltInRegistries.f_256975_, STRING_BLOCK_TICKS);
        ChunkDataSerializer.writeTicks(writer, time, tickSchedulers.f_187681_(), BuiltInRegistries.f_257020_, STRING_FLUID_TICKS);
    }

    private static <T> void writeTicks(NbtWriter writer, long time, SerializableTickContainer<T> scheduler, DefaultedRegistry<T> reg, byte[] key) {
        if (scheduler instanceof ISimpleTickScheduler) {
            ISimpleTickScheduler simpleTickSchedulerAccessor = (ISimpleTickScheduler)scheduler;
            List scheduledTicks = simpleTickSchedulerAccessor.getScheduledTicks();
            writer.startFixedList(key, scheduledTicks.size(), (byte)10);
            for (SavedTick scheduledTick : scheduledTicks) {
                ChunkDataSerializer.writeTick(writer, scheduledTick, reg);
            }
        } else if (scheduler instanceof IChunkTickScheduler) {
            IChunkTickScheduler chunkTickSchedulerAccess = (IChunkTickScheduler)scheduler;
            int size = 0;
            long list = writer.startList(key, (byte)10);
            @Nullable List scheduledTicks = chunkTickSchedulerAccess.getTicks();
            if (scheduledTicks != null) {
                size += scheduledTicks.size();
                for (SavedTick scheduledTick : scheduledTicks) {
                    ChunkDataSerializer.writeTick(writer, scheduledTick, reg);
                }
            }
            if (LithiumUtil.IS_LITHIUM_TICK_QUEUE_ACTIVE) {
                Collection tickQueues = LithiumUtil.getTickQueueCollection(chunkTickSchedulerAccess);
                for (Collection tickQueue : tickQueues) {
                    size += tickQueue.size();
                    for (ScheduledTick orderedTick : tickQueue) {
                        ChunkDataSerializer.writeOrderedTick(writer, orderedTick, time, reg);
                    }
                }
            } else {
                Queue tickQueue = chunkTickSchedulerAccess.getTickQueue();
                size += tickQueue.size();
                for (ScheduledTick orderedTick : tickQueue) {
                    ChunkDataSerializer.writeOrderedTick(writer, orderedTick, time, reg);
                }
            }
            writer.finishList(list, size);
        } else {
            writer.putElement(key, scheduler.m_183237_(time, block -> reg.m_7981_(block).toString()));
        }
    }

    private static <T> void writeOrderedTick(NbtWriter writer, ScheduledTick<T> orderedTick, long time, Registry<T> reg) {
        writer.compoundEntryStart();
        writer.putRegistry(STRING_CHAR_SMALL_I, reg, orderedTick.f_193376_());
        ChunkDataSerializer.writeGenericTickData(writer, orderedTick.f_193377_(), (int)(orderedTick.f_193378_() - time), orderedTick.f_193379_());
        writer.finishCompound();
    }

    private static <T> void writeTick(NbtWriter writer, SavedTick<T> scheduledTick, Registry<T> reg) {
        writer.compoundEntryStart();
        writer.putRegistry(STRING_CHAR_SMALL_I, reg, scheduledTick.f_193311_());
        ChunkDataSerializer.writeGenericTickData(writer, scheduledTick);
        writer.finishCompound();
    }

    private static void writeGenericTickData(NbtWriter writer, SavedTick<?> scheduledTick) {
        ChunkDataSerializer.writeGenericTickData(writer, scheduledTick.f_193312_(), scheduledTick.f_193313_(), scheduledTick.f_193314_());
    }

    private static void writeGenericTickData(NbtWriter writer, BlockPos pos, int delay, TickPriority priority) {
        writer.putInt(STRING_CHAR_SMALL_X, pos.m_123341_());
        writer.putInt(STRING_CHAR_SMALL_Y, pos.m_123342_());
        writer.putInt(STRING_CHAR_SMALL_Z, pos.m_123343_());
        writer.putInt(STRING_CHAR_SMALL_T, delay);
        writer.putInt(STRING_CHAR_SMALL_P, priority.m_193445_());
    }

    private static void writeStructures(NbtWriter writer, StructurePieceSerializationContext context, ChunkPos pos, Map<Structure, StructureStart> starts, Map<Structure, LongSet> references) {
        writer.startCompound(STRING_STRUCTURES);
        writer.startCompound(STRING_STARTS);
        Registry configuredStructureFeatureRegistry = context.f_192763_().m_175515_(Registries.f_256944_);
        for (Map.Entry<Structure, StructureStart> entry : starts.entrySet()) {
            writer.startCompound(NbtWriter.getNameBytesFromRegistry(configuredStructureFeatureRegistry, entry.getKey()));
            IStructureStart value = (IStructureStart)ChunkDataSerializer.cast(entry.getValue());
            ChunkDataSerializer.writeStructureStart(writer, value, context, pos);
            writer.finishCompound();
        }
        writer.finishCompound();
        writer.startCompound(STRING_BIG_REFERENCES);
        for (Map.Entry<Structure, StructureStart> entry : references.entrySet()) {
            if (((LongSet)entry.getValue()).isEmpty()) continue;
            writer.putLongArray(NbtWriter.getNameBytesFromRegistry(configuredStructureFeatureRegistry, entry.getKey()), (LongCollection)entry.getValue());
        }
        writer.finishCompound();
        writer.finishCompound();
    }

    private static void writeStructureStart(NbtWriter writer, IStructureStart structureStart, StructurePieceSerializationContext context, ChunkPos pos) {
        PiecesContainer children = structureStart.getChildren();
        if (children.m_192748_()) {
            writer.putString(STRING_ID, STRING_INVALID);
            return;
        }
        writer.putRegistry(STRING_ID, context.f_192763_().m_175515_(Registries.f_256944_), structureStart.getStructure());
        writer.putInt(STRING_CHUNK_X, pos.f_45578_);
        writer.putInt(STRING_CHUNK_Z, pos.f_45579_);
        writer.putInt(STRING_SMALL_REFERENCES, structureStart.getReferences());
        writer.startFixedList(STRING_CHILDREN, children.f_192741_().size(), (byte)10);
        for (StructurePiece piece : children.f_192741_()) {
            writer.putElementEntry((Tag)piece.m_192644_(context));
        }
    }

    private static void writeStructurePiece(NbtWriter writer, IStructurePiece structurePiece, StructurePieceSerializationContext context) {
        Direction direction;
        writer.compoundEntryStart();
        writer.putRegistry(STRING_ID, BuiltInRegistries.f_257014_, structurePiece.getType());
        Optional optional = BoundingBox.f_162354_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)structurePiece.getBoundingBox()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0));
        if (optional.isPresent()) {
            writer.putElement(STRING_BB, (Tag)optional.get());
        }
        writer.putInt(STRING_O, (direction = structurePiece.getFacing()) == null ? -1 : direction.m_122416_());
        writer.putInt(STRING_GD, structurePiece.getChainLength());
        writer.finishCompound();
    }

    @Contract(value="null -> null; !null -> !null")
    private static <T> T cast(Object entry) {
        return (T)entry;
    }
}

