/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.extragore.util;

import net.minecraft.world.entity.Entity;

public class EntityUtil {
    public static SizeInfo getSizeInfo(Entity entity) {
        float width = entity.m_20205_();
        float height = entity.m_20206_();
        float averageSize = (width + height) / 2.0f;
        return SizeInfo.calculateSizeInfo(averageSize);
    }

    public record SizeInfo(SizeCategory category, float excess) {
        public static SizeInfo calculateSizeInfo(float averageSize) {
            if (averageSize < 1.0f) {
                return new SizeInfo(SizeCategory.SMALL, 1.0f - averageSize);
            }
            if (averageSize > 2.0f) {
                return new SizeInfo(SizeCategory.LARGE, averageSize - 2.0f);
            }
            return new SizeInfo(SizeCategory.NORMAL, 0.0f);
        }
    }

    public static enum SizeCategory {
        SMALL,
        NORMAL,
        LARGE;

    }

    public static enum CollisionMode {
        BOUNCE,
        STUCK,
        MAGIC,
        NONE;

    }

    public static enum StateMode {
        LIQUID,
        SOLID;

    }

    public static enum WeightMode {
        LIGHT,
        HEAVY;

    }
}

