/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.extragore.packet;

import com.eruannie_9.extragore.particle.ModFactories;
import com.eruannie_9.extragore.particle.ModParticles;
import com.eruannie_9.extragore.util.EntityUtil;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class BloodDataPacket {
    private final double x;
    private final double y;
    private final double z;
    private final double dx;
    private final double dy;
    private final double dz;
    private final int color;
    private final float scale;
    private final int particleVariant;
    private final EntityUtil.CollisionMode controlMode;
    private final EntityUtil.WeightMode weightMode;
    private final EntityUtil.StateMode stateMode;

    public BloodDataPacket(double x, double y, double z, double dx, double dy, double dz, int color, float scale, int particleVariant, EntityUtil.CollisionMode controlMode, EntityUtil.WeightMode weightMode, EntityUtil.StateMode stateMode) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.color = color;
        this.scale = scale;
        this.particleVariant = particleVariant;
        this.controlMode = controlMode;
        this.weightMode = weightMode;
        this.stateMode = stateMode;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
        buffer.writeDouble(this.dx);
        buffer.writeDouble(this.dy);
        buffer.writeDouble(this.dz);
        buffer.writeInt(this.color);
        buffer.writeFloat(this.scale);
        buffer.writeInt(this.particleVariant);
        buffer.writeInt(this.controlMode.ordinal());
        buffer.writeInt(this.weightMode.ordinal());
        buffer.writeInt(this.stateMode.ordinal());
    }

    public static BloodDataPacket decode(FriendlyByteBuf buffer) {
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        double dx = buffer.readDouble();
        double dy = buffer.readDouble();
        double dz = buffer.readDouble();
        int color = buffer.readInt();
        float scale = buffer.readFloat();
        int particleVariant = buffer.readInt();
        EntityUtil.CollisionMode controlMode = EntityUtil.CollisionMode.values()[buffer.readInt()];
        EntityUtil.WeightMode weightMode = EntityUtil.WeightMode.values()[buffer.readInt()];
        EntityUtil.StateMode stateMode = EntityUtil.StateMode.values()[buffer.readInt()];
        return new BloodDataPacket(x, y, z, dx, dy, dz, color, scale, particleVariant, controlMode, weightMode, stateMode);
    }

    public static void handle(BloodDataPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null) {
                ModFactories.particleScaleThreadLocal.set(Float.valueOf(packet.scale));
                ModFactories.particleColorThreadLocal.set(new Color(packet.color));
                ModFactories.particleCollisionModeThreadLocal.set(packet.controlMode);
                ModFactories.particleWeightModeThreadLocal.set(packet.weightMode);
                ModFactories.particleStateModeThreadLocal.set(packet.stateMode);
                ParticleOptions options = packet.particleVariant == 1 ? (ParticleOptions)ModParticles.BLOOD_PARTICLES_V1.get() : (ParticleOptions)ModParticles.BLOOD_PARTICLES_V2.get();
                level.m_7106_(options, packet.x, packet.y, packet.z, packet.dx, packet.dy, packet.dz);
            }
            ModFactories.particleScaleThreadLocal.remove();
            ModFactories.particleColorThreadLocal.remove();
            ModFactories.particleCollisionModeThreadLocal.remove();
            ModFactories.particleWeightModeThreadLocal.remove();
            ModFactories.particleStateModeThreadLocal.remove();
        });
        ctx.get().setPacketHandled(true);
    }
}

