/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.extragore;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.eruannie_9.extragore.util.EntityUtil;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public class ParticleConfiguration {
    private static final Map<String, EntityUtil.CollisionMode> controlModeMap = new HashMap<String, EntityUtil.CollisionMode>();
    private static final Map<String, EntityUtil.WeightMode> weightModeMap = new HashMap<String, EntityUtil.WeightMode>();
    private static final Map<String, EntityUtil.StateMode> stateModeMap = new HashMap<String, EntityUtil.StateMode>();
    private static final Map<String, Color> entityColorMap = new HashMap<String, Color>();
    private static final String CONFIG_FILE_NAME = "extragore-property.toml";

    public static void initialize() {
        Path configFile = ParticleConfiguration.getConfigFilePath();
        ParticleConfiguration.processTomlConfig(configFile);
        ParticleConfiguration.updateRedColorGroup();
    }

    private static Path getConfigFilePath() {
        Path configPath = Paths.get(FMLPaths.CONFIGDIR.get().toString(), CONFIG_FILE_NAME);
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            if (Files.notExists(configPath, new LinkOption[0])) {
                ParticleConfiguration.createDefaultConfigFile(configPath);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return configPath;
    }

    private static void processTomlConfig(Path configFile) {
        try {
            FileConfig config = FileConfig.of((File)configFile.toFile(), (ConfigFormat)TomlFormat.instance());
            config.load();
            config.entrySet().stream().filter(entry -> entry.getValue() instanceof CommentedConfig).forEach(entry -> {
                String groupName = entry.getKey();
                CommentedConfig groupConfig = (CommentedConfig)entry.getValue();
                if (ParticleConfiguration.isValidGroup(groupConfig)) {
                    String color = (String)groupConfig.getOrElse("color", (Object)"");
                    List entities = (List)groupConfig.getOrElse("entities", Collections.emptyList());
                    String behavior = (String)groupConfig.getOrElse("behavior", (Object)"STUCK");
                    EntityUtil.CollisionMode collisionMode = ParticleConfiguration.determineMode(behavior);
                    String weight = (String)groupConfig.getOrElse("weight", (Object)"LIGHT");
                    EntityUtil.WeightMode weightMode = ParticleConfiguration.determineWeightMode(weight);
                    String state = (String)groupConfig.getOrElse("state", (Object)"LIQUID");
                    EntityUtil.StateMode stateMode = ParticleConfiguration.determineStateMode(state);
                    ParticleConfiguration.processTomlGroup(color, entities, collisionMode, weightMode, stateMode);
                } else {
                    System.out.println("Skipping invalid group: " + groupName);
                }
            });
            config.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean isValidGroup(CommentedConfig groupConfig) {
        return groupConfig.contains("color") && groupConfig.contains("entities") && groupConfig.get("entities") instanceof List && !((List)groupConfig.get("entities")).isEmpty() && groupConfig.contains("behavior") && groupConfig.contains("weight") && groupConfig.contains("state");
    }

    private static <T extends Enum<T>> T determineEnumValue(Class<T> enumType, String value, T defaultValue) {
        try {
            return Enum.valueOf(enumType, value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            System.out.println("Invalid value: " + value + ", defaulting to " + defaultValue);
            return defaultValue;
        }
    }

    private static EntityUtil.CollisionMode determineMode(String behavior) {
        return ParticleConfiguration.determineEnumValue(EntityUtil.CollisionMode.class, behavior, EntityUtil.CollisionMode.STUCK);
    }

    private static EntityUtil.WeightMode determineWeightMode(String weight) {
        return ParticleConfiguration.determineEnumValue(EntityUtil.WeightMode.class, weight, EntityUtil.WeightMode.LIGHT);
    }

    private static EntityUtil.StateMode determineStateMode(String state) {
        return ParticleConfiguration.determineEnumValue(EntityUtil.StateMode.class, state, EntityUtil.StateMode.LIQUID);
    }

    private static void processTomlGroup(String color, List<String> entities, EntityUtil.CollisionMode collision, EntityUtil.WeightMode weight, EntityUtil.StateMode state) {
        Optional.ofNullable(ParticleConfiguration.parseColor(color)).ifPresent(groupColor -> entities.stream().map(String::trim).map(entityId -> entityId.replaceAll("\\[|\\]|\"", "")).forEach(entityId -> {
            entityColorMap.put((String)entityId, (Color)groupColor);
            controlModeMap.put((String)entityId, collision);
            weightModeMap.put((String)entityId, weight);
            stateModeMap.put((String)entityId, state);
        }));
    }

    private static void createDefaultConfigFile(Path configFile) {
        String defaultConfig = "# ExtraGore Particle Group Configuration\n# ------------------------------------------------------\n# This file enables the creation of custom blood particle properties for various entities.\n# Begin by uniquely naming each property group to effectively manage different settings.\n\n# Particle Behavior Options:\n# - Bounce: The particle will bounce off surfaces like a solid object.\n# - Stick: The particle will stick to walls and other surfaces.\n# - Magic: Some particles will fall to the ground while the majority will fly up to the sky.\n# - None: The particle won't have any special effects.\n\n# Particle Weight Options:\n# - Heavy: The particle will sink to the bottom when it's underwater.\n# - Light: The particle will float up to the top of the water.\n\n# Particle State Options:\n# - Liquid: The particle will get larger during its lifetime.\n# - Solid: The particle will remain the same size all the time.\n\n# Color Settings:\n# Set an RGB color value to visually distinguish particles for various entities.\n\n# How to Use:\n# 1. Define a group with a name, including behavior, weight, state, color and entity values.\n# 2. Example:\n#    [\"Color Group Name\"]\n#    behavior = Choose from \"Stuck\", \"Bounce\" or \"None\"\n#    weight = Choose from \"Heavy\" or \"Light\"\n#    state = Choose from \"Liquid\" or \"Solid\"\n#    color = \"R,G,B\"\n#    entities = [\"entityID1\", \"entityID2\"]\n# 3. You can modify or delete any predefined groups, except for the red group. The red group is non editable and serves only to show you unused entities which are compatible with different color groups.\n# 4. Add your custom color groups under an already predefined group, except for the red one.\n# 5. Ensure each color group has a unique name and is properly structured.\n\n# Note: Incorrectly formatted lines or unrecognized entity IDs will be ignored.\n# ------------------------------------------------------\n\n[\"Violet Group\"]\nbehavior = \"Magic\"\nweight = \"Light\"\nstate = \"Liquid\"\ncolor = \"128,0,128\"\nentities = [\"minecraft:enderman\", \"minecraft:endermite\", \"minecraft:phantom\", \"minecraft:shulker\", \"minecraft:silverfish\", \"minecraft:warden\", \"minecraft:ender_dragon\"]\n\n[\"White Group\"]\nbehavior = \"Bounce\"\nweight = \"Heavy\"\nstate = \"Solid\"\ncolor = \"255,255,255\"\nentities = [\"minecraft:skeleton\", \"minecraft:ghast\", \"minecraft:iron_golem\", \"minecraft:skeleton_horse\", \"minecraft:snow_golem\", \"minecraft:stray\", \"minecraft:vex\", \"minecraft:wither_skeleton\", \"minecraft:allay\", \"minecraft:wither\"]\n\n[\"Green Group\"]\nbehavior = \"Stuck\"\nweight = \"Light\"\nstate = \"Liquid\"\ncolor = \"0,255,0\"\nentities = [\"minecraft:cave_spider\", \"minecraft:creeper\", \"minecraft:slime\", \"minecraft:spider\", \"minecraft:witch\"]\n\n[\"Yellow Group\"]\nbehavior = \"Bounce\"\nweight = \"Heavy\"\nstate = \"Solid\"\ncolor = \"255,255,0\"\nentities = [\"minecraft:blaze\", \"minecraft:magma_cube\", \"minecraft:strider\"]\n\n[\"Blue Group\"]\nbehavior = \"None\"\nweight = \"Light\"\nstate = \"Liquid\"\ncolor = \"0,0,255\"\nentities = [\"minecraft:squid\", \"minecraft:elder_guardian\", \"minecraft:guardian\", \"minecraft:glow_squid\"]\n\n";
        try {
            Files.write(configFile, defaultConfig.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Color parseColor(String colorStr) {
        try {
            int[] rgb = Stream.of(colorStr.split(",")).mapToInt(Integer::parseInt).toArray();
            return rgb.length == 3 ? new Color(rgb[0], rgb[1], rgb[2]) : null;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void updateRedColorGroup() {
        Set<String> allEntityIds = ParticleConfiguration.getAllEntitiesFromRegistry();
        HashSet<String> assignedEntities = new HashSet<String>();
        Path configFile = ParticleConfiguration.getConfigFilePath();
        try {
            List<String> lines = Files.readAllLines(configFile);
            ArrayList<String> newLines = new ArrayList<String>();
            boolean inRedGroup = false;
            for (String line : lines) {
                String[] entities;
                String trimmedLine = line.trim();
                if (trimmedLine.startsWith("# Auto generated red color group")) {
                    inRedGroup = true;
                    continue;
                }
                if (inRedGroup && trimmedLine.endsWith("]")) {
                    inRedGroup = false;
                    continue;
                }
                if (inRedGroup) continue;
                newLines.add(line);
                if (!line.contains("entities =")) continue;
                String entityList = line.substring(line.indexOf(91) + 1, line.indexOf(93));
                for (String entity : entities = entityList.replaceAll("\"", "").split(",")) {
                    assignedEntities.add(entity.trim());
                }
            }
            if (!inRedGroup) {
                newLines.add("# Auto generated red color group - do not edit. Use this as reference for unused entity IDs.");
                newLines.add("\"255,0,0\" = [");
                allEntityIds.stream().filter(id -> !assignedEntities.contains(id)).filter(id -> {
                    EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(id));
                    return entityType != null && ParticleConfiguration.isEntityInRedGroup(entityType);
                }).forEach(id -> newLines.add("    \"" + id + "\","));
                if (!((String)newLines.get(newLines.size() - 1)).endsWith("[")) {
                    String lastLine = (String)newLines.get(newLines.size() - 1);
                    newLines.set(newLines.size() - 1, lastLine.substring(0, lastLine.length() - 1));
                }
                newLines.add("]");
            }
            Files.write(configFile, newLines, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean isEntityInRedGroup(EntityType<?> entityType) {
        MobCategory classification = entityType.m_20674_();
        return classification == MobCategory.CREATURE || classification == MobCategory.MONSTER || classification == MobCategory.AXOLOTLS || classification == MobCategory.WATER_CREATURE || classification == MobCategory.WATER_AMBIENT || classification == MobCategory.UNDERGROUND_WATER_CREATURE || classification == MobCategory.AMBIENT;
    }

    private static Set<String> getAllEntitiesFromRegistry() {
        return ForgeRegistries.ENTITY_TYPES.getKeys().stream().map(ResourceLocation::toString).collect(Collectors.toSet());
    }

    public static Color getColorForEntity(LivingEntity entity) {
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        return Optional.ofNullable(entityId).map(ResourceLocation::toString).map(id -> entityColorMap.getOrDefault(id, new Color(255, 0, 0))).orElse(new Color(255, 0, 0));
    }

    public static EntityUtil.CollisionMode getControlModeForEntity(LivingEntity entity) {
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        return Optional.ofNullable(entityId).map(ResourceLocation::toString).map(id -> controlModeMap.getOrDefault(id, EntityUtil.CollisionMode.STUCK)).orElse(EntityUtil.CollisionMode.STUCK);
    }

    public static EntityUtil.WeightMode getWeightModeForEntity(LivingEntity entity) {
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        return Optional.ofNullable(entityId).map(ResourceLocation::toString).map(id -> weightModeMap.getOrDefault(id, EntityUtil.WeightMode.LIGHT)).orElse(EntityUtil.WeightMode.LIGHT);
    }

    public static EntityUtil.StateMode getStateModeForEntity(LivingEntity entity) {
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        return Optional.ofNullable(entityId).map(ResourceLocation::toString).map(id -> stateModeMap.getOrDefault(id, EntityUtil.StateMode.LIQUID)).orElse(EntityUtil.StateMode.LIQUID);
    }
}

