/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.world.level.block;

import fuzs.enchantinginfuser.EnchantingInfuser;
import fuzs.enchantinginfuser.api.EnchantingInfuserAPI;
import fuzs.enchantinginfuser.config.ServerConfig;
import fuzs.enchantinginfuser.init.ModRegistry;
import fuzs.enchantinginfuser.util.ChiseledBookshelfHelper;
import fuzs.enchantinginfuser.world.inventory.InfuserMenu;
import fuzs.enchantinginfuser.world.level.block.entity.InfuserBlockEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.EnchantmentTableBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import org.jetbrains.annotations.Nullable;

public class InfuserBlock
extends EnchantmentTableBlock {
    private static final Component CHOOSE_TOOLTIP = Component.m_237115_((String)"block.enchantinginfuser.description.choose");
    private static final Component CHOOSE_AND_MODIFY_TOOLTIP = Component.m_237115_((String)"block.enchantinginfuser.description.chooseAndModify");
    private static final Component REPAIR_TOOLTIP = Component.m_237115_((String)"block.enchantinginfuser.description.repair");
    private final InfuserType type;

    public InfuserBlock(InfuserType type, BlockBehaviour.Properties p_52953_) {
        super(p_52953_);
        this.type = type;
    }

    public static boolean m_207909_(Level level, BlockPos pos, BlockPos offset) {
        if (EnchantingInfuserAPI.getEnchantStatsProvider().getEnchantPowerBonus(level.m_8055_(pos.m_121955_((Vec3i)offset)), level, pos.m_121955_((Vec3i)offset)) == 0.0f && ChiseledBookshelfHelper.findValidBooks(level, pos, offset) == 0) {
            return false;
        }
        BlockPos inBetweenPos = pos.m_7918_(offset.m_123341_() / 2, offset.m_123342_(), offset.m_123343_() / 2);
        return level.m_8055_(inBetweenPos).m_60812_((BlockGetter)level, inBetweenPos) != Shapes.m_83144_();
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)ModRegistry.INFUSER_BLOCK_ENTITY_TYPE.get()).m_155264_(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.f_46443_ ? InfuserBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModRegistry.INFUSER_BLOCK_ENTITY_TYPE.get()), EnchantmentTableBlockEntity::m_155503_) : null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof InfuserBlockEntity) {
            InfuserBlockEntity blockEntity2 = (InfuserBlockEntity)blockEntity;
            if (!level.f_46443_) {
                player.m_5893_(state.m_60750_(level, pos));
                player.f_36096_.m_6199_((Container)blockEntity2);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public MenuProvider m_7246_(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof InfuserBlockEntity) {
            InfuserBlockEntity blockentity = (InfuserBlockEntity)blockEntity;
            Component component = blockentity.m_5446_();
            return new SimpleMenuProvider((p_52959_, p_52960_, p_52961_) -> {
                if (blockentity.canOpen(p_52961_)) {
                    return InfuserMenu.create(this.type, p_52959_, p_52960_, (Container)blockentity, ContainerLevelAccess.m_39289_((Level)pLevel, (BlockPos)pPos));
                }
                return null;
            }, component);
        }
        return null;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.m_214162_(state, level, pos, random);
        for (BlockPos blockpos : f_207902_) {
            if (random.m_188503_(16) != 0 || !InfuserBlock.m_207909_(level, pos, blockpos)) continue;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123809_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 2.0, (double)pos.m_123343_() + 0.5, (double)((float)blockpos.m_123341_() + random.m_188501_()) - 0.5, (double)((float)blockpos.m_123342_() - random.m_188501_() - 1.0f), (double)((float)blockpos.m_123343_() + random.m_188501_()) - 0.5);
        }
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = worldIn.m_7702_(pos)) instanceof InfuserBlockEntity) {
            InfuserBlockEntity blockEntity2 = (InfuserBlockEntity)blockEntity;
            Containers.m_19002_((Level)worldIn, (BlockPos)pos, (Container)blockEntity2);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter blockGetter, List<Component> list, TooltipFlag tooltipFlag) {
        if (!EnchantingInfuser.CONFIG.getHolder(ServerConfig.class).isAvailable()) {
            return;
        }
        Component component = this.type.config().allowModifyingEnchantments == ServerConfig.ModifiableItems.UNENCHANTED ? CHOOSE_TOOLTIP : CHOOSE_AND_MODIFY_TOOLTIP;
        MutableComponent mutableComponent = Component.m_237119_().m_7220_(component).m_130940_(ChatFormatting.GRAY);
        if (this.type.config().allowRepairing.isActive()) {
            mutableComponent = mutableComponent.m_130946_(" ").m_7220_(REPAIR_TOOLTIP);
        }
        list.add((Component)mutableComponent);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        InfuserBlockEntity blockEntity;
        BlockEntity blockEntity2 = worldIn.m_7702_(pos);
        if (blockEntity2 instanceof InfuserBlockEntity && !(blockEntity = (InfuserBlockEntity)blockEntity2).m_8020_(0).m_41619_()) {
            return 15;
        }
        return 0;
    }

    public static enum InfuserType {
        NORMAL,
        ADVANCED;


        public MenuType<?> menuType() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NORMAL -> (MenuType)ModRegistry.INFUSING_MENU_TYPE.get();
                case ADVANCED -> (MenuType)ModRegistry.ADVANCED_INFUSING_MENU_TYPE.get();
            };
        }

        public ServerConfig.InfuserConfig config() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NORMAL -> ((ServerConfig)EnchantingInfuser.CONFIG.get(ServerConfig.class)).normalInfuser;
                case ADVANCED -> ((ServerConfig)EnchantingInfuser.CONFIG.get(ServerConfig.class)).advancedInfuser;
            };
        }
    }
}

