/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.client.gui.screens.inventory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import fuzs.enchantinginfuser.EnchantingInfuser;
import fuzs.enchantinginfuser.api.EnchantingInfuserAPI;
import fuzs.enchantinginfuser.client.gui.components.IconButton;
import fuzs.enchantinginfuser.network.client.C2SAddEnchantLevelMessage;
import fuzs.enchantinginfuser.util.EnchantmentUtil;
import fuzs.enchantinginfuser.world.inventory.InfuserMenu;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.EnchantmentNames;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class InfuserScreen
extends AbstractContainerScreen<InfuserMenu> {
    public static final String CURRENT_ENCHANTING_POWER_TRANSLATION_KEY = "gui.enchantinginfuser.tooltip.current_enchanting_power";
    public static final Component ENCHANTING_POWER_COMPONENT = Component.m_237115_((String)(ModLoaderEnvironment.INSTANCE.isModLoaded("apotheosis") ? "gui.apotheosis.enchant.eterna" : "gui.enchantinginfuser.tooltip.enchanting_power"));
    private static final ResourceLocation INFUSER_LOCATION = new ResourceLocation("enchantinginfuser", "textures/gui/container/enchanting_infuser.png");
    private static final int BUTTONS_OFFSET_X = 7;
    private static final int ENCHANT_BUTTON_OFFSET_Y = 44;
    private static final int ENCHANT_ONLY_BUTTON_OFFSET_Y = 55;
    private static final int REPAIR_BUTTON_OFFSET_Y = 66;
    private final int enchantmentSeed = new Random().nextInt();
    private boolean insufficientPower;
    private float scrollOffs;
    private boolean scrolling;
    private EditBox searchBox;
    private ScrollingList scrollingList;
    private boolean ignoreTextInput;
    private Button enchantButton;
    private Button repairButton;

    public InfuserScreen(InfuserMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 220;
        this.f_97727_ = 185;
        this.f_97730_ = 30;
        this.f_97731_ = this.f_97727_ - 94;
    }

    public void m_181908_() {
        super.m_181908_();
        this.searchBox.m_94120_();
        this.updateButtons();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.searchBox = new EditBox(this.f_96547_, this.f_97735_ + 67, this.f_97736_ + 6, 116, 9, (Component)Component.m_237115_((String)"itemGroup.search")){

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (this.m_94213_() && button == 1) {
                    this.m_94144_("");
                    InfuserScreen.this.refreshSearchResults();
                }
                return super.m_6375_(mouseX, mouseY, button);
            }
        };
        this.searchBox.m_94199_(50);
        this.searchBox.m_94182_(false);
        this.searchBox.m_94202_(0xFFFFFF);
        this.m_7787_((GuiEventListener)this.searchBox);
        this.scrollingList = new ScrollingList(this.f_97735_ + 29, this.f_97736_ + 17, 162, 18, 4);
        this.m_7787_((GuiEventListener)this.scrollingList);
        this.enchantButton = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ + 7, this.f_97736_ + (((InfuserMenu)this.f_97732_).config.allowRepairing.isActive() ? 44 : 55), 18, 18, 126, 185, INFUSER_LOCATION, button -> {
            if (((InfuserMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, 0)) {
                this.f_96541_.f_91072_.m_105208_(((InfuserMenu)this.f_97732_).f_38840_, 0);
            }
            this.searchBox.m_94144_("");
        }));
        if (((InfuserMenu)this.f_97732_).config.allowRepairing.isActive()) {
            this.repairButton = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ + 7, this.f_97736_ + 66, 18, 18, 144, 185, INFUSER_LOCATION, button -> {
                if (((InfuserMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, 1)) {
                    this.f_96541_.f_91072_.m_105208_(((InfuserMenu)this.f_97732_).f_38840_, 1);
                }
            }));
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.enchantButton.f_93623_ = ((InfuserMenu)this.f_97732_).canEnchant((Player)this.f_96541_.f_91074_);
        if (this.repairButton != null) {
            this.repairButton.f_93623_ = ((InfuserMenu)this.f_97732_).canRepair((Player)this.f_96541_.f_91074_);
        }
    }

    public void m_6574_(Minecraft pMinecraft, int pWidth, int pHeight) {
        String s = this.searchBox.m_94155_();
        super.m_6574_(pMinecraft, pWidth, pHeight);
        this.searchBox.m_94144_(s);
        this.refreshSearchResults();
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        if (this.ignoreTextInput) {
            return false;
        }
        String s = this.searchBox.m_94155_();
        if (this.searchBox.m_5534_(pCodePoint, pModifiers)) {
            if (!Objects.equals(s, this.searchBox.m_94155_())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return false;
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        this.ignoreTextInput = false;
        if (!this.searchBox.m_93696_()) {
            if (this.f_96541_.f_91066_.f_92098_.m_90832_(pKeyCode, pScanCode)) {
                this.ignoreTextInput = true;
                this.searchBox.m_93692_(true);
                return true;
            }
            return super.m_7933_(pKeyCode, pScanCode, pModifiers);
        }
        boolean flag = this.f_97734_ != null && this.f_97734_.m_6657_();
        boolean flag1 = InputConstants.m_84827_((int)pKeyCode, (int)pScanCode).m_84876_().isPresent();
        if (flag && flag1 && this.m_97805_(pKeyCode, pScanCode)) {
            this.ignoreTextInput = true;
            return true;
        }
        String s = this.searchBox.m_94155_();
        if (this.searchBox.m_7933_(pKeyCode, pScanCode, pModifiers)) {
            if (!Objects.equals(s, this.searchBox.m_94155_())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return this.searchBox.m_93696_() && this.searchBox.m_94213_() && pKeyCode != 256 || super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_7920_(int pKeyCode, int pScanCode, int pModifiers) {
        this.ignoreTextInput = false;
        return super.m_7920_(pKeyCode, pScanCode, pModifiers);
    }

    public void refreshSearchResults() {
        this.scrollingList.clearEntries();
        String s = this.searchBox.m_94155_().toLowerCase(Locale.ROOT).trim();
        if (s.isEmpty()) {
            ((InfuserMenu)this.f_97732_).getSortedEntries().stream().map(e -> new EnchantmentListEntry((Enchantment)e.getKey(), (Integer)e.getValue())).forEach(this.scrollingList::addEntry);
        } else {
            ((InfuserMenu)this.f_97732_).getSortedEntries().stream().filter(e -> Component.m_237115_((String)((Enchantment)e.getKey()).m_44704_()).getString().toLowerCase(Locale.ROOT).contains(s)).filter(e -> (Integer)((InfuserMenu)this.f_97732_).getMaxLevel((Enchantment)e.getKey()).getSecond() > 0).map(e -> new EnchantmentListEntry((Enchantment)e.getKey(), (Integer)e.getValue())).forEach(this.scrollingList::addEntry);
        }
        this.scrollOffs = 0.0f;
        this.scrollingList.scrollTo(0.0f);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0 && this.insideScrollbar(pMouseX, pMouseY)) {
            this.scrolling = this.scrollingList.canScroll();
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    protected boolean insideScrollbar(double pMouseX, double pMouseY) {
        int fromX = this.f_97735_ + 197;
        int fromY = this.f_97736_ + 17;
        int toX = fromX + 14;
        int toY = fromY + 72;
        return pMouseX >= (double)fromX && pMouseY >= (double)fromY && pMouseX < (double)toX && pMouseY < (double)toY;
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0) {
            this.scrolling = false;
        }
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (!this.scrollingList.canScroll()) {
            return false;
        }
        this.scrollOffs = (float)((double)this.scrollOffs - pDelta / (double)(this.scrollingList.getItemCount() - 4));
        this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
        this.scrollingList.scrollTo(this.scrollOffs);
        return true;
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling) {
            int i = this.f_97736_ + 17;
            int j = i + 72;
            this.scrollOffs = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.scrollingList.scrollTo(this.scrollOffs);
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.insufficientPower = false;
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.scrollingList.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderEnchantingPower(guiGraphics, mouseX, mouseY);
        this.renderEnchantButtonCost(guiGraphics, mouseX, mouseY);
        this.renderRepairButtonCost(guiGraphics, mouseX, mouseY);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    private void renderRepairButtonCost(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.repairButton == null) {
            return;
        }
        int repairCost = ((InfuserMenu)this.f_97732_).getRepairCost();
        boolean canRepair = ((InfuserMenu)this.f_97732_).canRepair((Player)this.f_96541_.f_91074_);
        if (!canRepair && repairCost == 0) {
            return;
        }
        int posX = this.repairButton.m_252754_();
        int posY = this.repairButton.m_252907_();
        if (repairCost != 0) {
            int costColor = canRepair ? ChatFormatting.GREEN.m_126665_() : ChatFormatting.RED.m_126665_();
            this.renderReadableText(guiGraphics, posX + 1, posY + 1, String.valueOf(repairCost), costColor);
        }
        if (mouseX >= posX && mouseY >= posY && mouseX < posX + 18 && mouseY < posY + 18) {
            ArrayList list = Lists.newArrayList();
            if (canRepair) {
                ItemStack stack = ((InfuserMenu)this.f_97732_).getEnchantableStack();
                MutableComponent nameComponent = Component.m_237119_().m_7220_(stack.m_41786_()).m_130940_(stack.m_41791_().f_43022_);
                if (stack.m_41788_()) {
                    nameComponent.m_130940_(ChatFormatting.ITALIC);
                }
                list.add(nameComponent);
                MutableComponent changeComponent = Component.m_237110_((String)"gui.enchantinginfuser.tooltip.change", (Object[])new Object[]{stack.m_41776_() - stack.m_41773_(), stack.m_41776_()});
                MutableComponent durabilityComponent = Component.m_237110_((String)"gui.enchantinginfuser.tooltip.durability", (Object[])new Object[]{changeComponent}).m_130940_(ChatFormatting.YELLOW);
                list.add(durabilityComponent);
                list.add(Component.m_237119_());
                MutableComponent levelComponent = repairCost == 1 ? Component.m_237115_((String)"container.enchant.level.one") : Component.m_237110_((String)"container.enchant.level.many", (Object[])new Object[]{repairCost});
                list.add(levelComponent.m_130940_(ChatFormatting.GRAY));
            } else {
                list.add(Component.m_237110_((String)"container.enchant.level.requirement", (Object[])new Object[]{repairCost}).m_130940_(ChatFormatting.RED));
            }
            this.m_257959_(Language.m_128107_().m_128112_((List)list));
        }
    }

    private void renderEnchantButtonCost(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int enchantCost = ((InfuserMenu)this.f_97732_).getEnchantCost();
        boolean canEnchant = ((InfuserMenu)this.f_97732_).canEnchant((Player)this.f_96541_.f_91074_);
        if (!canEnchant && enchantCost == 0) {
            return;
        }
        int posX = this.enchantButton.m_252754_();
        int posY = this.enchantButton.m_252907_();
        if (enchantCost != 0) {
            int costColor = enchantCost < 0 ? ChatFormatting.YELLOW.m_126665_() : (canEnchant ? ChatFormatting.GREEN.m_126665_() : ChatFormatting.RED.m_126665_());
            this.renderReadableText(guiGraphics, posX + 1, posY + 1, enchantCost < 0 ? "+" : String.valueOf(enchantCost), costColor);
        }
        if (mouseX >= posX && mouseY >= posY && mouseX < posX + 18 && mouseY < posY + 18) {
            ArrayList list = Lists.newArrayList();
            if (canEnchant) {
                Map<Enchantment, Integer> enchantments = ((InfuserMenu)this.f_97732_).getValidEnchantments();
                boolean enchanted = enchantments.values().stream().anyMatch(level -> level > 0);
                ItemStack stack = ((InfuserMenu)this.f_97732_).getEnchantableStack();
                ItemStack displayStack = EnchantmentUtil.getNewEnchantmentStack(stack, enchanted, false);
                MutableComponent nameComponent = Component.m_237119_().m_7220_(displayStack.m_41786_()).m_130940_(this.getItemNameRarity((ItemStack)displayStack, (boolean)enchanted).f_43022_);
                if (stack.m_41788_()) {
                    nameComponent.m_130940_(ChatFormatting.ITALIC);
                }
                list.add(nameComponent);
                this.addEnchantments(stack, enchantments, list);
                if (enchantCost != 0) {
                    list.add(Component.m_237119_());
                    MutableComponent levelComponent = enchantCost < 0 ? Component.m_237115_((String)"gui.enchantinginfuser.tooltip.points") : (enchantCost == 1 ? Component.m_237115_((String)"container.enchant.level.one") : Component.m_237110_((String)"container.enchant.level.many", (Object[])new Object[]{enchantCost}));
                    list.add(levelComponent.m_130940_(ChatFormatting.GRAY));
                }
            } else {
                list.add(Component.m_237110_((String)"container.enchant.level.requirement", (Object[])new Object[]{enchantCost}).m_130940_(ChatFormatting.RED));
            }
            this.m_257959_(Language.m_128107_().m_128112_((List)list));
        }
    }

    private Rarity getItemNameRarity(ItemStack stack, boolean enchanted) {
        Rarity rarity = stack.m_41720_().m_41460_(new ItemStack((ItemLike)stack.m_41720_()));
        if (!enchanted || stack.m_41720_() instanceof EnchantedBookItem) {
            return rarity;
        }
        if (rarity == Rarity.RARE || rarity == Rarity.EPIC) {
            return Rarity.EPIC;
        }
        return Rarity.RARE;
    }

    private void addEnchantments(ItemStack stack, Map<Enchantment, Integer> enchantments, List<FormattedText> list) {
        Map oldEnchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        ArrayList newList = Lists.newArrayList();
        ArrayList changedList = Lists.newArrayList();
        ArrayList oldList = Lists.newArrayList();
        ArrayList removedList = Lists.newArrayList();
        HashSet allEnchantments = Sets.newHashSet(enchantments.keySet());
        allEnchantments.addAll(oldEnchantments.keySet());
        for (Enchantment enchantment : allEnchantments) {
            MutableComponent component;
            int oldLevel = oldEnchantments.getOrDefault(enchantment, -1);
            int newLevel = enchantments.getOrDefault(enchantment, -1);
            if (newLevel > 0 && oldLevel <= 0) {
                component = EnchantmentUtil.getPlainEnchantmentName(enchantment, newLevel);
                newList.add(component.m_130940_(ChatFormatting.GREEN));
                continue;
            }
            if (newLevel == 0 && oldLevel > 0) {
                component = EnchantmentUtil.getPlainEnchantmentName(enchantment, oldLevel);
                removedList.add(component.m_130940_(ChatFormatting.RED));
                continue;
            }
            if (newLevel > 0 && oldLevel > 0 && newLevel != oldLevel) {
                component = EnchantmentUtil.getPlainEnchantmentName(enchantment, -1);
                MutableComponent changeComponent = Component.m_237110_((String)"gui.enchantinginfuser.tooltip.change", (Object[])new Object[]{Component.m_237115_((String)("enchantment.level." + oldLevel)), Component.m_237115_((String)("enchantment.level." + newLevel))});
                changedList.add(component.m_130946_(" ").m_7220_((Component)changeComponent).m_130940_(ChatFormatting.YELLOW));
                continue;
            }
            if (newLevel <= 0 && oldLevel <= 0) continue;
            component = EnchantmentUtil.getPlainEnchantmentName(enchantment, newLevel != 0 ? newLevel : oldLevel);
            oldList.add(component.m_130940_(ChatFormatting.GRAY));
        }
        list.addAll(newList);
        list.addAll(changedList);
        list.addAll(oldList);
        list.addAll(removedList);
    }

    private void renderReadableText(GuiGraphics guiGraphics, int posX, int posY, String text, int color) {
        guiGraphics.m_280056_(this.f_96547_, text, (posX += 17 - this.f_96547_.m_92895_(text)) - 1, posY += 9, 0, false);
        guiGraphics.m_280056_(this.f_96547_, text, posX + 1, posY, 0, false);
        guiGraphics.m_280056_(this.f_96547_, text, posX, posY - 1, 0, false);
        guiGraphics.m_280056_(this.f_96547_, text, posX, posY + 1, 0, false);
        guiGraphics.m_280056_(this.f_96547_, text, posX, posY, color, false);
    }

    private void renderEnchantingPower(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ItemStack stack = new ItemStack((ItemLike)Items.f_41997_);
        int posX = this.f_97735_ + 196;
        int posY = this.f_97736_ + 161;
        guiGraphics.m_280480_(stack, posX, posY);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85837_(0.0, 0.0, 300.0);
        int power = ((InfuserMenu)this.f_97732_).getCurrentPower();
        int maxPower = ((InfuserMenu)this.f_97732_).getMaxPower();
        int textColor = power >= maxPower ? ChatFormatting.YELLOW.m_126665_() : (this.insufficientPower ? ChatFormatting.RED.m_126665_().intValue() : ChatFormatting.WHITE.m_126665_().intValue());
        guiGraphics.m_280488_(this.f_96547_, String.valueOf(power), posX + 19 - 2 - this.f_96547_.m_92895_(String.valueOf(power)), posY + 6 + 3, textColor);
        guiGraphics.m_280168_().m_85849_();
        if (mouseX >= posX && mouseY >= posY && mouseX < posX + 16 && mouseY < posY + 16) {
            ArrayList list = Lists.newArrayList();
            list.add(Component.m_237110_((String)CURRENT_ENCHANTING_POWER_TRANSLATION_KEY, (Object[])new Object[]{ENCHANTING_POWER_COMPONENT, power, maxPower}).m_130940_(ChatFormatting.YELLOW).m_7532_());
            if (power < maxPower) {
                list.addAll(this.f_96547_.m_92923_((FormattedText)Component.m_237115_((String)"gui.enchantinginfuser.tooltip.enchanting_power.hint").m_130940_(ChatFormatting.GRAY), 175));
            }
            this.m_257959_(list);
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(INFUSER_LOCATION, i, j, 0, 0, this.f_97726_, this.f_97727_);
        this.searchBox.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int sliderX = this.f_97735_ + 197 - 2;
        int sliderY = this.f_97736_ + 17 - 2;
        int sliderRange = sliderY + 72 + 2 + 2;
        guiGraphics.m_280218_(INFUSER_LOCATION, sliderX, sliderY + (int)((float)(sliderRange - sliderY - 18) * this.scrollOffs), 220, 54 + (this.scrollingList.canScroll() ? 18 : 0), 18, 18);
        guiGraphics.m_280218_(INFUSER_LOCATION, this.f_97735_ + 8 - 1, this.f_97736_ + (((InfuserMenu)this.f_97732_).config.allowRepairing.isActive() ? 23 : 34) - 1, 162, 185, 18, 18);
    }

    private class ScrollingList
    extends AbstractContainerEventHandler
    implements Renderable,
    NarratableEntry {
        private final List<EnchantmentListEntry> children = Lists.newArrayList();
        private final int posX;
        private final int posY;
        private final int itemWidth;
        private final int itemHeight;
        private final int length;
        private int scrollPosition;

        public ScrollingList(int posX, int posY, int itemWidth, int itemHeight, int length) {
            this.posX = posX;
            this.posY = posY;
            this.itemWidth = itemWidth;
            this.itemHeight = itemHeight;
            this.length = length;
        }

        public void scrollTo(float pos) {
            if (pos < 0.0f || pos > 1.0f) {
                throw new IllegalArgumentException("pos must be of interval 0 to 1");
            }
            this.scrollPosition = this.canScroll() ? Math.round((float)(this.getItemCount() - this.length) * pos) : 0;
        }

        public boolean canScroll() {
            return this.getItemCount() > this.length;
        }

        protected final void clearEntries() {
            this.children.clear();
        }

        protected void addEntry(EnchantmentListEntry pEntry) {
            this.children.add(pEntry);
            pEntry.setList(this);
            this.markOthersIncompatible();
        }

        protected int getItemCount() {
            return this.children.size();
        }

        public void markOthersIncompatible() {
            List<EnchantmentListEntry> activeEnchants = this.children.stream().filter(EnchantmentListEntry::isActive).toList();
            for (EnchantmentListEntry entry : this.children) {
                if (entry.isActive()) continue;
                entry.markIncompatible(activeEnchants.stream().filter(e -> e.isIncompatibleWith(entry)).collect(Collectors.toSet()));
            }
        }

        @Nullable
        protected final EnchantmentListEntry getEntryAtPosition(double mouseX, double mouseY) {
            if (this.m_5953_(mouseX, mouseY)) {
                int index = this.scrollPosition + (int)((mouseY - (double)this.posY) / (double)this.itemHeight);
                return index < this.children.size() ? this.children.get(index) : null;
            }
            return null;
        }

        public boolean m_5953_(double mouseX, double mouseY) {
            return mouseX >= (double)this.posX && mouseX < (double)(this.posX + this.itemWidth) && mouseY >= (double)this.posY && mouseY < (double)(this.posY + this.itemHeight * this.length);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (!this.m_5953_(mouseX, mouseY)) {
                return false;
            }
            EnchantmentListEntry entry = this.getEntryAtPosition(mouseX, mouseY);
            if (entry != null && entry.m_6375_(mouseX, mouseY, button)) {
                this.m_7522_((GuiEventListener)entry);
                this.m_7897_(true);
                return true;
            }
            return false;
        }

        public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
            if (this.m_7222_() != null) {
                this.m_7222_().m_6348_(pMouseX, pMouseY, pButton);
            }
            return false;
        }

        public List<EnchantmentListEntry> m_6702_() {
            return this.children;
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            for (int i = 0; i < Math.min(this.length, this.getItemCount()); ++i) {
                this.children.get(this.scrollPosition + i).render(guiGraphics, this.posX, this.posY + this.itemHeight * i, this.itemWidth, this.itemHeight, mouseX, mouseY, partialTick);
            }
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
        }
    }

    private class EnchantmentListEntry
    implements ContainerEventHandler {
        private static final Component UNKNOWN_ENCHANT_COMPONENT = Component.m_237115_((String)"gui.enchantinginfuser.tooltip.unknown_enchantment").m_130940_(ChatFormatting.GRAY);
        private static final Component INCREASE_LEVEL_COMPONENT = Component.m_237115_((String)"gui.enchantinginfuser.tooltip.lowPower1").m_130940_(ChatFormatting.GRAY);
        private static final Component MODIFY_LEVEL_COMPONENT = Component.m_237115_((String)"gui.enchantinginfuser.tooltip.lowPower2").m_130940_(ChatFormatting.GRAY);
        private final Enchantment enchantment;
        private final int maxLevel;
        private final int requiredPower;
        private final Button decrButton;
        private final Button incrButton;
        private int level;
        private ScrollingList list;
        @Nullable
        private GuiEventListener focused;
        private boolean dragging;
        private Set<Enchantment> incompatible = Sets.newHashSet();

        public EnchantmentListEntry(Enchantment enchantment, int level) {
            this.enchantment = enchantment;
            Pair<OptionalInt, Integer> maxLevelResult = ((InfuserMenu)InfuserScreen.this.f_97732_).getMaxLevel(enchantment);
            this.maxLevel = (Integer)maxLevelResult.getSecond();
            this.requiredPower = ((OptionalInt)maxLevelResult.getFirst()).orElse(-1);
            this.level = level;
            this.decrButton = new IconButton(0, 0, 18, 18, 220, 0, INFUSER_LOCATION, button -> {
                do {
                    int newLevel;
                    if ((newLevel = ((InfuserMenu)InfuserScreen.this.f_97732_).clickEnchantmentLevelButton((Player)((InfuserScreen)InfuserScreen.this).f_96541_.f_91074_, this.enchantment, false)) == -1) {
                        return;
                    }
                    this.level = newLevel;
                    EnchantingInfuser.NETWORK.sendToServer((MessageV2)new C2SAddEnchantLevelMessage(((InfuserMenu)((InfuserScreen)InfuserScreen.this).f_97732_).f_38840_, this.enchantment, false));
                    this.updateButtons();
                    this.list.markOthersIncompatible();
                } while (button.f_93623_ && button.f_93624_ && Screen.m_96638_());
            }){

                @Override
                public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
                    if (this.f_93623_ && Screen.m_96638_()) {
                        RenderSystem.enableDepthTest();
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
                        int index = !this.f_93623_ ? 0 : (this.m_198029_() ? 2 : 1);
                        guiGraphics.m_280163_(this.f_94223_, this.m_252754_() + 2, this.m_252907_(), (float)this.xTexStart, (float)(this.yTexStart + index * this.f_94226_), this.f_93618_, this.f_93619_, this.f_94227_, this.f_94228_);
                        guiGraphics.m_280163_(this.f_94223_, this.m_252754_() - 4, this.m_252907_(), (float)this.xTexStart, (float)(this.yTexStart + index * this.f_94226_), this.f_93618_, this.f_93619_, this.f_94227_, this.f_94228_);
                        this.renderTooltip();
                    } else {
                        super.m_87963_(guiGraphics, mouseX, mouseY, partialTicks);
                        this.renderTooltip();
                    }
                }

                private void renderTooltip() {
                    if (this.m_198029_() && EnchantmentListEntry.this.level - 1 >= EnchantmentListEntry.this.maxLevel && !EnchantmentListEntry.this.isObfuscated()) {
                        InfuserScreen.this.m_257959_(EnchantmentListEntry.this.getLowPowerComponent(MODIFY_LEVEL_COMPONENT));
                        InfuserScreen.this.insufficientPower = true;
                    }
                }
            };
            this.incrButton = new IconButton(0, 0, 18, 18, 238, 0, INFUSER_LOCATION, button -> {
                do {
                    int newLevel;
                    if ((newLevel = ((InfuserMenu)InfuserScreen.this.f_97732_).clickEnchantmentLevelButton((Player)((InfuserScreen)InfuserScreen.this).f_96541_.f_91074_, this.enchantment, true)) == -1) {
                        return;
                    }
                    this.level = newLevel;
                    EnchantingInfuser.NETWORK.sendToServer((MessageV2)new C2SAddEnchantLevelMessage(((InfuserMenu)((InfuserScreen)InfuserScreen.this).f_97732_).f_38840_, this.enchantment, true));
                    this.updateButtons();
                    this.list.markOthersIncompatible();
                } while (button.f_93623_ && button.f_93624_ && Screen.m_96638_());
            }){

                @Override
                public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
                    if (this.f_93623_ && Screen.m_96638_()) {
                        RenderSystem.enableDepthTest();
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
                        int index = !this.f_93623_ ? 0 : (this.m_198029_() ? 2 : 1);
                        guiGraphics.m_280163_(this.f_94223_, this.m_252754_() - 2, this.m_252907_(), (float)this.xTexStart, (float)(this.yTexStart + index * this.f_94226_), this.f_93618_, this.f_93619_, this.f_94227_, this.f_94228_);
                        guiGraphics.m_280163_(this.f_94223_, this.m_252754_() + 4, this.m_252907_(), (float)this.xTexStart, (float)(this.yTexStart + index * this.f_94226_), this.f_93618_, this.f_93619_, this.f_94227_, this.f_94228_);
                        this.renderTooltip();
                    } else {
                        super.m_87963_(guiGraphics, mouseX, mouseY, partialTicks);
                        this.renderTooltip();
                    }
                }

                private void renderTooltip() {
                    if (this.m_198029_() && EnchantmentListEntry.this.level >= EnchantmentListEntry.this.maxLevel && !EnchantmentListEntry.this.isObfuscated()) {
                        InfuserScreen.this.m_257959_(EnchantmentListEntry.this.getLowPowerComponent(INCREASE_LEVEL_COMPONENT));
                        InfuserScreen.this.insufficientPower = true;
                    }
                }
            };
            this.updateButtons();
        }

        private List<FormattedCharSequence> getLowPowerComponent(Component component) {
            ArrayList list = Lists.newArrayList();
            MutableComponent currentPower = Component.m_237113_((String)String.valueOf(((InfuserMenu)InfuserScreen.this.f_97732_).getCurrentPower())).m_130940_(ChatFormatting.RED);
            MutableComponent requiredPower = Component.m_237113_((String)String.valueOf(this.requiredPower));
            list.add(Component.m_237110_((String)InfuserScreen.CURRENT_ENCHANTING_POWER_TRANSLATION_KEY, (Object[])new Object[]{ENCHANTING_POWER_COMPONENT, currentPower, requiredPower}).m_7532_());
            list.addAll(InfuserScreen.this.f_96547_.m_92923_((FormattedText)component, 175));
            return list;
        }

        public void setList(ScrollingList list) {
            this.list = list;
        }

        public void markIncompatible(Collection<EnchantmentListEntry> incompatibleList) {
            this.incompatible = incompatibleList.stream().map(e -> e.enchantment).collect(Collectors.toSet());
            boolean compatible = incompatibleList.isEmpty();
            if (!compatible) {
                this.level = 0;
            }
            this.updateButtons();
            this.decrButton.f_93623_ = compatible;
            this.incrButton.f_93623_ &= compatible;
        }

        private void updateButtons() {
            this.decrButton.f_93624_ = this.level > 0;
            this.incrButton.f_93624_ = this.level < EnchantingInfuserAPI.getEnchantStatsProvider().getMaxLevel(this.enchantment);
            this.decrButton.f_93623_ = this.level - 1 < this.maxLevel;
            this.incrButton.f_93623_ = this.level < this.maxLevel;
        }

        public boolean isActive() {
            return this.level > 0;
        }

        public boolean isIncompatible() {
            return !this.incompatible.isEmpty();
        }

        public boolean isObfuscated() {
            return this.maxLevel == 0;
        }

        private int getYImage() {
            return this.isIncompatible() || this.isObfuscated() ? 0 : (this.isActive() ? 2 : 1);
        }

        public boolean isIncompatibleWith(EnchantmentListEntry other) {
            if (other == this) {
                return false;
            }
            return (this.isActive() || other.isActive()) && !EnchantingInfuserAPI.getEnchantStatsProvider().isCompatibleWith(this.enchantment, other.enchantment);
        }

        public void render(GuiGraphics guiGraphics, int leftPos, int topPos, int width, int height, int mouseX, int mouseY, float partialTicks) {
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)INFUSER_LOCATION);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280218_(INFUSER_LOCATION, leftPos + 18, topPos, 0, 185 + this.getYImage() * 18, 126, 18);
            FormattedCharSequence formattedCharSequence = this.getRenderingName(this.enchantment, width);
            guiGraphics.m_280364_(InfuserScreen.this.f_96547_, formattedCharSequence, leftPos + width / 2, topPos + 5, this.isIncompatible() || this.isObfuscated() ? 6839882 : -1);
            if (mouseX >= leftPos + 18 && mouseX < leftPos + 18 + 126 && mouseY >= topPos && mouseY < topPos + 18) {
                this.handleTooltip(this.enchantment);
            }
            this.decrButton.m_252865_(leftPos);
            this.decrButton.m_253211_(topPos);
            this.decrButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            this.incrButton.m_252865_(leftPos + width - 18);
            this.incrButton.m_253211_(topPos);
            this.incrButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }

        private FormattedCharSequence getRenderingName(Enchantment enchantment, int maxWidth) {
            FormattedCharSequence formattedCharSequence = null;
            if (this.isObfuscated()) {
                EnchantmentNames.m_98734_().m_98735_((long)(InfuserScreen.this.enchantmentSeed + BuiltInRegistries.f_256876_.m_7447_((Object)enchantment)));
                FormattedText formattedtext = EnchantmentNames.m_98734_().m_98737_(InfuserScreen.this.f_96547_, (int)((float)maxWidth * 0.72f));
                List list = InfuserScreen.this.f_96547_.m_92923_(formattedtext, (int)((float)maxWidth * 0.72f));
                if (!list.isEmpty()) {
                    formattedCharSequence = (FormattedCharSequence)list.get(0);
                }
            }
            if (formattedCharSequence == null) {
                MutableComponent component = Component.m_237115_((String)enchantment.m_44704_());
                if (this.isActive()) {
                    component.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)("enchantment.level." + this.level)));
                }
                formattedCharSequence = component.m_7532_();
            }
            return formattedCharSequence;
        }

        private void handleTooltip(Enchantment enchantment) {
            if (this.isObfuscated()) {
                InfuserScreen.this.m_257959_(this.getLowPowerComponent(UNKNOWN_ENCHANT_COMPONENT));
                InfuserScreen.this.insufficientPower = true;
            } else if (this.isIncompatible()) {
                MutableComponent incompatibleComponent = Component.m_237110_((String)"gui.enchantinginfuser.tooltip.incompatible", (Object[])new Object[]{this.incompatible.stream().map(e -> Component.m_237115_((String)e.m_44704_())).reduce((o1, o2) -> o1.m_130946_(", ").m_7220_((Component)o2)).orElse(Component.m_237119_()).m_130940_(ChatFormatting.GRAY)});
                InfuserScreen.this.m_257959_(InfuserScreen.this.f_96547_.m_92923_((FormattedText)incompatibleComponent, 175));
            } else {
                ArrayList list = Lists.newArrayList();
                if (Language.m_128107_().m_6722_(enchantment.m_44704_() + ".desc")) {
                    list.addAll(InfuserScreen.this.f_96547_.m_92923_((FormattedText)Component.m_237115_((String)(enchantment.m_44704_() + ".desc")).m_130940_(ChatFormatting.GRAY), 175));
                } else if (Language.m_128107_().m_6722_(enchantment.m_44704_() + ".description")) {
                    list.addAll(InfuserScreen.this.f_96547_.m_92923_((FormattedText)Component.m_237115_((String)(enchantment.m_44704_() + ".description")).m_130940_(ChatFormatting.GRAY), 175));
                }
                MutableComponent levelsComponent = Component.m_237115_((String)("enchantment.level." + EnchantingInfuserAPI.getEnchantStatsProvider().getMinLevel(enchantment)));
                if (EnchantingInfuserAPI.getEnchantStatsProvider().getMinLevel(enchantment) != EnchantingInfuserAPI.getEnchantStatsProvider().getMaxLevel(enchantment)) {
                    levelsComponent.m_130946_("-").m_7220_((Component)Component.m_237115_((String)("enchantment.level." + EnchantingInfuserAPI.getEnchantStatsProvider().getMaxLevel(enchantment))));
                }
                MutableComponent wrappedComponent = Component.m_237113_((String)"(").m_7220_((Component)levelsComponent).m_130946_(")").m_130940_(ChatFormatting.GRAY);
                list.add(0, Component.m_237115_((String)enchantment.m_44704_()).m_130946_(" ").m_7220_((Component)wrappedComponent).m_7532_());
                InfuserScreen.this.m_257959_(list);
            }
        }

        public boolean m_5953_(double pMouseX, double pMouseY) {
            return Objects.equals(this.list.getEntryAtPosition(pMouseX, pMouseY), this);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.decrButton, (Object)this.incrButton);
        }

        public boolean m_7282_() {
            return this.dragging;
        }

        public void m_7897_(boolean pDragging) {
            this.dragging = pDragging;
        }

        public void m_7522_(@Nullable GuiEventListener pListener) {
            this.focused = pListener;
        }

        @Nullable
        public GuiEventListener m_7222_() {
            return this.focused;
        }
    }
}

