/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.util.phys;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3f;

public class OrientedBoundingBox {
    public Vec3 center;
    public Vec3 extent;
    public Vec3 axisX;
    public Vec3 axisY;
    public Vec3 axisZ;
    public Vec3 scaledAxisX;
    public Vec3 scaledAxisY;
    public Vec3 scaledAxisZ;
    public Matrix3f rotation = new Matrix3f();
    public Vec3 vertex1;
    public Vec3 vertex2;
    public Vec3 vertex3;
    public Vec3 vertex4;
    public Vec3 vertex5;
    public Vec3 vertex6;
    public Vec3 vertex7;
    public Vec3 vertex8;
    public Vec3[] vertices;

    public OrientedBoundingBox(Vec3 center, double width, double height, double depth, float yaw, float pitch) {
        this.center = center;
        this.extent = new Vec3(width / 2.0, height / 2.0, depth / 2.0);
        this.axisZ = Vec3.m_82498_((float)yaw, (float)pitch).m_82541_();
        this.axisY = Vec3.m_82498_((float)(yaw + 90.0f), (float)pitch).m_82548_().m_82541_();
        this.axisX = this.axisZ.m_82537_(this.axisY);
    }

    public OrientedBoundingBox(Vec3 center, Vec3 size, float yaw, float pitch) {
        this(center, size.f_82479_, size.f_82480_, size.f_82481_, yaw, pitch);
    }

    public OrientedBoundingBox(AABB box) {
        this.center = new Vec3((box.f_82291_ + box.f_82288_) / 2.0, (box.f_82292_ + box.f_82289_) / 2.0, (box.f_82293_ + box.f_82290_) / 2.0);
        this.extent = new Vec3(Math.abs(box.f_82291_ - box.f_82288_) / 2.0, Math.abs(box.f_82292_ - box.f_82289_) / 2.0, Math.abs(box.f_82293_ - box.f_82290_) / 2.0);
        this.axisX = new Vec3(1.0, 0.0, 0.0);
        this.axisY = new Vec3(0.0, 1.0, 0.0);
        this.axisZ = new Vec3(0.0, 0.0, 1.0);
    }

    public OrientedBoundingBox(OrientedBoundingBox obb) {
        this.center = obb.center;
        this.extent = obb.extent;
        this.axisX = obb.axisX;
        this.axisY = obb.axisY;
        this.axisZ = obb.axisZ;
    }

    public OrientedBoundingBox copy() {
        return new OrientedBoundingBox(this);
    }

    public OrientedBoundingBox offsetAlongAxisX(double offset) {
        this.center = this.center.m_82549_(this.axisX.m_82490_(offset));
        return this;
    }

    public OrientedBoundingBox offsetAlongAxisY(double offset) {
        this.center = this.center.m_82549_(this.axisY.m_82490_(offset));
        return this;
    }

    public OrientedBoundingBox offsetAlongAxisZ(double offset) {
        this.center = this.center.m_82549_(this.axisZ.m_82490_(offset));
        return this;
    }

    public OrientedBoundingBox offset(Vec3 offset) {
        this.center = this.center.m_82549_(offset);
        return this;
    }

    public OrientedBoundingBox scale(double scale) {
        this.extent = this.extent.m_82490_(scale);
        return this;
    }

    public OrientedBoundingBox updateVertex() {
        this.rotation.set(0, 0, (float)this.axisX.f_82479_);
        this.rotation.set(0, 1, (float)this.axisX.f_82480_);
        this.rotation.set(0, 2, (float)this.axisX.f_82481_);
        this.rotation.set(1, 0, (float)this.axisY.f_82479_);
        this.rotation.set(1, 1, (float)this.axisY.f_82480_);
        this.rotation.set(1, 2, (float)this.axisY.f_82481_);
        this.rotation.set(2, 0, (float)this.axisZ.f_82479_);
        this.rotation.set(2, 1, (float)this.axisZ.f_82480_);
        this.rotation.set(2, 2, (float)this.axisZ.f_82481_);
        this.scaledAxisX = this.axisX.m_82490_(this.extent.f_82479_);
        this.scaledAxisY = this.axisY.m_82490_(this.extent.f_82480_);
        this.scaledAxisZ = this.axisZ.m_82490_(this.extent.f_82481_);
        this.vertex1 = this.center.m_82546_(this.scaledAxisZ).m_82546_(this.scaledAxisX).m_82546_(this.scaledAxisY);
        this.vertex2 = this.center.m_82546_(this.scaledAxisZ).m_82549_(this.scaledAxisX).m_82546_(this.scaledAxisY);
        this.vertex3 = this.center.m_82546_(this.scaledAxisZ).m_82549_(this.scaledAxisX).m_82549_(this.scaledAxisY);
        this.vertex4 = this.center.m_82546_(this.scaledAxisZ).m_82546_(this.scaledAxisX).m_82549_(this.scaledAxisY);
        this.vertex5 = this.center.m_82549_(this.scaledAxisZ).m_82546_(this.scaledAxisX).m_82546_(this.scaledAxisY);
        this.vertex6 = this.center.m_82549_(this.scaledAxisZ).m_82549_(this.scaledAxisX).m_82546_(this.scaledAxisY);
        this.vertex7 = this.center.m_82549_(this.scaledAxisZ).m_82549_(this.scaledAxisX).m_82549_(this.scaledAxisY);
        this.vertex8 = this.center.m_82549_(this.scaledAxisZ).m_82546_(this.scaledAxisX).m_82549_(this.scaledAxisY);
        this.vertices = new Vec3[]{this.vertex1, this.vertex2, this.vertex3, this.vertex4, this.vertex5, this.vertex6, this.vertex7, this.vertex8};
        return this;
    }

    public boolean contains(Vec3 point) {
        Vector3f distance = point.m_82546_(this.center).m_252839_();
        distance.mulTranspose((Matrix3fc)this.rotation);
        return (double)Math.abs(distance.x()) < this.extent.f_82479_ && (double)Math.abs(distance.y()) < this.extent.f_82480_ && (double)Math.abs(distance.z()) < this.extent.f_82481_;
    }

    public boolean intersects(AABB boundingBox) {
        OrientedBoundingBox otherOBB = new OrientedBoundingBox(boundingBox).updateVertex();
        return OrientedBoundingBox.Intersects(this, otherOBB);
    }

    public boolean intersects(OrientedBoundingBox otherOBB) {
        return OrientedBoundingBox.Intersects(this, otherOBB);
    }

    public static boolean Intersects(OrientedBoundingBox a, OrientedBoundingBox b) {
        if (OrientedBoundingBox.Separated(a.vertices, b.vertices, a.scaledAxisX)) {
            return false;
        }
        if (OrientedBoundingBox.Separated(a.vertices, b.vertices, a.scaledAxisY)) {
            return false;
        }
        if (OrientedBoundingBox.Separated(a.vertices, b.vertices, a.scaledAxisZ)) {
            return false;
        }
        if (OrientedBoundingBox.Separated(a.vertices, b.vertices, b.scaledAxisX)) {
            return false;
        }
        if (OrientedBoundingBox.Separated(a.vertices, b.vertices, b.scaledAxisY)) {
            return false;
        }
        if (OrientedBoundingBox.Separated(a.vertices, b.vertices, b.scaledAxisZ)) {
            return false;
        }
        if (OrientedBoundingBox.Separated(a.vertices, b.vertices, a.scaledAxisX.m_82537_(b.scaledAxisX))) {
            return false;
        }
        if (OrientedBoundingBox.Separated(a.vertices, b.vertices, a.scaledAxisX.m_82537_(b.scaledAxisY))) {
            return false;
        }
        if (OrientedBoundingBox.Separated(a.vertices, b.vertices, a.scaledAxisX.m_82537_(b.scaledAxisZ))) {
            return false;
        }
        if (OrientedBoundingBox.Separated(a.vertices, b.vertices, a.scaledAxisY.m_82537_(b.scaledAxisX))) {
            return false;
        }
        if (OrientedBoundingBox.Separated(a.vertices, b.vertices, a.scaledAxisY.m_82537_(b.scaledAxisY))) {
            return false;
        }
        if (OrientedBoundingBox.Separated(a.vertices, b.vertices, a.scaledAxisY.m_82537_(b.scaledAxisZ))) {
            return false;
        }
        if (OrientedBoundingBox.Separated(a.vertices, b.vertices, a.scaledAxisZ.m_82537_(b.scaledAxisX))) {
            return false;
        }
        if (OrientedBoundingBox.Separated(a.vertices, b.vertices, a.scaledAxisZ.m_82537_(b.scaledAxisY))) {
            return false;
        }
        return !OrientedBoundingBox.Separated(a.vertices, b.vertices, a.scaledAxisZ.m_82537_(b.scaledAxisZ));
    }

    private static boolean Separated(Vec3[] vertsA, Vec3[] vertsB, Vec3 axis) {
        double sumSpan;
        if (axis.equals((Object)Vec3.f_82478_)) {
            return false;
        }
        double aMin = Double.POSITIVE_INFINITY;
        double aMax = Double.NEGATIVE_INFINITY;
        double bMin = Double.POSITIVE_INFINITY;
        double bMax = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < 8; ++i) {
            double aDist = vertsA[i].m_82526_(axis);
            aMin = Math.min(aDist, aMin);
            aMax = Math.max(aDist, aMax);
            double bDist = vertsB[i].m_82526_(axis);
            bMin = Math.min(bDist, bMin);
            bMax = Math.max(bDist, bMax);
        }
        double longSpan = Math.max(aMax, bMax) - Math.min(aMin, bMin);
        return longSpan >= (sumSpan = aMax - aMin + bMax - bMin);
    }

    public <T extends Entity> List<T> filter(List<T> entities) {
        return entities.stream().filter((? super T entity) -> this.intersects(entity.m_20191_().m_82400_((double)entity.m_6143_())) || this.contains(entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0))).collect(Collectors.toList());
    }

    public static <T extends Entity> List<T> getInitialTargets(Player player, Class<T> clazz, Vec3 hitbox) {
        double longest = Math.max(Math.max(hitbox.m_7096_(), hitbox.m_7098_()), hitbox.m_7094_());
        AABB box = player.m_20191_().m_82400_(longest);
        return player.m_9236_().m_6443_(clazz, box, entity -> !entity.m_5833_() && entity.m_6087_()).stream().filter((? super T entity) -> entity != player && entity.m_6097_() && !entity.equals((Object)player.m_20202_())).collect(Collectors.toList());
    }

    public static Vec3 getInitialTracingPoint(Player player) {
        double shoulderHeight = (double)player.m_20206_() * 0.15 * (double)player.m_6134_();
        return player.m_146892_().m_82492_(0.0, shoulderHeight, 0.0);
    }

    public static <T extends Entity> TargetResult<T> findAttackTargetResult(Player player, Class<T> clazz, Vec3 hitbox, double offset) {
        Vec3 origin = OrientedBoundingBox.getInitialTracingPoint(player);
        List<T> entities = OrientedBoundingBox.getInitialTargets(player, clazz, hitbox);
        BlockHitResult blockResult = player.m_9236_().m_45547_(new ClipContext(origin, origin.m_82549_(player.m_20154_().m_82490_(hitbox.f_82481_)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        float distance = (float)hitbox.f_82481_;
        if (blockResult.m_6662_() == HitResult.Type.BLOCK) {
            Vec3 hit = blockResult.m_82450_();
            distance = (float)origin.m_82554_(hit);
            distance = (double)distance > offset ? (distance -= (float)offset) : 0.0f;
        }
        distance = Math.max(0.0f, distance);
        Vec3 size = new Vec3(hitbox.f_82479_ * 0.5, hitbox.f_82480_ * 0.5, (double)distance);
        OrientedBoundingBox obb = new OrientedBoundingBox(origin, size, player.m_146909_(), player.m_146908_());
        obb = obb.offsetAlongAxisZ(size.f_82481_ / 2.0);
        obb = obb.offsetAlongAxisZ(offset);
        obb.updateVertex();
        entities = obb.filter(entities);
        return new TargetResult<T>(entities, obb, distance, blockResult.m_82450_());
    }

    public static class TargetResult<T extends Entity> {
        public List<T> entities;
        public OrientedBoundingBox obb;
        public float distance;
        public Vec3 endPos;

        public TargetResult(List<T> entities, OrientedBoundingBox obb, float distance, Vec3 endPos) {
            this.entities = entities;
            this.obb = obb;
            this.distance = distance;
            this.endPos = endPos;
        }
    }
}

