/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.util.helpers;

import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import net.goo.brutality.client.player_animation.AnimationHelper;
import net.goo.brutality.event.forge.DelayedTaskScheduler;
import net.goo.brutality.item.base.BrutalityThrowingItem;
import net.goo.brutality.item.weapon.throwing.VampireKnives;
import net.goo.brutality.network.ClientboundPlayerAnimationPacket;
import net.goo.brutality.network.PacketHandler;
import net.goo.brutality.registry.BrutalityModSounds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ThrowableWeaponHelper {
    private static final Object attributesLock = new Object();

    public static boolean handleCooldown(Player player, BrutalityThrowingItem item) {
        if (player.m_36335_().m_41519_((Item)item)) {
            return false;
        }
        if (item instanceof VampireKnives) {
            player.m_36335_().m_41524_((Item)item, 5);
            return true;
        }
        int cooldownTicks = (int)(20.0 / player.m_21133_(Attributes.f_22283_));
        if ((player.m_21205_().m_41720_() instanceof BrutalityThrowingItem || player.m_21206_().m_41720_() instanceof BrutalityThrowingItem) && player.m_21205_().m_41720_() == player.m_21206_().m_41720_()) {
            cooldownTicks /= 2;
        }
        player.m_36335_().m_41524_((Item)item, cooldownTicks);
        return true;
    }

    public static void handleAttributesAndAnimation(Player player, BrutalityThrowingItem throwingItem, ItemStack stack, boolean isOffhand) {
        ResourceLocation animationLocation = throwingItem.getAnimationResourceLocation();
        if (isOffhand) {
            ThrowableWeaponHelper.offhandAttributes(player, () -> {
                ThrowableWeaponHelper.handleCooldownAndSound(player, stack, throwingItem);
                ThrowableWeaponHelper.playThrowAnimation(player, animationLocation, true);
            });
        } else {
            ThrowableWeaponHelper.handleCooldownAndSound(player, stack, throwingItem);
            ThrowableWeaponHelper.playThrowAnimation(player, animationLocation, false);
        }
    }

    public static void playThrowAnimation(Player player, ResourceLocation animationLocation, boolean offHand) {
        float speed = 1.0f;
        KeyframeAnimation keyframeAnimation = PlayerAnimationRegistry.getAnimation((ResourceLocation)animationLocation);
        if (keyframeAnimation != null) {
            float attackSpeed = (float)player.m_21133_(Attributes.f_22283_);
            float animationLength = new KeyframeAnimationPlayer(keyframeAnimation).getData().getLength();
            float targetDurationTicks = 20.0f / attackSpeed;
            speed = animationLength / targetDurationTicks;
        }
        AnimationHelper.playAnimation(player, animationLocation, offHand, speed);
        PacketHandler.sendToServer(new ClientboundPlayerAnimationPacket(player.m_20148_(), animationLocation, offHand, speed));
    }

    public static void handleCooldownAndSound(Player player, ItemStack stack, BrutalityThrowingItem throwingItem) {
        if (ThrowableWeaponHelper.handleCooldown(player, throwingItem)) {
            ThrowableWeaponHelper.playThrowSound(player);
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                DelayedTaskScheduler.queueServerWork((Level)serverLevel, 6, () -> throwingItem.handleThrowPacket(stack, player));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void offhandAttributes(Player player, Runnable runnable) {
        Object object = attributesLock;
        synchronized (object) {
            ThrowableWeaponHelper.setAttributesForOffHandAttack(player, true);
            runnable.run();
            ThrowableWeaponHelper.setAttributesForOffHandAttack(player, false);
        }
    }

    private static void playThrowSound(Player player) {
        player.m_5496_((SoundEvent)BrutalityModSounds.THROW.get(), 2.0f, Mth.m_216283_((RandomSource)player.m_217043_(), (float)0.8f, (float)1.2f));
    }

    private static void setAttributesForOffHandAttack(Player player, boolean useOffHand) {
        ItemStack add;
        ItemStack remove;
        ItemStack mainHandStack = player.m_21205_();
        ItemStack offHandStack = player.m_21206_();
        if (useOffHand) {
            remove = mainHandStack;
            add = offHandStack;
        } else {
            remove = offHandStack;
            add = mainHandStack;
        }
        player.m_21204_().m_22161_(remove.m_41638_(EquipmentSlot.MAINHAND));
        player.m_21204_().m_22178_(add.m_41638_(EquipmentSlot.MAINHAND));
    }
}

