/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.util.helpers;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.goo.brutality.Brutality;
import net.goo.brutality.item.BrutalityCategories;

public final class SafeCategoryHelper {
    private static final Map<Class<?>, String> CATEGORY_CACHE = new ConcurrentHashMap();

    private SafeCategoryHelper() {
    }

    public static String getSafeCategoryString(Object item) {
        if (item == null) {
            return "generic";
        }
        String cached = CATEGORY_CACHE.get(item.getClass());
        if (cached != null) {
            return cached;
        }
        try {
            Method method = item.getClass().getMethod("category", new Class[0]);
            Object category = method.invoke(item, new Object[0]);
            if (category instanceof BrutalityCategories) {
                String result = category.toString().toLowerCase(Locale.ROOT);
                CATEGORY_CACHE.put(item.getClass(), result);
                return result;
            }
        }
        catch (Exception e) {
            Brutality.LOGGER.error("Failed to get category for {}: {}", (Object)item.getClass().getSimpleName(), (Object)e.getMessage());
        }
        String fallback = "generic";
        CATEGORY_CACHE.put(item.getClass(), fallback);
        return fallback;
    }

    public static void preloadCategories() {
        try {
            Class<?> itemTypeClass = Class.forName("net.goo.brutality.item.BrutalityCategories$ItemType");
            Object[] itemTypeValues = (Object[])itemTypeClass.getMethod("values", new Class[0]).invoke(null, new Object[0]);
            Class<?> attackTypeClass = Class.forName("net.goo.brutality.item.BrutalityCategories$AttackType");
            Object[] attackTypeValues = (Object[])attackTypeClass.getMethod("values", new Class[0]).invoke(null, new Object[0]);
            Class<?> curioTypeClass = Class.forName("net.goo.brutality.item.BrutalityCategories$CurioType");
            Object[] curioTypeValues = (Object[])curioTypeClass.getMethod("values", new Class[0]).invoke(null, new Object[0]);
            Brutality.LOGGER.info("[Brutality] Categories preloaded successfully: {} item types, {} attack types, {} curio types", new Object[]{itemTypeValues.length, attackTypeValues.length, curioTypeValues.length});
        }
        catch (Exception e) {
            Brutality.LOGGER.error("[Brutality] CRITICAL: Failed to preload BrutalityCategories!");
            e.printStackTrace();
            throw new RuntimeException("Category preloading failed", e);
        }
    }
}

