/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.util.helpers;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class NbtHelper {
    public static final int TAG_INT = 3;
    public static final int TAG_BYTE = 1;
    public static final int TAG_STRING = 8;

    public static boolean hasKey(ItemStack stack, String key, int type) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128425_(key, type);
    }

    public static int getInt(ItemStack stack, String key, int defVal) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128425_(key, 3) ? tag.m_128451_(key) : defVal;
    }

    public static boolean getBool(ItemStack stack, String key, boolean defVal) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128425_(key, 1) ? tag.m_128471_(key) : defVal;
    }

    public static String getString(ItemStack stack, String key, String defVal) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128425_(key, 8) ? tag.m_128461_(key) : defVal;
    }

    public static void setInt(ItemStack stack, String key, int value, int defVal) {
        if (value == defVal) {
            NbtHelper.removeKeyAndMaybeClear(stack, key);
        } else {
            stack.m_41784_().m_128405_(key, value);
        }
    }

    public static void setBool(ItemStack stack, String key, boolean value, boolean defVal) {
        if (value == defVal) {
            NbtHelper.removeKeyAndMaybeClear(stack, key);
        } else {
            stack.m_41784_().m_128379_(key, value);
        }
    }

    public static void setString(ItemStack stack, String key, String value, String defVal) {
        if (Objects.equals(value, defVal)) {
            NbtHelper.removeKeyAndMaybeClear(stack, key);
        } else {
            stack.m_41784_().m_128359_(key, value);
        }
    }

    public static void removeKeyAndMaybeClear(ItemStack stack, String key) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        tag.m_128473_(key);
        if (tag.m_128456_()) {
            stack.m_41751_(null);
        }
    }

    public static void stripEmptyTag(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128456_()) {
            stack.m_41751_(null);
        }
    }
}

