/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.util.helpers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.util.FastColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Vector3f;

@Mod.EventBusSubscriber(modid="brutality", value={Dist.CLIENT})
public class EnvironmentColorManager {
    private static final EnumMap<ColorType, Integer> COLOR_OVERRIDES = new EnumMap(ColorType.class);
    private static final Vector3f skyLightColor;
    private static boolean customSkyLight;
    private static final EnumMap<ColorType, Integer> lastApplied;
    public static final Map<Object, EnumMap<ColorType, Integer>> activeColorSources;

    public static void setColor(ColorType type, int rgbColor) {
        int clampedColor = rgbColor & 0xFFFFFF;
        if (!Integer.valueOf(clampedColor).equals(COLOR_OVERRIDES.get((Object)type))) {
            COLOR_OVERRIDES.put(type, clampedColor);
            if (type.requiresReload) {
                Minecraft minecraft = Minecraft.m_91087_();
                minecraft.execute(() -> ((LevelRenderer)minecraft.f_91060_).m_109818_());
            }
            if (type == ColorType.WATER_FOG) {
                FogRenderer.f_109015_ = -1L;
            }
        }
    }

    public static void setColor(ColorType type, int[] rgb) {
        int rgbColor = FastColor.ARGB32.m_13660_((int)255, (int)rgb[0], (int)rgb[1], (int)rgb[2]);
        int clampedColor = rgbColor & 0xFFFFFF;
        if (!Integer.valueOf(clampedColor).equals(COLOR_OVERRIDES.get((Object)type))) {
            COLOR_OVERRIDES.put(type, clampedColor);
            if (type.requiresReload) {
                Minecraft minecraft = Minecraft.m_91087_();
                minecraft.execute(() -> ((LevelRenderer)minecraft.f_91060_).m_109818_());
            }
            if (type == ColorType.WATER_FOG) {
                FogRenderer.f_109015_ = -1L;
            }
        }
    }

    public static void resetColor(ColorType type) {
        if (COLOR_OVERRIDES.get((Object)type) != null) {
            COLOR_OVERRIDES.put(type, null);
            if (type.requiresReload) {
                Minecraft minecraft = Minecraft.m_91087_();
                minecraft.execute(() -> ((LevelRenderer)minecraft.f_91060_).m_109818_());
            }
        }
    }

    public static void resetAllColors() {
        boolean needsReload = COLOR_OVERRIDES.entrySet().stream().filter(entry -> entry.getValue() != null).peek(entry -> entry.setValue(null)).anyMatch(entry -> ((ColorType)((Object)((Object)entry.getKey()))).requiresReload);
        if (needsReload) {
            Minecraft minecraft = Minecraft.m_91087_();
            minecraft.execute(() -> ((LevelRenderer)minecraft.f_91060_).m_109818_());
        }
    }

    public static Integer getColorOverride(ColorType type) {
        return COLOR_OVERRIDES.get((Object)type);
    }

    public static void setCustomSkyLight(float r, float g, float b) {
        skyLightColor.set(r, g, b);
        customSkyLight = true;
    }

    public static void setCustomSkyLight(int[] color) {
        skyLightColor.set((float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f);
        customSkyLight = true;
    }

    public static void resetCustomSkyLight() {
        customSkyLight = false;
    }

    @SubscribeEvent
    public static void onRenderSky(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY && customSkyLight) {
            RenderSystem.setShader(GameRenderer::m_172811_);
            RenderSystem.setShaderColor((float)skyLightColor.x(), (float)skyLightColor.y(), (float)skyLightColor.z(), (float)1.0f);
            BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
            buffer.m_5483_(-100.0, -100.0, -100.0).m_5752_();
            buffer.m_5483_(-100.0, 100.0, -100.0).m_5752_();
            buffer.m_5483_(100.0, 100.0, -100.0).m_5752_();
            buffer.m_5483_(100.0, -100.0, -100.0).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
            RenderSystem.setShader(() -> {
                ShaderInstance shader = GameRenderer.m_172679_();
                shader.m_173356_("Brightness").m_5985_(-0.5f);
                return shader;
            });
        }
    }

    public static void apply(Object source, boolean inRange, ProximityColorSet colors) {
        EnumMap<ColorType, Integer> newColors = new EnumMap<ColorType, Integer>(ColorType.class);
        for (ColorType type : ColorType.values()) {
            if (inRange && colors.inRangeColors.containsKey((Object)type)) {
                newColors.put(type, colors.inRangeColors.get((Object)type));
                continue;
            }
            if (inRange) continue;
            if (colors.shouldReset.getOrDefault((Object)type, false).booleanValue()) {
                newColors.put(type, null);
                continue;
            }
            if (!colors.outOfRangeColors.containsKey((Object)type)) continue;
            newColors.put(type, colors.outOfRangeColors.get((Object)type));
        }
        activeColorSources.put(source, newColors);
    }

    public static void resolveAndApplyColors() {
        EnumMap<ColorType, Integer> resolvedColors = new EnumMap<ColorType, Integer>(ColorType.class);
        for (ColorType type : ColorType.values()) {
            Integer current;
            Integer resolved;
            for (EnumMap<ColorType, Integer> entry : activeColorSources.values()) {
                Integer color = entry.get((Object)type);
                if (color == null) continue;
                resolvedColors.put(type, color);
                break;
            }
            if (Objects.equals(resolved = (Integer)resolvedColors.get((Object)type), current = lastApplied.get((Object)type))) continue;
            if (resolved == null) {
                EnvironmentColorManager.resetColor(type);
            } else {
                EnvironmentColorManager.setColor(type, resolved);
            }
            lastApplied.put(type, resolved);
        }
    }

    static {
        for (ColorType type : ColorType.values()) {
            COLOR_OVERRIDES.put(type, null);
        }
        skyLightColor = new Vector3f(0.5f, 0.7f, 1.0f);
        customSkyLight = false;
        lastApplied = new EnumMap(ColorType.class);
        for (ColorType type : ColorType.values()) {
            lastApplied.put(type, null);
        }
        activeColorSources = new HashMap<Object, EnumMap<ColorType, Integer>>();
    }

    public static enum ColorType {
        FOG(false),
        WATER(true),
        WATER_FOG(false),
        SKY(false),
        FOLIAGE(true),
        GRASS(true);

        public final boolean requiresReload;

        private ColorType(boolean requiresReload) {
            this.requiresReload = requiresReload;
        }
    }

    public static class ProximityColorSet {
        public final EnumMap<ColorType, Integer> inRangeColors = new EnumMap(ColorType.class);
        public final EnumMap<ColorType, Integer> outOfRangeColors = new EnumMap(ColorType.class);
        public final EnumMap<ColorType, Boolean> shouldReset = new EnumMap(ColorType.class);

        public ProximityColorSet setColor(ColorType type, int inRangeColor, int outOfRangeColor) {
            this.inRangeColors.put(type, inRangeColor);
            this.outOfRangeColors.put(type, outOfRangeColor);
            this.shouldReset.put(type, false);
            return this;
        }

        public ProximityColorSet setColorAutoReset(ColorType type, int inRangeColor) {
            this.inRangeColors.put(type, inRangeColor);
            this.shouldReset.put(type, true);
            return this;
        }
    }
}

