/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.util.helpers;

import net.goo.brutality.registry.ModRarities;
import net.goo.brutality.util.ColorUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class BrutalityTooltipHelper {
    private static final int WHITE = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);

    public static Component getRarityName(String translationKey, Rarity rarity) {
        assert (Minecraft.m_91087_().f_91074_ != null);
        ModRarities.RarityData rarityData = ModRarities.getGradientForRarity(rarity);
        if (rarityData == null) {
            return BrutalityTooltipHelper.tooltipHelper(translationKey, false, null, Float.valueOf(1.0f), Float.valueOf(1.0f), WHITE);
        }
        return BrutalityTooltipHelper.tooltipHelper(translationKey, rarityData.bold, null, Float.valueOf(rarityData.waveSpeed), Float.valueOf(rarityData.spread), rarityData.colors);
    }

    public static Component tooltipHelper(String localeKey, boolean bold, ResourceLocation font, Float waveSpeed, Float spreadMultiplier, int ... colors) {
        if (colors.length == 1) {
            return Component.m_237115_((String)localeKey).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(bold)).m_131150_(font).m_131148_(TextColor.m_131266_((int)colors[0])));
        }
        return ColorUtils.addColorGradientText((Component)Component.m_237115_((String)localeKey), colors, waveSpeed.floatValue(), spreadMultiplier.floatValue()).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(bold)));
    }

    public static enum SpellStatComponents {
        RANGE("\ud83d\udccf", " \ud83d\udfeb"),
        SPEED("\u23f2", " \u23f2"),
        SIZE("\ud83d\udcd0", " \ud83d\udfeb"),
        CHANCE("\ud83c\udfb2", "%"),
        QUANTITY("\ud83d\udd22", " \u25fd"),
        PIERCE("\ud83d\udc98", " \ud83e\udddf"),
        DURATION("\ud83d\udd52", "s"),
        DEFENSE("\ud83e\uddba", " \ud83d\udee1"),
        HEALING("\u26e8", " \u2764");

        public final String icon;
        public final String unit;

        private SpellStatComponents(String icon, String unit) {
            this.icon = icon;
            this.unit = unit;
        }
    }

    public record SpellStatComponent(SpellStatComponents type, float base, float levelDelta, Float min, Float max) {
    }

    public static enum ItemDescriptionComponents {
        ACTIVE,
        PASSIVE,
        FULL_SET_PASSIVE,
        FULL_SET_ACTIVE,
        ON_HIT,
        WHEN_THROWN,
        ON_SWING,
        ON_LEFT_CLICKING_ENTITY,
        ON_RIGHT_CLICK,
        ON_SHIFT_RIGHT_CLICK,
        LORE,
        ON_KILL,
        ON_SHOOT,
        ON_HOLD_RIGHT_CLICK,
        CHARM,
        DASH_ABILITY,
        ON_SUCCESSFUL_DODGE,
        MANA_COST;

    }

    public record ItemDescriptionComponent(ItemDescriptionComponents type, int lines, Integer cooldownTicks) {
        public ItemDescriptionComponent(ItemDescriptionComponents type, int lines) {
            this(type, lines, null);
        }
    }
}

