/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.util;

import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FastColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ColorUtils {
    private static final int WHITE = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);

    public static int getCyclingColor(float speed, int ... colors) {
        if (colors.length == 0) {
            return WHITE;
        }
        int tickCount = ColorUtils.getTickCount();
        float t = (float)tickCount * speed % (float)colors.length;
        int index = (int)Math.floor(t);
        float lerpFactor = t - (float)index;
        int colorA = colors[index % colors.length];
        int colorB = colors[(index + 1) % colors.length];
        return FastColor.ARGB32.m_269105_((float)lerpFactor, (int)colorA, (int)colorB);
    }

    public static MutableComponent addColorGradientText(Component text, int[] colors, float speed, float spreadMultiplier) {
        int[] gradientColors;
        MutableComponent gradientText = Component.m_237119_();
        String string = text.getString();
        int length = string.length();
        if (colors.length == 0 || length == 0) {
            return gradientText;
        }
        int[] nArray = gradientColors = colors.length > 1 ? new int[colors.length + 1] : colors;
        if (colors.length > 1) {
            System.arraycopy(colors, 0, gradientColors, 0, colors.length);
            gradientColors[colors.length] = colors[0];
        }
        float ratio = 0.0f;
        if (speed > 0.0f) {
            int tickCount = ColorUtils.getTickCount();
            float inverseSpeed = 1.0f / speed;
            float effectiveTickCount = (float)tickCount % (inverseSpeed * 20.0f);
            ratio = effectiveTickCount / (inverseSpeed * 20.0f);
        }
        float inverseSpread = spreadMultiplier > 0.0f ? 1.0f / spreadMultiplier : 1.0f;
        float effectiveLength = (float)length * inverseSpread;
        for (int i = 0; i < length; ++i) {
            int percentage = speed > 0.0f ? (int)(((float)i * inverseSpread / (float)length + ratio) * effectiveLength % effectiveLength / effectiveLength * 100.0f) : (length > 1 ? i * 100 / (length - 1) : 0);
            int color = ColorUtils.getColorFromGradient(percentage, gradientColors);
            gradientText.m_7220_((Component)Component.m_237113_((String)String.valueOf(string.charAt(i))).m_130948_(Style.f_131099_.m_178520_(color)));
        }
        return gradientText;
    }

    public static MutableComponent addColorGradientText(Component text, int ... colors) {
        return ColorUtils.addColorGradientText(text, colors, 0.0f, 1.0f);
    }

    private static int getColorFromGradient(int percentage, int[] colors) {
        if (colors.length == 1) {
            return colors[0];
        }
        float segment = 100.0f / (float)(colors.length - 1);
        int index = (int)((float)percentage / segment);
        float t = (float)percentage % segment / segment;
        if (index >= colors.length - 1) {
            return colors[colors.length - 1];
        }
        return FastColor.ARGB32.m_269105_((float)t, (int)colors[index], (int)colors[index + 1]);
    }

    private static int getTickCount() {
        Integer clientTicks = (Integer)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Minecraft mc = Minecraft.m_91087_();
            return mc.f_91074_ != null ? mc.f_91074_.f_19797_ : (int)(System.currentTimeMillis() / 50L);
        });
        return clientTicks != null ? clientTicks : (int)(System.currentTimeMillis() / 50L);
    }
}

