/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.particle.base;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.goo.brutality.particle.providers.PointToPointParticleData;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PointToPointParticle
extends TextureSheetParticle {
    protected final SpriteSet sprites;
    protected final float x0;
    protected final float y0;
    protected final float z0;
    protected final float x1;
    protected final float y1;
    protected final float z1;
    protected final float height;

    public PointToPointParticle(ClientLevel level, double x, double y, double z, PointToPointParticleData<?> data, SpriteSet sprites) {
        super(level, x, y, z);
        this.m_172260_(0.0, 0.0, 0.0);
        this.f_107225_ = 20;
        this.sprites = sprites;
        this.x0 = data.x0();
        this.y0 = data.y0();
        this.z0 = data.z0();
        this.x1 = data.x1();
        this.y1 = data.y1();
        this.z1 = data.z1();
        this.height = 1.0f;
        this.m_107264_(this.x0, this.y0, this.z0);
    }

    public boolean shouldCull() {
        return false;
    }

    public void m_5744_(@NotNull VertexConsumer buffer, Camera camera, float partialTicks) {
        Vec3 cameraPos = camera.m_90583_();
        float px0 = (float)((double)this.x0 - cameraPos.m_7096_());
        float py0 = (float)((double)this.y0 - cameraPos.m_7098_());
        float pz0 = (float)((double)this.z0 - cameraPos.m_7094_());
        float px1 = (float)((double)this.x1 - cameraPos.m_7096_());
        float py1 = (float)((double)this.y1 - cameraPos.m_7098_());
        float pz1 = (float)((double)this.z1 - cameraPos.m_7094_());
        Vector3f direction = new Vector3f(px1 - px0, 0.0f, pz1 - pz0).normalize();
        float length = (float)Math.sqrt((px1 - px0) * (px1 - px0) + (pz1 - pz0) * (pz1 - pz0));
        Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f side = direction.cross((Vector3fc)up).normalize().mul(0.001f);
        float u0 = this.m_5970_();
        float u1 = this.m_5952_();
        float v0 = this.m_5951_();
        float v1 = this.m_5950_();
        int light = this.m_6355_(1.0f);
        float segmentLength = 1.0f;
        int segments = (int)Math.ceil(length / segmentLength);
        for (int i = 0; i < segments; ++i) {
            float t0 = (float)i * segmentLength;
            float t1 = Math.min((float)(i + 1) * segmentLength, length);
            float frac0 = t0 / length;
            float frac1 = t1 / length;
            float sx0 = px0 + (px1 - px0) * frac0;
            float sy0 = py0 + (py1 - py0) * frac0;
            float sz0 = pz0 + (pz1 - pz0) * frac0;
            float sx1 = px0 + (px1 - px0) * frac1;
            float sy1 = py0 + (py1 - py0) * frac1;
            float sz1 = pz0 + (pz1 - pz0) * frac1;
            Vector3f[] vertices = new Vector3f[]{new Vector3f(sx0, sy0, sz0).add((Vector3fc)side), new Vector3f(sx0, sy0 + this.height, sz0).add((Vector3fc)side), new Vector3f(sx1, sy1, sz1).add((Vector3fc)side), new Vector3f(sx1, sy1 + this.height, sz1).add((Vector3fc)side)};
            buffer.m_5483_((double)vertices[0].x(), (double)vertices[0].y(), (double)vertices[0].z()).m_7421_(u0, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
            buffer.m_5483_((double)vertices[1].x(), (double)vertices[1].y(), (double)vertices[1].z()).m_7421_(u0, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
            buffer.m_5483_((double)vertices[3].x(), (double)vertices[3].y(), (double)vertices[3].z()).m_7421_(u1, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
            buffer.m_5483_((double)vertices[2].x(), (double)vertices[2].y(), (double)vertices[2].z()).m_7421_(u1, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
            buffer.m_5483_((double)vertices[2].x(), (double)vertices[2].y(), (double)vertices[2].z()).m_7421_(u1, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
            buffer.m_5483_((double)vertices[3].x(), (double)vertices[3].y(), (double)vertices[3].z()).m_7421_(u1, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
            buffer.m_5483_((double)vertices[1].x(), (double)vertices[1].y(), (double)vertices[1].z()).m_7421_(u0, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
            buffer.m_5483_((double)vertices[0].x(), (double)vertices[0].y(), (double)vertices[0].z()).m_7421_(u0, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        }
    }

    public void m_5989_() {
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.m_108339_(this.sprites);
        }
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    protected int m_6355_(float partialTick) {
        return 0xF000F0;
    }
}

