/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.particle.base;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.goo.brutality.particle.providers.FlatParticleData;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FlatParticle
extends TextureSheetParticle {
    protected SpriteSet sprites;
    protected static final Quaternionf QUATERNION = new Quaternionf(0.0f, -0.7f, 0.7f, 0.0f);
    protected final float rotX;
    protected final float rotY;
    protected final float rotZ;
    protected final float xOffset;
    protected final float yOffset;
    protected final float zOffset;
    protected final Entity relatedEntity;

    public FlatParticle(ClientLevel level, double x, double y, double z, FlatParticleData<?> data, SpriteSet sprites) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.m_172260_(0.0, 0.0, 0.0);
        this.f_107225_ = 20;
        this.sprites = sprites;
        this.rotX = data.rotX();
        this.rotY = data.rotY();
        this.rotZ = data.rotZ();
        this.xOffset = data.xOffset();
        this.yOffset = data.yOffset();
        this.zOffset = data.zOffset();
        this.f_107663_ = data.radius();
        this.relatedEntity = data.entityID() != null ? level.m_6815_(data.entityID().intValue()) : null;
        this.m_108339_(sprites);
    }

    public boolean shouldCull() {
        return false;
    }

    public void m_5744_(@NotNull VertexConsumer buffer, Camera camera, float partialTicks) {
        Vec3 cameraPos = camera.m_90583_();
        float x = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - cameraPos.m_7096_());
        float y = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - cameraPos.m_7098_());
        float z = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - cameraPos.m_7094_());
        Quaternionf pitchRot = new Quaternionf().rotationX((float)((double)this.rotX * (Math.PI / 180)));
        Quaternionf yawRot = new Quaternionf().rotationY((float)((double)this.rotY * (Math.PI / 180)));
        Quaternionf rollRot = new Quaternionf().rotationZ((float)((double)this.rotZ * (Math.PI / 180)));
        Quaternionf combinedRot = new Quaternionf();
        combinedRot.mul((Quaternionfc)yawRot).mul((Quaternionfc)pitchRot).mul((Quaternionfc)rollRot).mul((Quaternionfc)QUATERNION);
        Vector3f[] baseVertices = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float size = this.m_5902_(partialTicks);
        Vector3f[] transformedVertices = new Vector3f[4];
        for (int i = 0; i < 4; ++i) {
            transformedVertices[i] = new Vector3f((Vector3fc)baseVertices[i]);
            transformedVertices[i].rotate((Quaternionfc)combinedRot);
            transformedVertices[i].mul(size);
            transformedVertices[i].add(x, y, z);
        }
        float u0 = this.m_5970_();
        float u1 = this.m_5952_();
        float v0 = this.m_5951_();
        float v1 = this.m_5950_();
        int light = this.m_6355_(partialTicks);
        buffer.m_5483_((double)transformedVertices[0].x(), (double)transformedVertices[0].y(), (double)transformedVertices[0].z()).m_7421_(u1, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)transformedVertices[1].x(), (double)transformedVertices[1].y(), (double)transformedVertices[1].z()).m_7421_(u1, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)transformedVertices[2].x(), (double)transformedVertices[2].y(), (double)transformedVertices[2].z()).m_7421_(u0, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)transformedVertices[3].x(), (double)transformedVertices[3].y(), (double)transformedVertices[3].z()).m_7421_(u0, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)transformedVertices[3].x(), (double)transformedVertices[3].y(), (double)transformedVertices[3].z()).m_7421_(u0, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)transformedVertices[2].x(), (double)transformedVertices[2].y(), (double)transformedVertices[2].z()).m_7421_(u0, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)transformedVertices[1].x(), (double)transformedVertices[1].y(), (double)transformedVertices[1].z()).m_7421_(u1, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)transformedVertices[0].x(), (double)transformedVertices[0].y(), (double)transformedVertices[0].z()).m_7421_(u1, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
    }

    public void m_5989_() {
        super.m_5989_();
        this.m_108339_(this.sprites);
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    protected int m_6355_(float pPartialTick) {
        return 0xF000F0;
    }
}

