/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundSetHealthPacket {
    private final int entityId;
    private final float health;

    public ServerboundSetHealthPacket(int entityId, float health) {
        this.entityId = entityId;
        this.health = health;
    }

    public ServerboundSetHealthPacket(FriendlyByteBuf buf) {
        this.entityId = buf.m_130242_();
        this.health = buf.readFloat();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.entityId);
        buf.writeFloat(this.health);
    }

    public static void handle(ServerboundSetHealthPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            ServerLevel level = sender.m_284548_();
            Entity target = level.m_6815_(packet.entityId);
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                if (target.m_6084_()) {
                    livingTarget.m_21153_(packet.health);
                }
            }
        });
        context.setPacketHandled(true);
    }
}

