/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.network;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundChangeNBTPacket {
    private final CompoundTag modifications;
    private final boolean isMainHand;

    public ServerboundChangeNBTPacket(CompoundTag modifications, boolean isMainHand) {
        this.modifications = modifications;
        this.isMainHand = isMainHand;
    }

    public ServerboundChangeNBTPacket(FriendlyByteBuf buf) {
        this.modifications = buf.m_130260_();
        this.isMainHand = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130079_(this.modifications);
        buf.writeBoolean(this.isMainHand);
    }

    public static void handle(ServerboundChangeNBTPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender == null) {
                return;
            }
            ItemStack stack = packet.isMainHand ? sender.m_21205_() : sender.m_21206_();
            CompoundTag tag = stack.m_41784_();
            for (String key : packet.modifications.m_128431_()) {
                tag.m_128365_(key, Objects.requireNonNull(packet.modifications.m_128423_(key)));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

