/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.network;

import java.util.function.Supplier;
import net.goo.brutality.item.base.BrutalityThrowingItem;
import net.goo.brutality.item.weapon.hammer.AtomicJudgementHammer;
import net.goo.brutality.item.weapon.spear.RhongomyniadSpear;
import net.goo.brutality.item.weapon.sword.ChallengerDeepSword;
import net.goo.brutality.item.weapon.sword.CrimsonScissorBlade;
import net.goo.brutality.item.weapon.sword.ExobladeSword;
import net.goo.brutality.item.weapon.sword.MarianasTrenchSword;
import net.goo.brutality.item.weapon.sword.SeventhStarSword;
import net.goo.brutality.item.weapon.sword.ShadowflameScissorBlade;
import net.goo.brutality.item.weapon.sword.SupernovaSword;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import software.bernie.geckolib.animatable.GeoItem;

public class ServerboundBetterCombatAttackStartListenerPacket {
    private final ItemStack stack;
    private final int combo;

    public ServerboundBetterCombatAttackStartListenerPacket(ItemStack stack, int combo) {
        this.stack = stack;
        this.combo = combo;
    }

    public ServerboundBetterCombatAttackStartListenerPacket(FriendlyByteBuf buf) {
        this.stack = buf.m_130267_();
        this.combo = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130055_(this.stack);
        buf.writeInt(this.combo);
    }

    public static void handle(ServerboundBetterCombatAttackStartListenerPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            ServerLevel serverLevel = player.m_284548_();
            ItemStack stack = packet.stack;
            Item item = stack.m_41720_();
            int combo = packet.combo;
            if (item instanceof ExobladeSword) {
                ExobladeSword exobladeSword = (ExobladeSword)item;
                exobladeSword.performExobladeBeam(stack, (Player)player);
            } else if (item instanceof SeventhStarSword) {
                SeventhStarSword seventhStarSword = (SeventhStarSword)item;
                seventhStarSword.shootTriStar((Player)player);
            } else if (item instanceof MarianasTrenchSword) {
                MarianasTrenchSword marianasTrenchSword = (MarianasTrenchSword)item;
                marianasTrenchSword.performMarianasTrenchAttack(stack, (Player)player);
            } else if (item instanceof ChallengerDeepSword) {
                ChallengerDeepSword challengerDeepSword = (ChallengerDeepSword)item;
                challengerDeepSword.performChallengerDeepAttack(stack, (Player)player);
            } else if (item instanceof SupernovaSword) {
                SupernovaSword supernovaSword = (SupernovaSword)item;
                if (combo == 2) {
                    supernovaSword.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "controller", "stab");
                } else {
                    supernovaSword.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "controller", "swing");
                }
            } else if (item instanceof AtomicJudgementHammer) {
                AtomicJudgementHammer atomicJudgementHammer = (AtomicJudgementHammer)item;
                atomicJudgementHammer.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "controller", "attack");
            } else if (item instanceof BrutalityThrowingItem) {
                BrutalityThrowingItem throwingItem = (BrutalityThrowingItem)item;
                throwingItem.handleCooldownAndSound((Player)player, stack);
            } else if (item instanceof CrimsonScissorBlade) {
                CrimsonScissorBlade crimsonScissorBlade = (CrimsonScissorBlade)item;
                crimsonScissorBlade.performBloodSlash((Player)player);
            } else if (item instanceof ShadowflameScissorBlade) {
                ShadowflameScissorBlade shadowflameScissorBlade = (ShadowflameScissorBlade)item;
                shadowflameScissorBlade.performShadowflameSlash((Player)player, stack);
            } else if (item instanceof RhongomyniadSpear) {
                RhongomyniadSpear rhongomyniadSpear = (RhongomyniadSpear)item;
                rhongomyniadSpear.performRayAttack((Player)player);
            }
        });
        context.setPacketHandled(true);
    }
}

