/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.goo.brutality.client.ClientAccess;
import net.goo.brutality.registry.BrutalityCapabilities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundSyncCapabilitiesPacket {
    private final int entityId;
    private final Map<String, CompoundTag> data;

    public ClientboundSyncCapabilitiesPacket(int entityId, Entity entity) {
        this.entityId = entityId;
        this.data = new HashMap<String, CompoundTag>();
        for (Map.Entry<String, Capability<? extends INBTSerializable<CompoundTag>>> entry : BrutalityCapabilities.CapabilitySyncRegistry.getAll().entrySet()) {
            String key = entry.getKey();
            Capability<? extends INBTSerializable<CompoundTag>> cap = entry.getValue();
            entity.getCapability(cap).ifPresent(inst -> {
                CompoundTag tag = (CompoundTag)((INBTSerializable)inst).serializeNBT();
                this.data.put(key, tag);
            });
        }
    }

    public ClientboundSyncCapabilitiesPacket(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        int count = buf.readInt();
        this.data = new HashMap<String, CompoundTag>();
        for (int i = 0; i < count; ++i) {
            String key = buf.m_130277_();
            CompoundTag tag = buf.m_130260_();
            this.data.put(key, tag);
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.data.size());
        this.data.forEach((key, tag) -> {
            buf.m_130070_(key);
            buf.m_130079_(tag);
        });
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                ClientAccess.syncCapabilities(this.entityId, this.data);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

