/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.network;

import java.util.function.Supplier;
import net.goo.brutality.client.ClientAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundDodgePacket {
    public final int entityId;
    public final ResourceLocation damageTypeId;
    public final float amount;
    public final Integer directEntityId;
    public final Integer causingEntityId;
    public final boolean hasDirectEntity;
    public final boolean hasCausingEntity;
    public final ItemStack anklet;

    public ClientboundDodgePacket(int entityId, DamageSource source, float amount, ItemStack anklet) {
        this.entityId = entityId;
        this.damageTypeId = source.m_269150_().m_203543_().map(ResourceKey::m_135782_).orElse(null);
        this.hasDirectEntity = source.m_7640_() != null;
        this.directEntityId = source.m_7640_() != null ? Integer.valueOf(source.m_7640_().m_19879_()) : null;
        this.hasCausingEntity = source.m_7639_() != null;
        this.causingEntityId = source.m_7639_() != null ? Integer.valueOf(source.m_7639_().m_19879_()) : null;
        this.amount = amount;
        this.anklet = anklet;
    }

    public ClientboundDodgePacket(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.damageTypeId = buf.m_130281_();
        this.hasDirectEntity = buf.readBoolean();
        this.directEntityId = this.hasDirectEntity ? Integer.valueOf(buf.readInt()) : null;
        this.hasCausingEntity = buf.readBoolean();
        this.causingEntityId = this.hasCausingEntity ? Integer.valueOf(buf.readInt()) : null;
        this.amount = buf.readFloat();
        this.anklet = buf.m_130267_();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.m_130085_(this.damageTypeId);
        buf.writeBoolean(this.hasDirectEntity);
        if (this.hasDirectEntity) {
            buf.writeInt(this.directEntityId.intValue());
        }
        if (this.hasCausingEntity) {
            buf.writeInt(this.causingEntityId.intValue());
        }
        buf.writeFloat(this.amount);
        buf.m_130055_(this.anklet);
    }

    public static void handle(ClientboundDodgePacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> ClientAccess.handleDodgeClient(packet));
        context.setPacketHandled(true);
    }
}

