/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.network;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.goo.brutality.entity.explosion.BrutalityExplosion;
import net.goo.brutality.util.helpers.ModExplosionHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundBrutalityExplodePacket
extends ClientboundExplodePacket {
    private final String clazz;
    private final boolean spawnParticles;

    public ClientboundBrutalityExplodePacket(double pX, double pY, double pZ, float pPower, List<BlockPos> pToBlow, @Nullable Vec3 pKnockback, boolean spawnParticles, Class<? extends BrutalityExplosion> clazz) {
        super(pX, pY, pZ, pPower, pToBlow, pKnockback);
        this.clazz = clazz.getName();
        this.spawnParticles = spawnParticles;
    }

    public ClientboundBrutalityExplodePacket(FriendlyByteBuf buf) {
        super(buf);
        this.clazz = buf.m_130277_();
        this.spawnParticles = buf.readBoolean();
    }

    public void m_5779_(FriendlyByteBuf buf) {
        super.m_5779_(buf);
        buf.m_130070_(this.clazz);
        buf.writeBoolean(this.spawnParticles);
    }

    public String getClazz() {
        return this.clazz;
    }

    public boolean isSpawnParticles() {
        return this.spawnParticles;
    }

    public static void handle(ClientboundBrutalityExplodePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ModExplosionHelper.Client.handleExplosion(packet));
        ctx.get().setPacketHandled(true);
    }
}

