/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.goo.brutality.item.base.BrutalityThrowingItem;
import net.goo.brutality.item.curios.charm.Cosine;
import net.goo.brutality.item.weapon.axe.RhittaAxe;
import net.goo.brutality.item.weapon.hammer.AtomicJudgementHammer;
import net.goo.brutality.item.weapon.hammer.JackpotHammer;
import net.goo.brutality.item.weapon.hammer.WoodenRulerHammer;
import net.goo.brutality.item.weapon.scythe.DarkinScythe;
import net.goo.brutality.item.weapon.scythe.FallenScythe;
import net.goo.brutality.item.weapon.sword.Amaterasu;
import net.goo.brutality.item.weapon.sword.MetalRulerSword;
import net.goo.brutality.item.weapon.sword.MurasamaSword;
import net.goo.brutality.item.weapon.sword.ShadowstepSword;
import net.goo.brutality.item.weapon.sword.SupernovaSword;
import net.goo.brutality.item.weapon.sword.Tsukuyomi;
import net.goo.brutality.item.weapon.sword.phasesaber.BasePhasesaber;
import net.goo.brutality.magic.SpellCastingHandler;
import net.goo.brutality.mob_effect.gastronomy.IGastronomyEffect;
import net.goo.brutality.registry.BrutalityModItems;
import net.goo.brutality.registry.BrutalityModMobEffects;
import net.goo.brutality.registry.BrutalityModParticles;
import net.goo.brutality.registry.BrutalityModSounds;
import net.goo.brutality.registry.ModAttributes;
import net.goo.brutality.util.ModTags;
import net.goo.brutality.util.ModUtils;
import net.goo.brutality.util.SealUtils;
import net.mcreator.terramity.init.TerramityModMobEffects;
import net.mcreator.terramity.init.TerramityModParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.theillusivec4.curios.api.CuriosApi;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity {
    @Unique
    private static final Map<Class<? extends Item>, Supplier<ParticleOptions>> PARTICLE_SUPPLIERS = Map.of(FallenScythe.class, () -> BrutalityModParticles.SOUL_SWEEP_PARTICLE.get(), ShadowstepSword.class, () -> BrutalityModParticles.SHADOW_SWEEP_PARTICLE.get(), MurasamaSword.class, () -> BrutalityModParticles.MURASAMA_SWEEP_PARTICLE.get(), SupernovaSword.class, () -> BrutalityModParticles.SUPERNOVA_SWEEP_PARTICLE.get());

    protected PlayerMixin(EntityType<? extends LivingEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Unique
    private static Optional<ParticleOptions> brutality$getParticleForItem(Item item) {
        return PARTICLE_SUPPLIERS.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isInstance(item)).findFirst().map(entry -> (ParticleOptions)((Supplier)entry.getValue()).get());
    }

    @Shadow
    public abstract void m_142687_(Entity.RemovalReason var1);

    @Inject(method={"sweepAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void sweepAttackParticle(CallbackInfo ci) {
        Player player = (Player)this;
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            if (player.m_36403_(0.5f) >= 1.0f) {
                double d0 = -Math.sin(Math.toRadians(player.m_146908_())) * 2.0;
                double d1 = Math.cos(Math.toRadians(player.m_146908_())) * 2.0;
                PlayerMixin.brutality$getParticleForItem(player.m_21205_().m_41720_()).ifPresent(particle -> {
                    world.m_8767_(particle, player.m_20185_() + d0, player.m_20227_(0.5), player.m_20189_() + d1, 0, d0, 0.0, d1, 0.0);
                    ci.cancel();
                });
            }
        }
    }

    @ModifyVariable(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getAttackStrengthScale(F)F", shift=At.Shift.BEFORE), ordinal=0)
    private float modifyAttackDamage(float originalDamage) {
        Player player = (Player)this;
        ItemStack stack = player.m_21205_();
        originalDamage -= (float)player.m_21172_(Attributes.f_22281_);
        originalDamage = (float)ModUtils.computeAttributes(player, stack, originalDamage);
        return originalDamage += (float)player.m_21172_(Attributes.f_22281_);
    }

    @Redirect(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"))
    private boolean handleWeaponAttacks(Entity entity, DamageSource pSource, float pAmount) {
        float chance;
        AttributeInstance stunChanceAttr;
        if (!(entity instanceof LivingEntity)) {
            return entity.m_6469_(pSource, pAmount);
        }
        LivingEntity livingVictim = (LivingEntity)entity;
        Player playerAttacker = (Player)pSource.m_7639_();
        if (playerAttacker == null) {
            return entity.m_6469_(pSource, pAmount);
        }
        ItemStack stack = ModUtils.getAttackStack(playerAttacker);
        Item item = stack.m_41720_();
        float[] modifiedAmount = new float[]{pAmount};
        Level level = this.m_9236_();
        AttributeInstance lifestealAttr = playerAttacker.m_21051_((Attribute)ModAttributes.LIFESTEAL.get());
        if (lifestealAttr != null) {
            playerAttacker.m_5634_((float)((double)modifiedAmount[0] * (lifestealAttr.m_22135_() - 1.0)));
        }
        if ((stunChanceAttr = playerAttacker.m_21051_((Attribute)ModAttributes.STUN_CHANCE.get())) != null && (double)(chance = ModUtils.getSyncedSeededRandom((Entity)playerAttacker).nextFloat(0.0f, 1.0f)) < playerAttacker.m_21133_((Attribute)ModAttributes.STUN_CHANCE.get()) - 1.0) {
            livingVictim.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.STUNNED.get(), 1));
        }
        CuriosApi.getCuriosInventory((LivingEntity)playerAttacker).ifPresent(handler -> {
            if (handler.isEquipped((Item)BrutalityModItems.KNUCKLE_WRAPS.get())) {
                ModUtils.modifyEffect((LivingEntity)playerAttacker, (MobEffect)BrutalityModMobEffects.PRECISION.get(), new ModUtils.ModValue(80, true), new ModUtils.ModValue(3, false), null, livingEntity -> livingEntity.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.PRECISION.get(), 80, 0)), null);
            }
            if (handler.isEquipped((Item)BrutalityModItems.MORTAR_AND_PESTLE_CHARM.get()) && item.m_7968_().m_204117_(ModTags.Items.GASTRONOMIST_ITEMS)) {
                livingVictim.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.PULVERIZED.get(), 3, 3, false, true));
            }
            if (handler.isEquipped((Item)BrutalityModItems.MANA_SYRINGE.get())) {
                SpellCastingHandler.addMana(playerAttacker, modifiedAmount[0] * 0.25f);
            }
            handler.findFirstCurio((Item)BrutalityModItems.PLUNDER_CHEST_CHARM.get()).ifPresent(slot -> {
                if (!playerAttacker.m_36335_().m_41519_(slot.stack().m_41720_())) {
                    int chance;
                    int n = chance = playerAttacker.m_21023_(MobEffects.f_19621_) ? 10 + playerAttacker.m_21124_(MobEffects.f_19621_).m_19564_() : 10;
                    if (level.f_46441_.m_216332_(0, 100) <= chance) {
                        Optional randomEffect = livingVictim.m_21220_().stream().filter(effect -> effect.m_19544_().m_19486_()).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
                            if (list.isEmpty()) {
                                return Optional.empty();
                            }
                            return Optional.of((MobEffectInstance)list.get(livingVictim.m_217043_().m_188503_(list.size())));
                        }));
                        randomEffect.ifPresent(effect -> {
                            livingVictim.m_21195_(effect.m_19544_());
                            playerAttacker.m_7292_(effect);
                            playerAttacker.m_5496_((SoundEvent)BrutalityModSounds.TREASURE_CHEST_LOCK.get(), 1.5f, Mth.m_216267_((RandomSource)playerAttacker.m_217043_(), (float)0.8f, (float)1.2f));
                            playerAttacker.m_36335_().m_41524_(slot.stack().m_41720_(), 100);
                        });
                    }
                }
            });
            handler.findFirstCurio((Item)BrutalityModItems.BUTTER_GAUNTLETS.get()).ifPresent(slot -> {
                if (item.m_7968_().m_204117_(ModTags.Items.GASTRONOMIST_ITEMS) && !playerAttacker.m_36335_().m_41519_(slot.stack().m_41720_())) {
                    int chance;
                    int n = chance = playerAttacker.m_21023_(MobEffects.f_19621_) ? 10 + playerAttacker.m_21124_(MobEffects.f_19621_).m_19564_() : 10;
                    if (level.f_46441_.m_216332_(0, 100) <= chance) {
                        livingVictim.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.STUNNED.get(), 4, 0, false, true));
                        playerAttacker.m_36335_().m_41524_(slot.stack().m_41720_(), 60);
                    }
                }
            });
            int[] fridgeMult = new int[]{1};
            handler.findFirstCurio((Item)BrutalityModItems.FRIDGE_CHARM.get()).ifPresent(slot -> {
                fridgeMult[0] = 2;
            });
            handler.findFirstCurio((Item)BrutalityModItems.SMART_FRIDGE_CHARM.get()).ifPresent(slot -> {
                fridgeMult[0] = 3;
            });
            handler.findFirstCurio((Item)BrutalityModItems.SALT_SHAKER_CHARM.get()).ifPresent(slot -> livingVictim.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.SALTED.get(), 60 * fridgeMult[0], 0)));
            handler.findFirstCurio((Item)BrutalityModItems.PEPPER_SHAKER_CHARM.get()).ifPresent(slot -> livingVictim.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.PEPPERED.get(), 60 * fridgeMult[0], 0)));
            handler.findFirstCurio((Item)BrutalityModItems.CHEESE_SAUCE_CHARM.get()).ifPresent(slot -> livingVictim.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.SLICKED.get(), 60 * fridgeMult[0], 0)));
            handler.findFirstCurio((Item)BrutalityModItems.TOMATO_SAUCE_CHARM.get()).ifPresent(slot -> livingVictim.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.SLICKED.get(), 60 * fridgeMult[0], 0)));
            handler.findFirstCurio((Item)BrutalityModItems.SMOKE_STONE.get()).ifPresent(slot -> livingVictim.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.SMOKED.get(), 60 * fridgeMult[0], 0)));
            handler.findFirstCurio((Item)BrutalityModItems.BAMBOO_STEAMER.get()).ifPresent(slot -> livingVictim.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.STEAMED.get(), 60 * fridgeMult[0], 0)));
            handler.findFirstCurio((Item)BrutalityModItems.SUGAR_GLAZE.get()).ifPresent(slot -> livingVictim.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.GLAZED.get(), 60 * fridgeMult[0], 0)));
            handler.findFirstCurio((Item)BrutalityModItems.RAINBOW_SPRINKLES.get()).ifPresent(slot -> livingVictim.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.SPRINKLED.get(), 60 * fridgeMult[0], 0)));
            handler.findFirstCurio((Item)BrutalityModItems.ROCK_CANDY_RING.get()).ifPresent(slot -> livingVictim.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.CANDIED.get(), 60 * fridgeMult[0], 0)));
            handler.findFirstCurio((Item)BrutalityModItems.SEARED_SUGAR_BROOCH.get()).ifPresent(slot -> livingVictim.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.CARAMELIZED.get(), 60 * fridgeMult[0], 0)));
            handler.findFirstCurio((Item)BrutalityModItems.OLIVE_OIL_CHARM.get()).ifPresent(slot -> livingVictim.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.OILED.get(), 60 * fridgeMult[0], 1)));
            handler.findFirstCurio((Item)BrutalityModItems.ZOMBIE_HEART.get()).ifPresent(slot -> livingVictim.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 100, 0)));
            handler.findFirstCurio((Item)BrutalityModItems.SLOTH_CHARM.get()).ifPresent(slot -> {
                livingVictim.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 20, 0));
                livingVictim.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 20, 0));
                livingVictim.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 0));
            });
            handler.findFirstCurio((Item)BrutalityModItems.BRAIN_ROT.get()).ifPresent(slot -> livingVictim.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 80, 0)));
            handler.findFirstCurio((Item)BrutalityModItems.RAGE_STONE.get()).ifPresent(slot -> {
                modifiedAmount[0] = modifiedAmount[0] * 1.3f;
            });
            handler.findFirstCurio((Item)BrutalityModItems.BLOOD_STONE.get()).ifPresent(slot -> {
                modifiedAmount[0] = modifiedAmount[0] * 1.3f;
                playerAttacker.m_7292_(new MobEffectInstance((MobEffect)TerramityModMobEffects.LIFESTEAL.get(), 30, 0));
            });
            handler.findFirstCurio((Item)BrutalityModItems.VAMPIRIC_TALISMAN.get()).ifPresent(slot -> {
                if (!playerAttacker.m_36335_().m_41519_(slot.stack().m_41720_())) {
                    playerAttacker.m_5634_(modifiedAmount[0] * 0.5f);
                    playerAttacker.m_36335_().m_41524_(slot.stack().m_41720_(), 80);
                }
            });
        });
        if (stack.m_204117_(ModTags.Items.GASTRONOMIST_ITEMS)) {
            float scoredBoost = 0.0f;
            float mashedBoost = 0.0f;
            if (livingVictim.m_21023_((MobEffect)BrutalityModMobEffects.SCORED.get())) {
                scoredBoost = 0.15f * (float)Objects.requireNonNull(livingVictim.m_21124_((MobEffect)BrutalityModMobEffects.SCORED.get())).m_19564_();
            }
            if (livingVictim.m_21023_((MobEffect)BrutalityModMobEffects.MASHED.get())) {
                mashedBoost = 0.15f * (float)Objects.requireNonNull(livingVictim.m_21124_((MobEffect)BrutalityModMobEffects.MASHED.get())).m_19564_();
            }
            float scoredMultiplier = 1.05f + scoredBoost;
            float mashedMultiplier = 1.05f + mashedBoost;
            for (MobEffectInstance instance : livingVictim.m_21220_()) {
                MobEffect effect = instance.m_19544_();
                if (!(effect instanceof IGastronomyEffect)) continue;
                IGastronomyEffect gastro = (IGastronomyEffect)effect;
                if (gastro.modifiesDamage()) {
                    float scale = gastro.baseMultiplier();
                    if (gastro.scalesWithLevel()) {
                        scale *= 1.0f + gastro.multiplierPerLevel() * (float)(instance.m_19564_() + 1);
                    }
                    float typeMultiplier = 1.0f;
                    switch (gastro.getType()) {
                        case DRY: {
                            typeMultiplier = scoredMultiplier;
                            break;
                        }
                        case WET: {
                            typeMultiplier = mashedMultiplier;
                            break;
                        }
                        case BOTH: {
                            typeMultiplier = (scoredMultiplier + mashedMultiplier) / 2.0f;
                        }
                    }
                    modifiedAmount[0] = modifiedAmount[0] * (1.0f + scale * typeMultiplier);
                }
                gastro.applyEffect((LivingEntity)playerAttacker, livingVictim, instance.m_19564_());
            }
        }
        if (item instanceof ShadowstepSword) {
            if (ModUtils.isPlayerBehind(playerAttacker, (Entity)livingVictim, 30)) {
                modifiedAmount[0] = modifiedAmount[0] * 7.0f;
            }
        } else {
            if (item instanceof BasePhasesaber) {
                return livingVictim.m_6469_(this.m_269291_().m_269104_((Entity)playerAttacker, (Entity)playerAttacker), modifiedAmount[0]);
            }
            if (item instanceof RhittaAxe) {
                modifiedAmount[0] = modifiedAmount[0] + RhittaAxe.computeAttackDamageBonus(level);
            } else if (item instanceof JackpotHammer) {
                modifiedAmount[0] = modifiedAmount[0] + (float)level.f_46441_.m_216339_(-5, 11);
                this.brutality$handleJackpotEffects(playerAttacker, livingVictim, modifiedAmount[0]);
            } else if (item instanceof WoodenRulerHammer || item instanceof MetalRulerSword) {
                modifiedAmount[0] = modifiedAmount[0] * (livingVictim.m_20206_() * 0.75f);
            } else if (item instanceof MurasamaSword) {
                livingVictim.f_19802_ = 0;
                modifiedAmount[0] = modifiedAmount[0] / 2.0f;
                livingVictim.m_6469_(playerAttacker.m_269291_().m_269104_((Entity)playerAttacker, null), modifiedAmount[0]);
                livingVictim.f_19802_ = 0;
            } else if (item instanceof DarkinScythe) {
                if (ModUtils.getTextureIdx(stack) == 1) {
                    livingVictim.f_19802_ = 0;
                    float magicDamage = modifiedAmount[0] / 4.0f;
                    livingVictim.m_6469_(playerAttacker.m_269291_().m_269104_((Entity)playerAttacker, null), magicDamage);
                } else if (ModUtils.getTextureIdx(stack) == 2) {
                    playerAttacker.m_5634_(modifiedAmount[0] * 0.2f);
                }
            } else if (item instanceof AtomicJudgementHammer) {
                AtomicJudgementHammer.doExplosion(playerAttacker, livingVictim.m_20318_(1.0f).m_82520_(0.0, (double)(livingVictim.m_20206_() / 2.0f), 0.0));
            } else if (item instanceof Tsukuyomi) {
                if (livingVictim.m_21023_(MobEffects.f_19619_)) {
                    modifiedAmount[0] = modifiedAmount[0] * 2.0f;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)BrutalityModParticles.YANG_PARTICLE.get()), entity.m_20185_(), entity.m_20227_(0.5), entity.m_20189_(), 10, 1.0, 1.0, 1.0, 0.15);
                    }
                }
            } else if (item instanceof Amaterasu && livingVictim.m_21023_(MobEffects.f_216964_)) {
                modifiedAmount[0] = modifiedAmount[0] * 2.0f;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)BrutalityModParticles.YIN_PARTICLE.get()), entity.m_20185_(), entity.m_20227_(0.5), entity.m_20189_(), 10, 1.0, 1.0, 1.0, 0.15);
                }
            }
        }
        SealUtils.handleSealProc(level, (LivingEntity)playerAttacker, livingVictim.m_20318_(1.0f).m_82520_(0.0, (double)(livingVictim.m_20206_() * 0.5f), 0.0), stack);
        return livingVictim.m_6469_(pSource, modifiedAmount[0]);
    }

    @Unique
    private void brutality$handleJackpotEffects(Player player, LivingEntity target, float damage) {
        Level level = player.m_9236_();
        if (damage > 8.0f) {
            int msgPicker = level.f_46441_.m_188503_(3);
            String[] messages = new String[]{"\u00a7a\u00a7l\u00a7oCHA-CHING! \u00a7r", "\u00a7b\u00a7l\u00a7oHUGE WIN! \u00a7r", "\u00a7c\u00a7l\u00a7oJACKPOT! \u00a7r"};
            player.m_5661_((Component)Component.m_237113_((String)(messages[msgPicker] + damage + " damage")), true);
            level.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), ModUtils.getRandomSound(BrutalityModSounds.JACKPOT_SOUNDS), SoundSource.PLAYERS, 1.0f, Mth.m_216267_((RandomSource)level.f_46441_, (float)0.5f, (float)1.0f));
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                List<SimpleParticleType> particleTypes = List.of((SimpleParticleType)TerramityModParticleTypes.COIN_DISPENSED.get(), (SimpleParticleType)TerramityModParticleTypes.POKER_BLUE.get(), (SimpleParticleType)TerramityModParticleTypes.POKER_BLACK.get(), (SimpleParticleType)TerramityModParticleTypes.POKER_GREEN.get(), (SimpleParticleType)TerramityModParticleTypes.POKER_RED.get(), (SimpleParticleType)TerramityModParticleTypes.POKER_YELLOW.get(), (SimpleParticleType)TerramityModParticleTypes.DICE_PARTICLE.get());
                for (SimpleParticleType particle : particleTypes) {
                    serverLevel.m_8767_((ParticleOptions)particle, target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_(), 10, 0.5, 0.5, 0.5, (double)level.f_46441_.m_188501_());
                }
            }
        } else {
            player.m_5661_((Component)Component.m_237113_((String)(damage + " damage")), true);
        }
    }

    @ModifyReturnValue(method={"getCurrentItemAttackStrengthDelay"}, at={@At(value="RETURN")})
    private float modifyAttackSpeed(float originalDelay) {
        Player player = (Player)this;
        if (player.m_21055_((Item)BrutalityModItems.VAMPIRE_KNIVES.get())) {
            return 5.0f;
        }
        float modifiedDelay = originalDelay;
        if (CuriosApi.getCuriosInventory((LivingEntity)player).map(handler -> handler.findFirstCurio((Item)BrutalityModItems.COSINE_CHARM.get()).isPresent()).orElse(false).booleanValue()) {
            float bonus = Cosine.getCurrentBonus(player.m_9236_());
            modifiedDelay /= 1.0f + bonus;
        }
        if ((player.m_21205_().m_41720_() instanceof BrutalityThrowingItem || player.m_21206_().m_41720_() instanceof BrutalityThrowingItem) && player.m_21205_().m_41720_() == player.m_21206_().m_41720_()) {
            modifiedDelay /= 2.0f;
        }
        return modifiedDelay;
    }
}

