/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.mixin;

import net.goo.brutality.client.renderers.layers.EnragedOverlayLayer;
import net.goo.brutality.client.renderers.layers.EyeOfViolenceLayer;
import net.goo.brutality.client.renderers.layers.LightBoundLayer;
import net.goo.brutality.client.renderers.layers.StarLayer;
import net.goo.brutality.client.renderers.layers.StickyBombLayer;
import net.goo.brutality.client.renderers.layers.TheVoidLayer;
import net.goo.brutality.item.BrutalityArmorMaterials;
import net.goo.brutality.util.ModUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntityRenderer.class})
public abstract class LivingEntityRendererMixin<T extends LivingEntity, M extends EntityModel<T>> {
    @Shadow
    public abstract boolean m_115326_(RenderLayer<T, M> var1);

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onInit(EntityRendererProvider.Context context, EntityModel<T> model, float shadowRadius, CallbackInfo ci) {
        LivingEntityRenderer renderer = (LivingEntityRenderer)this;
        this.m_115326_(new StarLayer(context, renderer));
        this.m_115326_(new StickyBombLayer(context, renderer));
        this.m_115326_(new LightBoundLayer(context, renderer));
        this.m_115326_(new EyeOfViolenceLayer(renderer));
        this.m_115326_(new TheVoidLayer(renderer));
        if (this instanceof PlayerRenderer) {
            this.m_115326_(new EnragedOverlayLayer(renderer));
        }
    }

    @Inject(method={"isBodyVisible"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyIsBodyVisible(T pLivingEntity, CallbackInfoReturnable<Boolean> cir) {
        if (ModUtils.hasFullArmorSet(pLivingEntity, BrutalityArmorMaterials.NOIR)) {
            cir.setReturnValue((Object)false);
        }
    }
}

