/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.mixin;

import com.google.common.collect.Multimap;
import java.util.UUID;
import net.goo.brutality.item.weapon.axe.RhittaAxe;
import net.goo.brutality.item.weapon.hammer.JackpotHammer;
import net.goo.brutality.util.ModUtils;
import net.goo.brutality.util.SealUtils;
import net.goo.brutality.util.helpers.NbtHelper;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Unique
    private static final UUID BASE_ATTACK_DAMAGE_UUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    @Unique
    private static final UUID BASE_ATTACK_SPEED_UUID = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");

    @Shadow
    public abstract Item m_41720_();

    @Inject(method={"getAttributeModifiers"}, at={@At(value="RETURN")}, cancellable=true)
    private void addSealAttributeModifiers(EquipmentSlot pSlot, CallbackInfoReturnable<Multimap<Attribute, AttributeModifier>> cir) {
        ItemStack stack = (ItemStack)this;
        SealUtils.SEAL_TYPE sealType = SealUtils.getSealType(stack);
        SealUtils.handleSealAttributes(sealType, stack, pSlot, cir);
    }

    @Redirect(method={"getTooltipLines"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getAttributeBaseValue(Lnet/minecraft/world/entity/ai/attributes/Attribute;)D", ordinal=0))
    private double modifyBaseDamageValue(Player player, Attribute attribute) {
        if (attribute == Attributes.f_22281_) {
            ItemStack stack = (ItemStack)this;
            double itemBase = 0.0;
            block0: for (EquipmentSlot slot : EquipmentSlot.values()) {
                Multimap modifiers = stack.m_41638_(slot);
                for (AttributeModifier mod : modifiers.get((Object)Attributes.f_22281_)) {
                    if (!mod.m_22209_().equals(BASE_ATTACK_DAMAGE_UUID)) continue;
                    itemBase = mod.m_22218_();
                    continue block0;
                }
            }
            double modified = itemBase;
            if (stack.m_41720_() instanceof RhittaAxe) {
                modified += (double)RhittaAxe.computeAttackDamageBonus(player.m_9236_());
            } else if (stack.m_41720_() instanceof JackpotHammer) {
                modified = JackpotHammer.getRandomDamage(player);
            }
            modified = ModUtils.computeAttributes(player, stack, modified);
            return (modified += player.m_21172_(Attributes.f_22281_)) - itemBase;
        }
        return player.m_21172_(attribute);
    }

    @Inject(method={"getMaxDamage()I"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetMaxDamage(CallbackInfoReturnable<Integer> cir) {
        ItemStack stack = (ItemStack)this;
        boolean fromDoubleDown = NbtHelper.getBool(stack, "fromDoubleDown", false);
        if (fromDoubleDown) {
            int original = this.m_41720_().getMaxDamage(stack);
            cir.setReturnValue((Object)Math.min(50, original));
        }
    }

    @Inject(method={"isEnchantable"}, at={@At(value="HEAD")}, cancellable=true)
    private void restrictDoubleDown(CallbackInfoReturnable<Boolean> cir) {
        if (NbtHelper.getBool((ItemStack)this, "fromDoubleDown", false)) {
            cir.setReturnValue((Object)false);
        }
    }
}

