/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.goo.brutality.item.weapon.axe.Deathsaw;
import net.goo.brutality.item.weapon.generic.LastPrism;
import net.goo.brutality.item.weapon.spear.RhongomyniadSpear;
import net.goo.brutality.registry.BrutalityModItems;
import net.goo.brutality.util.phys.OrientedBoundingBox;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DebugRenderer.class})
public class DebugRendererMixin {
    @Inject(method={"render"}, at={@At(value="TAIL")})
    public void renderColliderDebug(PoseStack matrixStack, MultiBufferSource.BufferSource vertexConsumers, double cameraX, double cameraY, double cameraZ, CallbackInfo ci) {
        Camera camera;
        LocalPlayer player;
        Minecraft client = Minecraft.m_91087_();
        if (client.m_91290_().m_114377_() && (player = client.f_91074_) != null && (camera = client.f_91063_.m_109153_()).m_90593_()) {
            OrientedBoundingBox.TargetResult<LivingEntity> rayData = null;
            if (player.m_21055_((Item)BrutalityModItems.DEATHSAW.get())) {
                rayData = OrientedBoundingBox.findAttackTargetResult((Player)player, LivingEntity.class, Deathsaw.hitbox, 1.0);
            } else if (player.m_21055_((Item)BrutalityModItems.RHONGOMYNIAD.get())) {
                rayData = OrientedBoundingBox.findAttackTargetResult((Player)player, LivingEntity.class, RhongomyniadSpear.hitbox, 3.0);
            } else if (player.m_21055_((Item)BrutalityModItems.LAST_PRISM_ITEM.get())) {
                rayData = OrientedBoundingBox.findAttackTargetResult((Player)player, LivingEntity.class, LastPrism.hitbox, 3.0);
            }
            if (rayData != null) {
                Vec3 cameraOffset = camera.m_90583_().m_82548_();
                OrientedBoundingBox offsetObb = rayData.obb.offset(cameraOffset).updateVertex();
                this.brutality$drawOutline(matrixStack, offsetObb, !rayData.entities.isEmpty());
            }
        }
    }

    @Unique
    private void brutality$outlineOBB(PoseStack matrixStack, OrientedBoundingBox box, BufferBuilder buffer, float red1, float green1, float blue1, float red2, float green2, float blue2, float alpha) {
        Matrix4f matrix4f = matrixStack.m_85850_().m_252922_();
        buffer.m_252986_(matrix4f, (float)box.vertex1.f_82479_, (float)box.vertex1.f_82480_, (float)box.vertex1.f_82481_).m_6122_(0, 0, 0, 0).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex1.f_82479_, (float)box.vertex1.f_82480_, (float)box.vertex1.f_82481_).m_85950_(red1, green1, blue1, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex2.f_82479_, (float)box.vertex2.f_82480_, (float)box.vertex2.f_82481_).m_85950_(red1, green1, blue1, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex3.f_82479_, (float)box.vertex3.f_82480_, (float)box.vertex3.f_82481_).m_85950_(red1, green1, blue1, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex4.f_82479_, (float)box.vertex4.f_82480_, (float)box.vertex4.f_82481_).m_85950_(red1, green1, blue1, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex1.f_82479_, (float)box.vertex1.f_82480_, (float)box.vertex1.f_82481_).m_85950_(red1, green1, blue1, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex5.f_82479_, (float)box.vertex5.f_82480_, (float)box.vertex5.f_82481_).m_85950_(red2, green2, blue2, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex6.f_82479_, (float)box.vertex6.f_82480_, (float)box.vertex6.f_82481_).m_85950_(red2, green2, blue2, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex2.f_82479_, (float)box.vertex2.f_82480_, (float)box.vertex2.f_82481_).m_85950_(red1, green1, blue1, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex6.f_82479_, (float)box.vertex6.f_82480_, (float)box.vertex6.f_82481_).m_85950_(red2, green2, blue2, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex7.f_82479_, (float)box.vertex7.f_82480_, (float)box.vertex7.f_82481_).m_85950_(red2, green2, blue2, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex3.f_82479_, (float)box.vertex3.f_82480_, (float)box.vertex3.f_82481_).m_85950_(red1, green1, blue1, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex7.f_82479_, (float)box.vertex7.f_82480_, (float)box.vertex7.f_82481_).m_85950_(red2, green2, blue2, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex8.f_82479_, (float)box.vertex8.f_82480_, (float)box.vertex8.f_82481_).m_85950_(red2, green2, blue2, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex4.f_82479_, (float)box.vertex4.f_82480_, (float)box.vertex4.f_82481_).m_85950_(red1, green1, blue1, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex8.f_82479_, (float)box.vertex8.f_82480_, (float)box.vertex8.f_82481_).m_85950_(red2, green2, blue2, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex5.f_82479_, (float)box.vertex5.f_82480_, (float)box.vertex5.f_82481_).m_85950_(red2, green2, blue2, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex5.f_82479_, (float)box.vertex5.f_82480_, (float)box.vertex5.f_82481_).m_6122_(0, 0, 0, 0).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.center.f_82479_, (float)box.center.f_82480_, (float)box.center.f_82481_).m_6122_(0, 0, 0, 0).m_5752_();
    }

    @Unique
    private void brutality$look(PoseStack matrixStack, OrientedBoundingBox box, BufferBuilder buffer, float alpha) {
        Matrix4f matrix4f = matrixStack.m_85850_().m_252922_();
        buffer.m_252986_(matrix4f, (float)box.center.f_82479_, (float)box.center.f_82480_, (float)box.center.f_82481_).m_85950_(0.0f, 0.0f, 0.0f, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.center.f_82479_, (float)box.center.f_82480_, (float)box.center.f_82481_).m_85950_(1.0f, 0.0f, 0.0f, alpha).m_5752_();
        Vec3 zEnd = box.center.m_82549_(box.axisZ.m_82490_(1.0));
        buffer.m_252986_(matrix4f, (float)zEnd.f_82479_, (float)zEnd.f_82480_, (float)zEnd.f_82481_).m_85950_(1.0f, 0.0f, 0.0f, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.center.f_82479_, (float)box.center.f_82480_, (float)box.center.f_82481_).m_85950_(0.0f, 1.0f, 0.0f, alpha).m_5752_();
        Vec3 yEnd = box.center.m_82549_(box.axisY.m_82490_(1.0));
        buffer.m_252986_(matrix4f, (float)yEnd.f_82479_, (float)yEnd.f_82480_, (float)yEnd.f_82481_).m_85950_(0.0f, 1.0f, 0.0f, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.center.f_82479_, (float)box.center.f_82480_, (float)box.center.f_82481_).m_85950_(0.0f, 0.0f, 1.0f, alpha).m_5752_();
        Vec3 xEnd = box.center.m_82549_(box.axisX.m_82490_(1.0));
        buffer.m_252986_(matrix4f, (float)xEnd.f_82479_, (float)xEnd.f_82480_, (float)xEnd.f_82481_).m_85950_(0.0f, 0.0f, 1.0f, alpha).m_5752_();
    }

    @Unique
    private void brutality$drawOutline(PoseStack matrixStack, OrientedBoundingBox obb, boolean collides) {
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        RenderSystem.disableBlend();
        RenderSystem.lineWidth((float)1.0f);
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        if (collides) {
            this.brutality$outlineOBB(matrixStack, obb, bufferBuilder, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.5f);
        } else {
            this.brutality$outlineOBB(matrixStack, obb, bufferBuilder, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.5f);
        }
        this.brutality$look(matrixStack, obb, bufferBuilder, 0.5f);
        tesselator.m_85914_();
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.enableBlend();
    }
}

